/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.DeploymentClassLocator;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.util.ClassFileCache;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class ProjectClassLocator
extends BaseClassLocator {
    protected static final boolean EXPORTED_LIBRARIES = true;
    protected static final boolean ALL_LIBRARIES = false;
    private final Project _project;
    private final BaseClassLocator _jdkLocator;
    private final BaseClassLocator _libraryLocator;
    private final BaseClassLocator _deploymentLocator;
    private final BaseClassLocator _dependentLibraryLocator;
    private final BaseClassLocator _dependentPathLocator;
    private final BaseClassLocator _outputLocator;
    private final BaseClassLocator _addedClassLocator;
    private final BaseClassLocator _moduleConfigLocator;
    private final BaseClassLocator _sourceLocator;

    protected static ProjectClassLocator getInstance(Project project) {
        try {
            return ProjectClassLocator.getInstanceImpl(project, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static ProjectClassLocator getInstanceInterruptibly(Project project) throws InterruptedException {
        return ProjectClassLocator.getInstanceImpl(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectClassLocator getInstanceImpl(Project project, boolean checkInterrupt) throws InterruptedException {
        if (project == null) {
            throw new NullArgumentException("null project");
        }
        PerformanceLogger.get().startTiming("ProjectClassLocator.getInstanceImpl");
        try {
            URLPath moduleConfigPath;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            Library jdkLibrary = ProjectClassLocator.getJDKFor(project);
            BaseClassLocator jdkLocator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(jdkLibrary));
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            Library[] libraries = ProjectClassLocator.getLibrariesFor(project, false);
            BaseClassLocator libraryLocator = checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocatorInterruptibly(libraries)) : ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(libraries));
            ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URL outputURL = ProjectClassLocator.getOutputURLFor(project);
            BaseClassLocator outputLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(outputURL));
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            BaseClassLocator moduleConfigLocator = (moduleConfigPath = ProjectClassLocator.getModuleConfigClassPathFor(project)) != null ? (checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocatorInterruptibly(moduleConfigPath)) : ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(moduleConfigPath))) : EMPTY_LOCATOR;
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URLPath additionalPath = ProjectClassLocator.getAddedClassPathFor(project);
            JLibraryManager mgr = JLibraryManager.getInstance();
            for (DynamicLibraryProvider provider : mgr.getDynamicLibraryProviders()) {
                provider.updateClassPath(project, additionalPath);
            }
            BaseClassLocator addedClassLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(additionalPath));
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            URLPath sourcePath = ProjectClassLocator.getSourcePathFor(project);
            BaseClassLocator sourceLocator = checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocatorInterruptibly(sourcePath)) : ProjectClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocator(sourcePath));
            ArrayList dependentLibraryList = new ArrayList(25);
            ArrayList<DeploymentClassLocator.DeploymentPaths> deploymentList = new ArrayList<DeploymentClassLocator.DeploymentPaths>();
            URLPath dependentSourcePath = new URLPath(50);
            URLPath dependentClassPath = new URLPath(50);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            ProjectClassLocator.processDependenciesRecurse(project, new ArrayList(), dependentLibraryList, deploymentList, dependentSourcePath, dependentClassPath, false, checkInterrupt);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            List<Library> libraryCollection = libraries == null ? EMPTY_COLLECTION : Arrays.asList(libraries);
            dependentLibraryList.removeAll(libraryCollection);
            int dependentLibraryCount = dependentLibraryList.size();
            Library[] dependentLibraries = dependentLibraryList.toArray(new Library[dependentLibraryCount]);
            BaseClassLocator dependentLibraryLocator = checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocatorInterruptibly(dependentLibraries)) : ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(dependentLibraries));
            BaseClassLocator deploymentLocator = checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)DeploymentClassLocator.getInstanceInterruptibly(deploymentList)) : ProjectClassLocator.ensureValid((BaseClassLocator)DeploymentClassLocator.getInstance(deploymentList));
            dependentSourcePath.remove(sourcePath);
            dependentClassPath.remove(additionalPath);
            dependentClassPath.remove(outputURL);
            if (checkInterrupt) {
                ProjectClassLocator.checkInterrupt();
            }
            BaseClassLocator dependentPathLocator = checkInterrupt ? ProjectClassLocator.ensureValid((BaseClassLocator)factory.getPathLocatorInterruptibly(dependentSourcePath, dependentClassPath)) : ProjectClassLocator.ensureValid((BaseClassLocator)factory.getPathLocator(dependentSourcePath, dependentClassPath));
            ProjectClassLocator projectClassLocator = new ProjectClassLocator(project, jdkLocator, libraryLocator, outputLocator, moduleConfigLocator, addedClassLocator, sourceLocator, dependentLibraryLocator, deploymentLocator, dependentPathLocator);
            return projectClassLocator;
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getInstanceImpl", "ProjectClassLocator() for " + project.getShortLabel());
        }
    }

    private ProjectClassLocator(Project project, BaseClassLocator jdkLocator, BaseClassLocator libraryLocator, BaseClassLocator outputLocator, BaseClassLocator moduleConfigLocator, BaseClassLocator addedClassLocator, BaseClassLocator sourceLocator, BaseClassLocator dependentLibraryLocator, BaseClassLocator deploymentLocator, BaseClassLocator dependentPathLocator) {
        this._project = project;
        this._jdkLocator = jdkLocator;
        this._libraryLocator = libraryLocator;
        this._outputLocator = outputLocator;
        this._moduleConfigLocator = moduleConfigLocator;
        this._addedClassLocator = addedClassLocator;
        this._sourceLocator = sourceLocator;
        this._dependentLibraryLocator = dependentLibraryLocator;
        this._deploymentLocator = deploymentLocator;
        this._dependentPathLocator = dependentPathLocator;
    }

    protected static void processDependenciesRecurse(Project project, List traversedList, List libraryList, List<DeploymentClassLocator.DeploymentPaths> deploymentList, URLPath sourcePath, URLPath classPath, boolean exportsOnly, boolean checkInterrupt) throws InterruptedException {
        Library[] libraries;
        if (traversedList.contains(project)) {
            return;
        }
        traversedList.add(project);
        if (checkInterrupt) {
            ProjectClassLocator.checkInterrupt();
        }
        int libraryCount = (libraries = ProjectClassLocator.getLibrariesFor(project, exportsOnly)) == null ? 0 : libraries.length;
        for (int i = 0; i < libraryCount; ++i) {
            Library library = libraries[i];
            if (libraryList.contains(library)) continue;
            libraryList.add(library);
        }
        if (checkInterrupt) {
            ProjectClassLocator.checkInterrupt();
        }
        URLPath currentSourcePath = ProjectClassLocator.getSourcePathFor(project);
        sourcePath.add(currentSourcePath);
        if (checkInterrupt) {
            ProjectClassLocator.checkInterrupt();
        }
        URL currentOutURL = ProjectClassLocator.getOutputURLFor(project);
        URLPath moduleConfigPath = ProjectClassLocator.getModuleConfigClassPathFor(project);
        URLPath currentAddedPath = ProjectClassLocator.getAddedClassPathFor(project);
        classPath.add(currentOutURL);
        if (moduleConfigPath != null) {
            classPath.add(moduleConfigPath);
        }
        classPath.add(currentAddedPath);
        if (checkInterrupt) {
            ProjectClassLocator.checkInterrupt();
        }
        Collection dependents = ProjectClassLocator.getDependentsFor(project);
        for (Object dependent : dependents) {
            if (dependent == null) continue;
            if (dependent instanceof ProjectLibrary) {
                Project dependentProject = (Project)((ProjectLibrary)dependent).getSource();
                ProjectClassLocator.processDependenciesRecurse(dependentProject, traversedList, libraryList, deploymentList, sourcePath, classPath, true, checkInterrupt);
                continue;
            }
            if (!(dependent instanceof Library) || libraryList.contains(dependent) || deploymentList.contains(dependent)) continue;
            Folder owner = ((Dependable)dependent).getSourceOwner();
            if (owner instanceof Project && ((Library)dependent).getSourcePath() == null) {
                URLPath deploymentClassPath = ((Library)dependent).getClassPath();
                URLPath deploymentSourcePath = ProjectClassLocator.getDeploymentSourcePathFor((Project)owner);
                deploymentList.add(new DeploymentClassLocator.DeploymentPaths(deploymentSourcePath, deploymentClassPath));
                continue;
            }
            libraryList.add(dependent);
        }
    }

    public static Collection getDependentsFor(Project project) {
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((Project)project);
        List dependList = dependencyConfiguration.getDependencyList();
        return dependList == null ? EMPTY_COLLECTION : dependList;
    }

    protected static URLPath getAddedClassPathFor(Project project) {
        JProjectPaths projectPaths = JProjectPaths.getInstance((PropertyStorage)project);
        return projectPaths.getAdditionalClassPath();
    }

    protected static URLPath getModuleConfigClassPathFor(Project project) {
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance(project);
        if (moduleConfig != null) {
            return moduleConfig.getClassPath();
        }
        return null;
    }

    protected static URL getOutputURLFor(Project project) {
        JavaProject javaProject = JavaProject.getInstance(project);
        return javaProject.getOutputDirectory();
    }

    public static URLPath getSourcePathFor(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        return pathsConfiguration.getProjectSourcePath();
    }

    protected static Library getJDKFor(Project project) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        return projectLibraries.getJDK();
    }

    private static URLPath getDeploymentSourcePathFor(Project project) {
        URLPath path = new URLPath(ProjectClassLocator.getSourcePathFor(project));
        for (Object dependency : ProjectClassLocator.getDependentsFor(project)) {
            if (!(dependency instanceof ProjectLibrary)) continue;
            Project dependencyProject = ((ProjectLibrary)dependency).getProject();
            path.add(ProjectClassLocator.getSourcePathFor(dependencyProject));
        }
        return path;
    }

    protected static Library[] getLibrariesFor(Project project, boolean exportsOnly) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        if (exportsOnly) {
            return projectLibraries.getExports();
        }
        return projectLibraries.getLibraries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndex() {
        PerformanceLogger.get().startTiming("ProjectClassLocator.buildIndex");
        try {
            this._sourceLocator.buildIndex();
            this._outputLocator.buildIndex();
            this._moduleConfigLocator.buildIndex();
            this._addedClassLocator.buildIndex();
            this._libraryLocator.buildIndex();
            this._jdkLocator.buildIndex();
            this._dependentLibraryLocator.buildIndex();
            this._deploymentLocator.buildIndex();
            this._dependentPathLocator.buildIndex();
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.buildIndex", "ProjectClassLocator.buildIndex() for " + this._project.getShortLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildIndexInterruptibly() throws InterruptedException {
        PerformanceLogger.get().startTiming("ProjectClassLocator.buildIndex");
        try {
            ProjectClassLocator.checkInterrupt();
            this._sourceLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._outputLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._moduleConfigLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._addedClassLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._libraryLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._jdkLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._dependentLibraryLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._deploymentLocator.buildIndexInterruptibly();
            ProjectClassLocator.checkInterrupt();
            this._dependentPathLocator.buildIndexInterruptibly();
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.buildIndex", "ProjectClassLocator.buildIndex() for " + this._project.getShortLabel());
        }
    }

    protected void getPackages(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getPackages(packagePrefix, out);
        this._outputLocator.getPackages(packagePrefix, out);
        this._moduleConfigLocator.getPackages(packagePrefix, out);
        this._addedClassLocator.getPackages(packagePrefix, out);
        this._dependentPathLocator.getPackages(packagePrefix, out);
        this._dependentLibraryLocator.getPackages(packagePrefix, out);
        this._deploymentLocator.getPackages(packagePrefix, out);
        this._libraryLocator.getPackages(packagePrefix, out);
        this._jdkLocator.getPackages(packagePrefix, out);
    }

    protected void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependentPathLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependentLibraryLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getPackagesInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
        this._outputLocator.getClassesInPackage(packagePrefix, out);
        this._moduleConfigLocator.getClassesInPackage(packagePrefix, out);
        this._addedClassLocator.getClassesInPackage(packagePrefix, out);
        this._dependentPathLocator.getClassesInPackage(packagePrefix, out);
        this._dependentLibraryLocator.getClassesInPackage(packagePrefix, out);
        this._deploymentLocator.getClassesInPackage(packagePrefix, out);
        this._libraryLocator.getClassesInPackage(packagePrefix, out);
        this._jdkLocator.getClassesInPackage(packagePrefix, out);
    }

    protected void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependentPathLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._dependentLibraryLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getClassesInPackageInterruptibly(packagePrefix, out);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        PerformanceLogger.get().startTiming("ProjectClassLocator.getAllClasses");
        try {
            this._sourceLocator.getAllClasses(out, filter);
            this._outputLocator.getAllClasses(out, filter);
            this._moduleConfigLocator.getAllClasses(out, filter);
            this._addedClassLocator.getAllClasses(out, filter);
            this._dependentPathLocator.getAllClasses(out, filter);
            this._dependentLibraryLocator.getAllClasses(out, filter);
            this._deploymentLocator.getAllClasses(out, filter);
            this._libraryLocator.getAllClasses(out, filter);
            this._jdkLocator.getAllClasses(out, filter);
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getAllClasses", "ProjectClassLocator.getAllClasses() for " + this._project.getShortLabel() + ": " + out.size() + " classes found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        PerformanceLogger.get().startTiming("ProjectClassLocator.getAllClassesInterruptibly");
        try {
            ProjectClassLocator.checkInterrupt();
            this._sourceLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._outputLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._moduleConfigLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._addedClassLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._dependentPathLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._dependentLibraryLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._deploymentLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._libraryLocator.getAllClassesInterruptibly(out, filter);
            ProjectClassLocator.checkInterrupt();
            this._jdkLocator.getAllClassesInterruptibly(out, filter);
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getAllClassesInterruptibly", "ProjectClassLocator.getAllClassesInterruptibly() for " + this._project.getShortLabel() + ": " + out.size() + " classes found");
        }
    }

    protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._sourceLocator.getAllPackages(out, filter);
        this._outputLocator.getAllPackages(out, filter);
        this._moduleConfigLocator.getAllPackages(out, filter);
        this._addedClassLocator.getAllPackages(out, filter);
        this._dependentPathLocator.getAllPackages(out, filter);
        this._dependentLibraryLocator.getAllPackages(out, filter);
        this._deploymentLocator.getAllPackages(out, filter);
        this._libraryLocator.getAllPackages(out, filter);
        this._jdkLocator.getAllPackages(out, filter);
    }

    protected void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        this._sourceLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._outputLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._moduleConfigLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._addedClassLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._dependentPathLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._dependentLibraryLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._deploymentLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._libraryLocator.getAllPackagesInterruptibly(out, filter);
        ProjectClassLocator.checkInterrupt();
        this._jdkLocator.getAllPackagesInterruptibly(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL classURL = this._outputLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (classURL != null || sourceURL != null) {
            return this.chooseURL(fqClassName, classURL, sourceURL);
        }
        classURL = this._jdkLocator.getURL(fqClassName);
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentPathLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentLibraryLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getURL(fqClassName);
        }
        return classURL;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        URL classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        ProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        if (classURL != null || sourceURL != null) {
            return this.chooseURL(fqClassName, classURL, sourceURL);
        }
        ProjectClassLocator.checkInterrupt();
        classURL = this._jdkLocator.getURLInterruptibly(fqClassName);
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._addedClassLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._dependentPathLocator.getURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._dependentLibraryLocator.getURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._deploymentLocator.getURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            ProjectClassLocator.checkInterrupt();
            classURL = this._libraryLocator.getURLInterruptibly(fqClassName);
        }
        return classURL;
    }

    private URL chooseURL(String fqClassName, URL classURL, URL sourceURL) {
        long sourceTime;
        if (classURL == null) {
            return sourceURL;
        }
        if (sourceURL == null && (sourceURL = this.getSourceURLfromClassFile(classURL, fqClassName)) == null) {
            return classURL;
        }
        long classTime = URLFileSystem.lastModified((URL)classURL);
        Node node = NodeFactory.find((URL)sourceURL);
        long l = sourceTime = node != null && node.isOpen() ? node.getTimestamp() : URLFileSystem.lastModified((URL)sourceURL);
        if (classTime >= sourceTime) {
            return classURL;
        }
        return sourceURL;
    }

    public URL getProjectSourceURL(String fqClassName, boolean includeDependencies) {
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (sourceURL == null && includeDependencies) {
            sourceURL = this._dependentPathLocator.getSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getProjectSourceURLInterruptibly(String fqClassName, boolean includeDependencies) throws InterruptedException {
        ProjectClassLocator.checkInterrupt();
        URL sourceURL = this._sourceLocator.getSourceURLInterruptibly(fqClassName);
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null && includeDependencies) {
            sourceURL = this._dependentPathLocator.getSourceURLInterruptibly(fqClassName);
        }
        return sourceURL;
    }

    public URL getNonProjectSourceURL(String fqClassName) {
        URL sourceURL = this._jdkLocator.getSourceURL(fqClassName);
        if (sourceURL == null) {
            sourceURL = this._dependentLibraryLocator.getSourceURL(fqClassName);
        }
        if (sourceURL == null) {
            sourceURL = this._deploymentLocator.getSourceURL(fqClassName);
        }
        if (sourceURL == null) {
            sourceURL = this._libraryLocator.getSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getNonProjectSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL = this._jdkLocator.getSourceURLInterruptibly(fqClassName);
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this._dependentLibraryLocator.getSourceURLInterruptibly(fqClassName);
        }
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this._deploymentLocator.getSourceURLInterruptibly(fqClassName);
        }
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this._libraryLocator.getSourceURLInterruptibly(fqClassName);
        }
        return sourceURL;
    }

    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this.getProjectSourceURL(fqClassName, true);
        if (sourceURL == null) {
            sourceURL = this.getNonProjectSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL = this.getProjectSourceURLInterruptibly(fqClassName, true);
        ProjectClassLocator.checkInterrupt();
        if (sourceURL == null) {
            sourceURL = this.getNonProjectSourceURLInterruptibly(fqClassName);
        }
        return sourceURL;
    }

    public URL getClassURL(String fqClassName) {
        URL classURL = this._jdkLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._outputLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentPathLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentLibraryLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getClassURL(fqClassName);
        }
        return classURL;
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        URL classURL = this._jdkLocator.getClassURLInterruptibly(fqClassName);
        if (classURL == null) {
            classURL = this._outputLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentPathLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentLibraryLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._deploymentLocator.getClassURLInterruptibly(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getClassURLInterruptibly(fqClassName);
        }
        return classURL;
    }

    public URL getResourceURL(String resourceName) {
        URL resourceURL = this._jdkLocator.getResourceURL(resourceName);
        if (resourceURL == null) {
            resourceURL = this._outputLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._moduleConfigLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._addedClassLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._dependentPathLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._dependentLibraryLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._deploymentLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._libraryLocator.getResourceURL(resourceName);
        }
        return resourceURL;
    }

    private URL getSourceURLfromClassFile(URL classURL, String fqClassName) {
        String sourceFileName;
        ClassFile classFile;
        int dot = fqClassName.lastIndexOf(46);
        if (dot > 0 && (classFile = ClassFileCache.getClassFile((URL)classURL)) != null && (sourceFileName = classFile.getSourceFilename()) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(fqClassName.substring(0, dot + 1));
            dot = sourceFileName.lastIndexOf(46);
            if (dot > 0) {
                buf.append(sourceFileName.substring(0, dot));
            } else {
                buf.append(sourceFileName);
            }
            return this._sourceLocator.getSourceURL(buf.toString());
        }
        return null;
    }
}

