/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.ArrayClassLocator;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;

final class DeploymentClassLocator
extends BaseClassLocator {
    private BaseClassLocator _sourceLocator;
    private BaseClassLocator _classLocator;

    public static DeploymentClassLocator getInstance(DeploymentPaths paths) {
        return new DeploymentClassLocator(paths);
    }

    public static BaseClassLocator getInstance(List<DeploymentPaths> paths) {
        try {
            return DeploymentClassLocator.getInstanceImpl(paths, false);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static BaseClassLocator getInstanceInterruptibly(List<DeploymentPaths> paths) throws InterruptedException {
        return DeploymentClassLocator.getInstanceImpl(paths, true);
    }

    private static BaseClassLocator getInstanceImpl(List<DeploymentPaths> paths, boolean checkInterrupt) throws InterruptedException {
        if (paths != null) {
            if (paths.isEmpty()) {
                return BaseClassLocator.EMPTY_LOCATOR;
            }
            int libraryCount = paths.size();
            BaseClassLocator[] locators = new BaseClassLocator[libraryCount];
            for (int i = 0; i < libraryCount; ++i) {
                if (checkInterrupt && Thread.interrupted()) {
                    throw new InterruptedException();
                }
                DeploymentClassLocator locator = DeploymentClassLocator.getInstance(paths.get(i));
                locators[i] = locator != null ? locator : BaseClassLocator.EMPTY_LOCATOR;
            }
            return new ArrayClassLocator(locators);
        }
        return null;
    }

    private DeploymentClassLocator(DeploymentPaths paths) {
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._sourceLocator = DeploymentClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocator(paths.sourcePath));
        this._classLocator = DeploymentClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(paths.classPath));
    }

    public void buildIndex() {
        this._classLocator.buildIndex();
    }

    public void buildIndexInterruptibly() throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.buildIndex();
    }

    protected void getPackages(String packagePrefix, Collection<String> out) {
        this._classLocator.getPackages(packagePrefix, out);
    }

    protected void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getPackagesInterruptibly(packagePrefix, out);
    }

    protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        this._classLocator.getClassesInPackage(packagePrefix, out);
    }

    protected void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getClassesInPackageInterruptibly(packagePrefix, out);
    }

    protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this._classLocator.getAllClasses(out, filter);
    }

    protected void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getAllClassesInterruptibly(out, filter);
    }

    protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this._classLocator.getAllPackages(out, filter);
    }

    protected void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        DeploymentClassLocator.checkInterrupt();
        this._classLocator.getAllPackagesInterruptibly(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL sourceURL;
        URL classURL = this.getClassURL(fqClassName);
        if (classURL != null && (sourceURL = this.getSourceURL(fqClassName)) != null) {
            return sourceURL;
        }
        return classURL;
    }

    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        URL sourceURL;
        URL classURL = this.getClassURLInterruptibly(fqClassName);
        if (classURL != null && (sourceURL = this.getSourceURLInterruptibly(fqClassName)) != null) {
            return sourceURL;
        }
        return classURL;
    }

    public URL getSourceURL(String fqClassName) {
        return this.getClassURL(fqClassName) != null ? this._sourceLocator.getSourceURL(fqClassName) : null;
    }

    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getClassURLInterruptibly(fqClassName) != null ? this._sourceLocator.getSourceURLInterruptibly(fqClassName) : null;
    }

    public URL getClassURL(String fqClassName) {
        return this._classLocator.getClassURL(fqClassName);
    }

    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this._classLocator.getClassURLInterruptibly(fqClassName);
    }

    public URL getResourceURL(String resourceName) {
        return this._classLocator.getResourceURL(resourceName);
    }

    static final class DeploymentPaths {
        private final URLPath sourcePath;
        private final URLPath classPath;

        DeploymentPaths(URLPath sourcePath, URLPath classPath) {
            this.sourcePath = sourcePath;
            this.classPath = classPath;
        }
    }
}

