/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.util.Encodings;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;

public class BuildSystemConfiguration
extends HashStructureAdapter {
    private PropertyStorage project;

    private BuildSystemConfiguration(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.project = project;
    }

    public static BuildSystemConfiguration getInstance(PropertyStorage project) {
        return new BuildSystemConfiguration(BuildSystemConfiguration.findOrCreate((PropertyStorage)project, (String)OjcConfiguration.DATA_KEY), project);
    }

    public boolean isJDK12OrHigher() {
        return this.getJdkVersion().compareTo("1.2") >= 0;
    }

    public boolean isJDK13OrHigher() {
        return this.getJdkVersion().compareTo("1.3") >= 0;
    }

    public boolean isJDK14OrHigher() {
        return this.getJdkVersion().compareTo("1.4") >= 0;
    }

    public boolean isJDK15() {
        return this.getJdkVersion().startsWith("1.5");
    }

    public boolean isJDK15OrHigher() {
        return this.getJdkVersion().compareTo("1.5") >= 0;
    }

    public boolean isJDK16() {
        return this.getJdkVersion().startsWith("1.6");
    }

    public boolean isJDK16OrHigher() {
        return this.getJdkVersion().compareTo("1.6") >= 0;
    }

    public boolean isJDK17() {
        return this.getJdkVersion().startsWith("1.7");
    }

    public boolean isJDK17OrHigher() {
        return this.getJdkVersion().compareTo("1.7") >= 0;
    }

    private String getJdkVersion() {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance(this.project);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver.toString();
        }
        return "1.1";
    }

    public String[] getTargets() {
        String v = this.getJdkVersion();
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_TARGETS[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_TARGETS.length; ++i) {
            if (OjcConfiguration.DEFAULT_TARGETS[i].compareTo(v) > 0) continue;
            result.add(OjcConfiguration.DEFAULT_TARGETS[i]);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public String getTargetString() {
        String target = this._hash.getString("target");
        if (target == null) {
            String source = this._hash.getString("source");
            target = source == null ? "Default" : source;
        }
        return target;
    }

    public String getTarget() {
        String target = this.getTargetString();
        String jdkVersion = this.getJdkVersion().substring(0, 3);
        if (target.equals("Default")) {
            target = jdkVersion.compareTo("1.5") >= 0 ? jdkVersion : (jdkVersion.compareTo("1.2") >= 0 ? "1.2" : "1.1");
        } else if (target.substring(0, 3).compareTo(jdkVersion) > 0) {
            target = jdkVersion;
        }
        return target;
    }

    public void setTarget(String target) {
        if (target != null) {
            this._hash.putString("target", target);
        } else {
            this._hash.remove("target");
        }
    }

    public String[] getSources() {
        String v = this.getJdkVersion();
        ArrayList<String> result = new ArrayList<String>();
        result.add(OjcConfiguration.DEFAULT_SOURCES[0]);
        for (int i = 1; i < OjcConfiguration.DEFAULT_SOURCES.length; ++i) {
            if (OjcConfiguration.DEFAULT_SOURCES[i].compareTo(v) > 0) continue;
            result.add(OjcConfiguration.DEFAULT_SOURCES[i]);
        }
        String[] res = new String[result.size()];
        return result.toArray(res);
    }

    public String getSourceString() {
        String source = this._hash.getString("source");
        if (source == null) {
            String target = this._hash.getString("target");
            source = target == null ? "Default" : target;
        }
        return source;
    }

    public String getSource() {
        String source = this.getSourceString();
        String jdkVersion = this.getJdkVersion().substring(0, 3);
        if (source.equals("Default")) {
            source = jdkVersion.compareTo("1.5") >= 0 ? jdkVersion : (jdkVersion.compareTo("1.4") == 0 ? "1.3" : jdkVersion);
        } else if (source.substring(0, 3).compareTo(jdkVersion) > 0) {
            source = jdkVersion;
        }
        return source;
    }

    public void setSource(String source) {
        if (source != null) {
            this._hash.putString("source", source);
        } else {
            this._hash.remove("source");
        }
    }

    public String[] getCopyRes() {
        ListStructure list = this._hash.getListStructure("copyRes");
        if (list == null) {
            list = this._hash.getOrCreateListStructure("copyRes");
            this.initDefaultCopyRes(list);
        }
        return (String[])list.toArray((Object[])new String[list.size()]);
    }

    public void setCopyRes(String[] copyRes) {
        if (copyRes == null) {
            this._hash.remove("copyRes");
        } else {
            ListStructure list = this._hash.getOrCreateListStructure("copyRes");
            list.mirror(Arrays.asList(copyRes));
        }
    }

    private void initDefaultCopyRes(ListStructure list) {
        String[] imageExtensions = GraphicsUtils.getImageExtensions();
        for (int i = 0; i < imageExtensions.length; ++i) {
            list.addPlaceholder((Object)imageExtensions[i]);
        }
        list.addPlaceholder((Object)".properties");
        list.addPlaceholder((Object)".xml");
        list.addPlaceholder((Object)".ejx");
        list.addPlaceholder((Object)".xcfg");
        list.addPlaceholder((Object)".cpx");
        list.addPlaceholder((Object)".dcx");
        list.addPlaceholder((Object)".sva");
        list.addPlaceholder((Object)".wsdl");
        list.addPlaceholder((Object)".ini");
        list.addPlaceholder((Object)".tld");
        list.addPlaceholder((Object)".tag");
        list.addPlaceholder((Object)".xlf");
        list.addPlaceholder((Object)".xsl");
        list.addPlaceholder((Object)".xsd");
    }

    public boolean getReverseCopyRes() {
        return this._hash.getBoolean("reverseCopyRes", false);
    }

    public void setReverseCopyRes(boolean reverseCopyRes) {
        this._hash.putBoolean("reverseCopyRes", reverseCopyRes);
    }

    public String getCurrentEncoding() throws TransientMarker {
        String currentEncoding = this.getInternalEncoding();
        return currentEncoding == null || "Default".equals(currentEncoding) ? Encodings.getDefaultEncoding() : currentEncoding;
    }

    public void setCurrentEncoding(String currentEncoding) {
        if (currentEncoding == null) {
            currentEncoding = "Default";
        }
        this.setInternalEncoding(currentEncoding);
    }

    private String getInternalEncoding() {
        return this._hash.getString("internalEncoding", "Default");
    }

    private void setInternalEncoding(String encoding) {
        this._hash.putString("internalEncoding", encoding);
    }

    public String getCurrentWebIanaEncoding() {
        String enc = this._hash.getString("webIANAEncoding");
        if (enc == null) {
            enc = IdeUtil.getIdeIanaEncoding();
        }
        return enc;
    }

    public void setCurrentWebIanaEncoding(String encoding) {
        this._hash.putString("webIANAEncoding", encoding);
    }

    public boolean getOutOfProcess() {
        return this._hash.getBoolean("outOfProcess", false);
    }

    public void setOutOfProcess(boolean outOfProcess) {
        if (!outOfProcess) {
            this._hash.remove("outOfProcess");
        } else {
            this._hash.putBoolean("outOfProcess", outOfProcess);
        }
    }

    public String getOutOfProcessJavaOptions() {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        return this._hash.getString("outOfProcessJavaOptions", defaultOptions);
    }

    public void setOutOfProcessJavaOptions(String options) {
        String defaultOptions = System.getProperty("compiler.vmargs", "-Xmx512m");
        if (options == null || options.trim().length() == 0) {
            options = defaultOptions;
        }
        if (defaultOptions.equals(options)) {
            this._hash.remove("outOfProcessJavaOptions");
        } else {
            this._hash.putString("outOfProcessJavaOptions", options);
        }
    }
}

