/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

import java.util.Enumeration;
import java.util.Properties;
import oracle.dss.util.xdo.generator.pdf.PropsUtil;

public class FlashProcessorProps {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/template/flash/FlashProcessorProps.java /st_jdevadf_patchset_ias/1 2009/09/28 08:30:31 kmchorto Exp $";
    public String mSystemTempDir;
    public float mPageWidth;
    public float mPageHeight;
    public float mStartX;
    public float mStartY;
    public float mWidth;
    public float mHeight;

    public FlashProcessorProps() {
        this.init();
    }

    public void init() {
        this.mSystemTempDir = null;
        this.mPageWidth = 792.0f;
        this.mPageHeight = 612.0f;
        this.mStartX = 18.0f;
        this.mStartY = 18.0f;
        this.mWidth = -1.0f;
        this.mHeight = -1.0f;
    }

    public void setProperties(Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)props.get(key);
            this.setProperty(key, val);
        }
    }

    private boolean stringToBoolean(String b) {
        return b.equals("true");
    }

    public void setProperty(String key, String val) {
        if (key.equals("system-temp-dir")) {
            this.mSystemTempDir = val;
        } else if (key.equals("flash-page-width")) {
            this.mPageWidth = Float.valueOf(val).floatValue();
        } else if (key.equals("flash-page-height")) {
            this.mPageHeight = Float.valueOf(val).floatValue();
        } else if (key.equals("flash-startx")) {
            this.mStartX = Float.valueOf(val).floatValue();
        } else if (key.equals("flash-starty")) {
            this.mStartY = Float.valueOf(val).floatValue();
        } else if (key.equals("flash-width")) {
            this.mWidth = Float.valueOf(val).floatValue();
        } else if (key.equals("flash-height")) {
            this.mHeight = Float.valueOf(val).floatValue();
        }
    }

    public void getProperties(Properties props) {
        PropsUtil.putString(props, "system-temp-dir", this.mSystemTempDir);
        PropsUtil.putString(props, "flash-page-width", Float.toString(this.mStartX));
        PropsUtil.putString(props, "flash-page-height", Float.toString(this.mStartX));
        PropsUtil.putString(props, "flash-startx", Float.toString(this.mStartX));
        PropsUtil.putString(props, "flash-starty", Float.toString(this.mStartY));
        PropsUtil.putString(props, "flash-width", Float.toString(this.mWidth));
        PropsUtil.putString(props, "flash-height", Float.toString(this.mHeight));
    }
}

