/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.generator.pdf;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import oracle.dss.util.xdo.common.log.Logger;

public class PropsUtil {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/generator/pdf/PropsUtil.java /st_jdevadf_patchset_ias/1 2009/09/28 08:30:31 kmchorto Exp $";

    public static void putBoolean(Properties props, String name, boolean val) {
        props.put(name, val ? "true" : "false");
    }

    public static void putString(Properties props, String name, String val) {
        if (val == null) {
            props.put(name, "null(not set)");
        } else {
            props.put(name, val);
        }
    }

    public static void putInt(Properties props, String name, int val) {
        props.put(name, "" + val);
    }

    public static boolean getBoolean(Properties props, String name, boolean defval) {
        String val = (String)props.get(name);
        if (val == null) {
            return defval;
        }
        return val.equals("true");
    }

    public static String getString(Properties props, String name, String defval) {
        String val = (String)props.get(name);
        if (val == null) {
            return defval;
        }
        return val;
    }

    public static int getInt(Properties props, String name, int defval) {
        String val = (String)props.get(name);
        if (val == null) {
            return defval;
        }
        return Integer.parseInt(val);
    }

    public static void dump(Properties props, String title, OutputStream out) {
        PrintWriter w = new PrintWriter(out);
        w.println("[" + title + "]----------------------------------");
        String[] keys = PropsUtil.sort(props);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String val = (String)props.get(key);
            w.println(key + "=" + val);
        }
        w.println("");
        w.flush();
    }

    public static void dump(Properties props, String title, PrintWriter w) {
        w.println("[" + title + "]----------------------------------");
        String[] keys = PropsUtil.sort(props);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String val = (String)props.get(key);
            w.println(key + "=" + val);
        }
        w.println("");
        w.flush();
    }

    public static void log(Properties props, String title) {
        Logger.log("[" + title + "]----------------------------------", 1);
        String[] keys = PropsUtil.sort(props);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String val = (String)props.get(key);
            Logger.log(key + "=" + val, 1);
        }
        Logger.log("------------------------------------------------------", 1);
    }

    public static String[] sort(Properties props) {
        int i;
        Vector<String> v = new Vector<String>();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            v.addElement(key);
        }
        String[] a = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            a[i] = (String)v.elementAt(i);
        }
        for (i = 0; i < a.length; ++i) {
            for (int j = a.length - 1; j > i; --j) {
                if (a[j].compareTo(a[j - 1]) >= 0) continue;
                String tmp = a[j];
                a[j] = a[j - 1];
                a[j - 1] = tmp;
            }
        }
        return a;
    }
}

