/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.tmp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import oracle.dss.util.xdo.common.log.Logger;

public class TmpFile {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/tmp/TmpFile.java /st_jdevadf_patchset_ias/1 2009/09/28 08:30:31 kmchorto Exp $";
    private static int mUniqueId = 0;

    private static String getRandomPrefix() {
        String chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer prefix = new StringBuffer();
        try {
            Class<?> c = Class.forName("java.security.SecureRandom");
            Method m = c.getMethod("getInstance", String.class);
            Object sr = m.invoke(null, "SHA1PRNG");
            for (int i = 0; i < 10; ++i) {
                m = c.getMethod("nextInt", Integer.TYPE);
                Integer pos = (Integer)m.invoke(sr, new Integer(chars.length()));
                char ch = chars.charAt(pos);
                prefix.append(ch);
            }
        }
        catch (Exception e) {
            for (int i = 0; i < 10; ++i) {
                int pos = (int)(Math.random() * 100.0) % chars.length();
                char ch = chars.charAt(pos);
                prefix.append(ch);
            }
        }
        return prefix.toString();
    }

    public static File createTmpFile(String prefix, String suffix, String dir) throws IOException {
        File f = null;
        prefix = prefix + TmpFile.getRandomPrefix();
        try {
            Class<?> c = Class.forName("java.io.File");
            Method m = c.getMethod("createTempFile", String.class, String.class, File.class);
            f = (File)m.invoke(null, prefix, suffix, new File(dir));
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            f = TmpFile.createTmpFileJDK118(prefix, suffix, dir);
        }
        return f;
    }

    private static synchronized File createTmpFileJDK118(String prefix, String suffix, String dir) throws IOException {
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        String path = dir + prefix + Logger.getTimeStampStr() + mUniqueId + suffix;
        ++mUniqueId;
        File f = new File(path);
        FileOutputStream out = new FileOutputStream(f);
        out.close();
        return f;
    }
}

