/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import oracle.dss.util.xdo.common.config.ConfigLocation;
import oracle.dss.util.xdo.common.log.XDOLogImpl;

public class DebugUtil {
    public static final String DEBUG_CFG = "xdodebug.cfg";
    public static final String LOG_FILE = "xdo.log";
    private int mLogLevel = 1;
    private boolean mIsDebugMode = false;
    private String mLogDir = null;

    private void parseLine(String line) throws IOException {
        String val;
        String param;
        StringTokenizer st = new StringTokenizer(line, "=");
        try {
            param = st.nextToken().trim();
            val = st.nextToken().trim();
        }
        catch (Exception e) {
            return;
        }
        if (param.equals("LogLevel")) {
            if (val.equals("UNEXPECTED")) {
                this.mLogLevel = 6;
            } else if (val.equals("ERROR")) {
                this.mLogLevel = 5;
            } else if (val.equals("EXCEPTION")) {
                this.mLogLevel = 4;
            } else if (val.equals("EVENT")) {
                this.mLogLevel = 3;
            } else if (val.equals("PROCEDURE")) {
                this.mLogLevel = 2;
            } else if (val.equals("STATEMENT")) {
                this.mLogLevel = 1;
            } else if (val.equals("OFF")) {
                this.mLogLevel = 0;
            }
        } else if (param.equals("LogDir")) {
            this.mLogDir = val;
        }
    }

    public synchronized void checkConfigFile() {
        String debugCfg = ConfigLocation.getPath(2);
        if (debugCfg == null) {
            this.mIsDebugMode = false;
            this.mLogDir = null;
            this.mLogLevel = 1;
            return;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(debugCfg));
            while ((line = in.readLine()) != null) {
                this.parseLine(line);
            }
            in.close();
            this.mIsDebugMode = true;
        }
        catch (IOException e) {
            this.mIsDebugMode = false;
            this.mLogDir = null;
            this.mLogLevel = 1;
        }
    }

    public synchronized boolean isDebugMode() {
        return this.mIsDebugMode;
    }

    public synchronized String getLogDir() {
        return this.mLogDir;
    }

    public synchronized int getLogLevel() {
        return this.mLogLevel;
    }

    public synchronized InputStream logFile(InputStream in, String filename) {
        FileInputStream in_ret = null;
        FileOutputStream out = null;
        if (!this.mIsDebugMode) {
            return in;
        }
        String path = this.mLogDir + File.separator + filename;
        try {
            out = new FileOutputStream(path);
        }
        catch (IOException e) {
            return in;
        }
        try {
            byte[] buff = new byte[32768];
            int count = 0;
            while ((count = in.read(buff, 0, buff.length)) != -1) {
                out.write(buff, 0, count);
            }
            out.close();
            in_ret = new FileInputStream(path);
        }
        catch (IOException e) {
            in_ret = null;
        }
        return in_ret;
    }

    public synchronized Reader logFile(Reader in, String filename) {
        OutputStreamWriter w;
        InputStreamReader r_ret = null;
        if (!this.mIsDebugMode) {
            return in;
        }
        String path = this.mLogDir + File.separator + filename;
        try {
            FileOutputStream out = new FileOutputStream(path);
            w = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        catch (IOException e) {
            return in;
        }
        try {
            char[] buff = new char[32768];
            int count = 0;
            while ((count = in.read(buff, 0, buff.length)) != -1) {
                w.write(buff, 0, count);
            }
            w.close();
            FileInputStream fin = new FileInputStream(path);
            r_ret = new InputStreamReader((InputStream)fin, "UTF-8");
        }
        catch (IOException e) {
            r_ret = null;
        }
        return r_ret;
    }

    public synchronized void write(Object pThis, String pString, int pLevel) {
        if (this.mIsDebugMode && this.mLogDir != null) {
            try {
                String logPath = this.mLogDir + File.separator + LOG_FILE;
                FileOutputStream out = new FileOutputStream(logPath, true);
                PrintWriter w = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, "UTF-8"), true);
                XDOLogImpl.write(pThis, pString, pLevel, w);
                w.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

