/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.common.io;

import java.io.IOException;
import oracle.dss.util.xdo.common.io.RandomAccessFileOrMemory;
import oracle.dss.util.xdo.common.log.Logger;

public class ByteArray
implements RandomAccessFileOrMemory {
    public static final String RCS_ID = "$Header: dsstools/modules/dvt-utils/src/oracle/dss/util/xdo/common/io/ByteArray.java /st_jdevadf_patchset_ias/1 2009/09/28 08:30:31 kmchorto Exp $";
    private byte[] mBuf = null;
    private int mCurPos = -1;

    public ByteArray(byte[] buf) {
        this.mBuf = buf;
        this.mCurPos = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.mCurPos >= this.mBuf.length) {
            return -1;
        }
        int data = this.mBuf[this.mCurPos++] & 0xFF;
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ch;
        int size = b.length;
        int readSize = 0;
        for (int i = 0; i < size && (ch = this.read()) != -1; ++i) {
            b[i] = (byte)ch;
            ++readSize;
        }
        return readSize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ch;
        int readSize = 0;
        for (int i = 0; i < len && (ch = this.read()) != -1; ++i) {
            b[off + i] = (byte)ch;
            ++readSize;
        }
        return readSize;
    }

    @Override
    public void seek(long pos) throws IOException {
        int iPos = (int)pos;
        this.mCurPos = iPos >= this.mBuf.length ? this.mBuf.length : iPos;
    }

    @Override
    public long getFilePointer() {
        return this.mCurPos;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long pos = this.getFilePointer();
        this.seek(pos + (long)n);
        return (int)(this.getFilePointer() - pos);
    }

    @Override
    public long length() throws IOException {
        return this.mBuf.length;
    }

    @Override
    public void close() throws IOException {
        this.mBuf = null;
    }

    @Override
    public void write(int b) throws IOException {
        Logger.log("Not yet implemented method - ByteArray.write()", 5);
    }

    @Override
    public void write(byte[] b) throws IOException {
        Logger.log("Not yet implemented method - ByteArray.write()", 5);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Logger.log("Not yet implemented method - ByteArray.write()", 5);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        Logger.log("Not yet implemented method - ByteArray.write()", 5);
    }
}

