/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform.calcColumns;

import java.util.ArrayList;
import java.util.List;
import oracle.dss.util.transform.ColumnValue;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.calcColumns.CalcColumnMetadata;
import oracle.dss.util.transform.calcColumns.CalcColumnValue;
import oracle.dss.util.transform.calcColumns.ColumnMetadata;
import oracle.dss.util.transform.calcColumns.DataGroupSpec;

public abstract class DataGroupColumnMetadata
extends CalcColumnMetadata {
    private long m_groupCount = -1L;
    private List<ColumnMetadata> m_groupMetadata = null;

    public DataGroupColumnMetadata(DataGroupSpec spec) {
        super(spec);
    }

    public void setGroupCount(long count) {
        this.m_groupCount = count;
    }

    public long getGroupCount() throws TransformException {
        if (this.m_groupCount == -1L) {
            List<ColumnMetadata> groupMetadata = this.getDataGroupMetadata();
            this.m_groupCount = groupMetadata != null ? (long)groupMetadata.size() : 0L;
            return this.m_groupCount;
        }
        return this.m_groupCount;
    }

    public List<ColumnMetadata> getDataGroupMetadata() throws TransformException {
        if (this.m_groupMetadata != null) {
            return this.m_groupMetadata;
        }
        this.m_groupMetadata = new ArrayList<ColumnMetadata>();
        Object dataVal = null;
        String inputCol = null;
        List<ColumnValue> vals = super.getValues();
        List<CalcColumnValue> calcVals = super.getCalcColumnValues();
        Object val = null;
        int valCount = vals.size();
        for (int j = 0; j < valCount; ++j) {
            int size;
            int bucket;
            val = calcVals.get(j).getValue();
            if (!(val instanceof Number) || (bucket = ((Number)val).intValue()) < 0) continue;
            for (int i = size = this.m_groupMetadata.size(); i <= bucket; ++i) {
                this.m_groupMetadata.add(new ColumnMetadata());
            }
            inputCol = ((DataGroupSpec)this.getCalculatedColumnSpec()).getInputColumn();
            dataVal = vals.get(j).getValue();
            this.m_groupMetadata.get(bucket).update(vals.get(j), calcVals.get(j));
        }
        this.m_groupCount = this.m_groupMetadata.size();
        return this.m_groupMetadata;
    }

    @Override
    public void update(ColumnValue cv, CalcColumnValue ccv) throws TransformException {
        this.getColumnMetadata().update(cv, ccv);
    }
}

