/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import oracle.dss.util.transform.ColumnValues;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataTable;
import oracle.dss.util.transform.GetMemberInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.total.TotalMember;

public class Row
implements GetMemberInterface {
    private MemberCell[] m_members = null;
    private DataCell[] m_cells = null;
    private DataTable m_dataTable = null;
    private ColumnValues m_extraMembers = null;
    private ColumnValues m_calcMembers = null;

    public Row(MemberCell[] members, DataCell[] cells, ColumnValues extraMembers, DataTable dt) {
        this.setMembers(members);
        this.setCells(cells);
        this.setExtraMembers(extraMembers);
        this.m_dataTable = dt;
    }

    public Row(DataTable dt) {
        this.m_dataTable = dt;
    }

    public void release() {
        this.m_members = null;
        this.m_cells = null;
        this.m_dataTable = null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Row)) {
            return false;
        }
        Row row = (Row)obj;
        try {
            MemberCell[] members = this.getMembers();
            MemberCell otherMember = null;
            MemberInterface mi1 = null;
            MemberInterface mi2 = null;
            String val1 = null;
            String val2 = null;
            if (members != null) {
                for (int i = 0; i < members.length; ++i) {
                    if (members[i] == null) continue;
                    otherMember = row.getMemberCell(members[i].getMemberColumnName());
                    if (otherMember == null) {
                        return false;
                    }
                    mi1 = members[i].getMemberInterface();
                    if (mi1 == null) continue;
                    val1 = mi1.getValue();
                    mi2 = otherMember.getMemberInterface();
                    if (mi2 == null) {
                        return false;
                    }
                    val2 = mi2.getValue();
                    if (!(val1 == null ? val2 != null : !val1.equals(val2))) continue;
                    return false;
                }
            }
            DataCell[] data = this.getCells();
            DataCell otherCell = null;
            DataCellInterface di1 = null;
            DataCellInterface di2 = null;
            Object dataval1 = null;
            Object dataval2 = null;
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == null) continue;
                    otherCell = row.getCell(data[i].getDataCellColumnName());
                    if (otherCell == null) {
                        return false;
                    }
                    di1 = data[i].getDataCellInterface();
                    if (mi1 == null) continue;
                    dataval1 = di1.getData("dataValue");
                    di2 = otherCell.getDataCellInterface();
                    if (di2 == null) {
                        return false;
                    }
                    dataval2 = di2.getData("dataValue");
                    if (!(dataval1 == null ? dataval2 != null : !dataval1.equals(dataval2))) continue;
                    return false;
                }
            }
            if (!this.getExtraMembers().equals(row.getExtraMembers())) {
                return false;
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return true;
    }

    public void setCalcColumns(ColumnValues calcCols) {
        this.m_calcMembers = calcCols;
    }

    public void setExtraMembers(ColumnValues extraMembers) {
        this.m_extraMembers = extraMembers;
    }

    public ColumnValues getExtraMembers() {
        return this.m_extraMembers;
    }

    public void setMembers(MemberCell[] members) {
        this.m_members = members;
    }

    public void setCells(DataCell[] cells) {
        this.m_cells = cells;
    }

    public Object clone(DataTable dt) throws CloneNotSupportedException {
        MemberCell[] newMembers = new MemberCell[this.m_members.length];
        for (int i = 0; i < newMembers.length; ++i) {
            newMembers[i] = this.m_members[i];
        }
        DataCell[] newCells = null;
        if (this.m_cells != null) {
            newCells = new DataCell[this.m_cells.length];
            for (int i = 0; i < newCells.length; ++i) {
                newCells[i] = this.m_cells[i];
            }
        }
        ColumnValues newExtraMembers = (ColumnValues)(this.m_extraMembers != null ? this.m_extraMembers.clone() : null);
        ColumnValues newCalcColMembers = (ColumnValues)(this.m_calcMembers != null ? this.m_calcMembers.clone() : null);
        Row row = new Row(newMembers, newCells, newExtraMembers, dt);
        row.setCalcColumns(newCalcColMembers);
        return row;
    }

    public DataCell[] getCells() {
        return this.m_cells;
    }

    public MemberCell[] getMembers() {
        return this.m_members;
    }

    public String[] getColumns() {
        return this.m_dataTable.getColumns();
    }

    public Object getValue(String column) throws TransformException {
        MemberInterface mi = this.getMember(column);
        if (mi != null) {
            return mi.getMetadata("value");
        }
        DataCell dc = this.getCell(column);
        if (dc != null) {
            return dc.getDataCellInterface().getData("dataValue");
        }
        return this.m_calcMembers.getColumnValue(column);
    }

    public boolean isCalculatedValue() {
        if (this.m_members == null) {
            return false;
        }
        for (int i = 0; i < this.m_members.length; ++i) {
            if (!(this.m_members[i].getMemberInterface() instanceof TotalMember)) continue;
            return true;
        }
        return false;
    }

    public DataTable getDataTable() {
        return this.m_dataTable;
    }

    protected boolean insertData(DataCell[] cellsToInsert) {
        DataCell[] tempCells;
        if (cellsToInsert.length > this.m_cells.length) {
            int i;
            tempCells = new DataCell[cellsToInsert.length];
            for (i = 0; i < this.m_cells.length; ++i) {
                tempCells[i] = cellsToInsert[i] != null ? cellsToInsert[i] : this.m_cells[i];
            }
            for (i = this.m_cells.length; i < cellsToInsert.length; ++i) {
                this.m_cells[i] = cellsToInsert[i];
            }
        } else {
            boolean inserted = false;
            block2: for (int i = 0; i < cellsToInsert.length; ++i) {
                if (cellsToInsert[i] == null) continue;
                for (int j = 0; j < this.m_cells.length; ++j) {
                    if (this.m_cells[j] != null) continue;
                    inserted = true;
                    this.m_cells[j] = cellsToInsert[i];
                    continue block2;
                }
            }
            return inserted;
        }
        this.m_cells = tempCells;
        return true;
    }

    private boolean _isDataItem(String col, MemberInterface[] dataItems) throws TransformException {
        if (dataItems == null) {
            return false;
        }
        for (int i = 0; i < dataItems.length; ++i) {
            if (dataItems[i] == null || !col.equals(dataItems[i].getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean membersEqual(Row row, MemberInterface[] dataItems) throws TransformException {
        if (row == null) {
            return false;
        }
        if (this.m_members == null) {
            return row.m_members == null;
        }
        if (row.m_members == null) {
            return false;
        }
        int memberCount = this.m_members.length;
        if (memberCount != row.m_members.length) {
            return false;
        }
        for (int i = 0; i < memberCount; ++i) {
            if (this._isDataItem(this.m_members[i].getMemberColumnName(), dataItems) || row.inMemberList(this.m_members[i])) continue;
            return false;
        }
        int extraMemberCount = this.m_extraMembers.getLength();
        if (extraMemberCount != row.m_extraMembers.getLength()) {
            return false;
        }
        for (int i = 0; i < extraMemberCount; ++i) {
            if (this._isDataItem(this.m_extraMembers.getColumn(i), dataItems) || this.m_extraMembers.isIgnoredColumn(i) || row.inExtraMemberList(this.m_extraMembers.getValue(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean inMemberList(MemberCell mi) throws TransformException {
        for (int i = 0; i < this.m_members.length; ++i) {
            if (!mi.getMemberInterface().getValue().equals(this.m_members[i].getMemberInterface().getValue())) continue;
            return true;
        }
        return false;
    }

    protected boolean inExtraMemberList(Object value) throws TransformException {
        for (int i = 0; i < this.m_extraMembers.getLength(); ++i) {
            if (value == null || !value.equals(this.m_extraMembers.getValue(i))) continue;
            return true;
        }
        return false;
    }

    public MemberCell getMember(int i) {
        if (i >= 0 && i < this.m_members.length) {
            return this.m_members[i];
        }
        return null;
    }

    public DataCell getCell(int i) {
        if (i >= 0 && i < this.m_cells.length) {
            return this.m_cells[i];
        }
        return null;
    }

    public void setMember(int i, MemberCell member) {
        if (i < this.m_members.length) {
            this.m_members[i] = member;
        }
    }

    public void setCell(int i, DataCell cell) {
        if (i < this.m_cells.length) {
            this.m_cells[i] = cell;
        }
    }

    public MemberCell getMemberCell(String colName) {
        return this.getMember(this.m_dataTable.getMemberIndexFromID(colName));
    }

    @Override
    public MemberInterface getMember(String column) throws TransformException {
        MemberCell cell = this.getMemberCell(column);
        if (cell != null) {
            return cell.getMemberInterface();
        }
        return null;
    }

    public Object getExtraMemberValue(String colName) throws TransformException {
        return this.m_extraMembers != null ? this.m_extraMembers.getColumnValue(colName) : null;
    }

    public DataCell getCell(String colName) {
        return this.getCell(this.m_dataTable.getCellIndexFromID(colName));
    }
}

