/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.TransformException;

public class RepeatMap
extends HashMap<String, HashMap<QDRInterface, List<QDRInterface>>> {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, Boolean> m_cache = new HashMap();

    private boolean storeAndReturn(String layer, boolean retVal) {
        this.m_cache.put(layer, retVal);
        return retVal;
    }

    public boolean repeats(String layer) {
        Boolean answer = this.m_cache.get(layer);
        if (answer != null) {
            return answer;
        }
        HashMap tupleSets = (HashMap)super.get(layer);
        if (tupleSets == null) {
            return this.storeAndReturn(layer, false);
        }
        if (tupleSets.size() <= 1) {
            return this.storeAndReturn(layer, true);
        }
        Set keys = tupleSets.keySet();
        Iterator keyIter = keys.iterator();
        List firstVal = null;
        List currVal = null;
        while (keyIter.hasNext()) {
            currVal = (List)tupleSets.get(keyIter.next());
            if (firstVal == null) {
                firstVal = currVal;
                continue;
            }
            if (currVal.size() <= firstVal.size()) continue;
            firstVal = currVal;
        }
        keyIter = keys.iterator();
        while (keyIter.hasNext()) {
            currVal = (List)tupleSets.get(keyIter.next());
            if (firstVal.containsAll(currVal)) continue;
            return this.storeAndReturn(layer, false);
        }
        return this.storeAndReturn(layer, true);
    }

    public void addQDR(String layer, QDRInterface key, QDRInterface newTuple) {
        ArrayList<QDRInterface> qdrList;
        HashMap layerMap = (HashMap)super.get(layer);
        if (layerMap == null) {
            layerMap = new HashMap();
            super.put(layer, layerMap);
        }
        if ((qdrList = (ArrayList<QDRInterface>)layerMap.get(key)) == null) {
            qdrList = new ArrayList<QDRInterface>();
            layerMap.put(key, qdrList);
        }
        if (!qdrList.contains(newTuple)) {
            qdrList.add(newTuple);
        }
    }

    private QDRInterface[] getPostQDR(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String measLayer) throws TransformException {
        ArrayList<QDRInterface> qdrs = new ArrayList<QDRInterface>();
        QDR qdr = new QDR();
        boolean sawMeas = false;
        for (int e = 0; e < layout.length; ++e) {
            if (layout[e] == null) continue;
            for (int l = layout[e].length - 1; l >= 0; --l) {
                if (!layout[e][l].equals(measLayer)) {
                    qdr.addDimMemberPair(layout[e][l], (String)iter.getValue(layout[e][l]));
                }
                if (layer.equals(layout[e][l])) {
                    if ((sawMeas || layer.equals(measLayer)) && dataItems != null && dataItems.length > 0) {
                        QDRInterface qdrClone = null;
                        for (int i = 0; i < dataItems.length; ++i) {
                            try {
                                qdrClone = (QDRInterface)qdr.clone();
                            }
                            catch (CloneNotSupportedException ex) {
                                throw new TransformException(ex.getMessage(), ex);
                            }
                            qdrClone.addDimMemberPair(measLayer, dataItems[i].getValue());
                            qdrs.add(qdrClone);
                        }
                    } else {
                        qdrs.add(qdr);
                    }
                    return qdrs.toArray(new QDRInterface[0]);
                }
                if (!layout[e][l].equals(measLayer)) continue;
                sawMeas = true;
            }
        }
        return qdrs.toArray(new QDRInterface[0]);
    }

    private QDRInterface[] getPreQDR(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String measLayer) throws TransformException {
        ArrayList<QDRInterface> qdrs = new ArrayList<QDRInterface>();
        QDR qdr = new QDR();
        boolean sawMeas = false;
        for (int e = layout.length - 1; e >= 0; --e) {
            if (layout[e] == null) continue;
            for (int l = 0; l < layout[e].length; ++l) {
                if (layer.equals(layout[e][l])) {
                    if (sawMeas && dataItems != null && dataItems.length > 0) {
                        QDRInterface qdrClone = null;
                        for (int i = 0; i < dataItems.length; ++i) {
                            try {
                                qdrClone = (QDRInterface)qdr.clone();
                            }
                            catch (CloneNotSupportedException ex) {
                                throw new TransformException(ex.getMessage(), ex);
                            }
                            qdrClone.addDimMemberPair(measLayer, dataItems[i].getValue());
                            qdrs.add(qdrClone);
                        }
                    } else {
                        qdrs.add(qdr);
                    }
                    return qdrs.toArray(new QDRInterface[0]);
                }
                if (layout[e][l].equals(measLayer)) {
                    sawMeas = true;
                    continue;
                }
                qdr.addDimMemberPair(layout[e][l], (String)iter.getValue(layout[e][l]));
            }
        }
        return qdrs.toArray(new QDRInterface[0]);
    }

    public void createRepeatTableEntries(String layer, RowIterator iter, String[][] layout, MemberInterface[] dataItems, String meas) throws TransformException {
        Boolean val = this.m_cache.get(layer);
        if (val != null) {
            return;
        }
        QDRInterface[] qdrKeys = this.getPreQDR(layer, iter, layout, dataItems, meas);
        QDRInterface[] qdrValues = this.getPostQDR(layer, iter, layout, dataItems, meas);
        for (int i = 0; i < qdrKeys.length; ++i) {
            for (int j = 0; j < qdrValues.length; ++j) {
                this.addQDR(layer, qdrKeys[i], qdrValues[j]);
            }
        }
    }

    public void calculate() {
        Set layers = super.keySet();
        Iterator layerIter = layers.iterator();
        String layer = null;
        while (layerIter.hasNext()) {
            layer = (String)layerIter.next();
            this.repeats(layer);
        }
        super.clear();
    }
}

