/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.Utility;

public class QDRLite
implements Map<String, Object> {
    private List<String> m_columns = null;
    private List<Object> m_values = null;
    protected String m_dataLayer = null;

    public QDRLite() {
    }

    public QDRLite(String dataLayer) {
        this();
        this.m_dataLayer = dataLayer;
    }

    public QDRLite(QDRInterface qdr) {
        this(qdr instanceof QDR ? ((QDR)qdr).getMeasureDim() : null);
        Enumeration dims = qdr.getDimensions();
        String dim = null;
        Object value = null;
        QDRMember member = null;
        while (dims.hasMoreElements()) {
            dim = (String)dims.nextElement();
            member = qdr.getDimMember(dim);
            value = member != null ? member.getData() : null;
            this.addDimMemberPair(dim, value);
        }
    }

    public QDRInterface getQDR() {
        QDR qdr = new QDR(this.m_dataLayer);
        int size = this.getColumns().size();
        for (int i = 0; i < size; ++i) {
            qdr.addDimMemberPair(this.getColumns().get(i), new QDRMember(0, this.getValues().get(i)));
        }
        return qdr;
    }

    public String getMeasureDim() {
        return this.m_dataLayer;
    }

    public List<String> getColumns() {
        if (this.m_columns == null) {
            this.m_columns = new ArrayList<String>(3);
        }
        return this.m_columns;
    }

    private List<Object> getValues() {
        if (this.m_values == null) {
            this.m_values = new ArrayList<Object>(3);
        }
        return this.m_values;
    }

    public Object clone() throws CloneNotSupportedException {
        QDRLite qdr = new QDRLite(this.getMeasureDim());
        if (this.m_columns != null) {
            qdr.m_columns = (List)((ArrayList)this.getColumns()).clone();
        }
        if (this.m_values != null) {
            qdr.m_values = (List)((ArrayList)this.getValues()).clone();
        }
        return qdr;
    }

    public void removeDimMemberPair(String column) {
        int loc = this.getColumns().indexOf(column);
        if (loc > -1) {
            this.getColumns().remove(loc);
            this.getValues().remove(loc);
        }
    }

    public void addDimMemberPair(String column, Object value) {
        int loc = this.getColumns().indexOf(column);
        if (loc > -1) {
            this.getColumns().set(loc, column);
            this.getValues().set(loc, value);
        } else {
            this.getColumns().add(column);
            this.getValues().add(value);
        }
    }

    public boolean isSubsetOf(QDRLite q2) {
        return QDRLite.contains(q2, this);
    }

    public boolean isSupersetOf(QDRLite q2) {
        return QDRLite.contains(this, q2);
    }

    public Object getDimMember(String column) {
        int loc = this.getColumns().indexOf(column);
        if (loc > -1) {
            return this.getValues().get(loc);
        }
        return null;
    }

    protected static boolean contains(QDRLite qdr1, QDRLite qdr2) {
        if (qdr1 == null || qdr2 == null) {
            return false;
        }
        List<String> qdr1Dims = qdr1.getColumns();
        int qdr1Size = qdr1Dims.size();
        Object member1 = null;
        Object member2 = null;
        List<Object> qdr1Members = qdr1.getValues();
        for (int i = 0; i < qdr1Size; ++i) {
            member1 = qdr1Members.get(i);
            if (Utility.compareObj(member1, member2 = qdr2.getDimMember(qdr1Dims.get(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        Object var2_2 = null;
        for (String string : this.getColumns()) {
            if (string == null) continue;
            hashCode += string.hashCode();
        }
        for (Object object : this.getValues()) {
            if (object == null) continue;
            hashCode += object.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof QDRLite) {
            return this.equals((QDRLite)obj);
        }
        if (obj != null && obj instanceof Map) {
            return this.equals((Map)obj);
        }
        return false;
    }

    public boolean equals(QDRLite q2) {
        if (q2 == null) {
            return false;
        }
        return QDRLite.contains(this, q2) && QDRLite.contains(q2, this);
    }

    public boolean equals(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        return QDR.contains(this, map) && QDR.contains(map, this);
    }

    @Override
    public int size() {
        return this.m_columns.size();
    }

    @Override
    public boolean isEmpty() {
        return this.getColumns().size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_columns != null && this.m_columns.indexOf(key) > -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_values != null && this.m_values.indexOf(value) > -1;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.getDimMember((String)key);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.remove(key);
        this.addDimMemberPair(key, value);
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = this.get(key);
        if (old != null && key instanceof String) {
            this.removeDimMemberPair((String)key);
        }
        return old;
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.m_columns.clear();
        this.m_values.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.m_columns);
    }

    @Override
    public Collection<Object> values() {
        if (this.m_values != null) {
            ArrayList<Object> objs = new ArrayList<Object>(3);
            Iterator<Object> memberEnum = this.m_values.iterator();
            Object obj = null;
            while (memberEnum.hasNext()) {
                obj = memberEnum.next();
                objs.add(obj);
            }
            return objs;
        }
        return null;
    }

    @Override
    public Set entrySet() {
        if (this.m_columns == null) {
            return null;
        }
        ArrayList<QDRLiteMapEntry> entryList = new ArrayList<QDRLiteMapEntry>();
        Iterator<String> dims = this.m_columns.iterator();
        String dim = null;
        while (dims.hasNext()) {
            dim = dims.next();
            entryList.add(new QDRLiteMapEntry(dim, this.get(dim)));
        }
        return new HashSet(entryList);
    }

    public class QDRLiteMapEntry
    implements Map.Entry {
        protected String m_key = null;
        protected Object m_value = null;

        public QDRLiteMapEntry(String key, Object value) {
            this.m_key = key;
            this.m_value = value;
        }

        public String getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object value) {
            Object old = this.m_value;
            this.m_value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            Map.Entry e2;
            Map.Entry entry = e2 = o instanceof Map.Entry ? (Map.Entry)o : null;
            return (this.getKey() == null ? e2.getKey() == null : this.getKey().equals(e2.getKey())) && this.getValue() == null ? e2.getValue() == null : this.getValue().equals(e2.getValue());
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

