/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Page {
    private List<String[]> m_pageVals = null;

    public Page() {
    }

    public Page(List<String[]> pageVals) {
        this.m_pageVals = this._allEmpty(pageVals) ? null : pageVals;
    }

    public void setPage(int edge, String[] pageVal) {
        int count;
        if (edge < 2) {
            return;
        }
        int pos = edge - 2;
        if (this.m_pageVals == null) {
            this.m_pageVals = new ArrayList<String[]>();
        }
        if (pos < (count = this.m_pageVals.size())) {
            this.m_pageVals.set(pos, pageVal);
        } else {
            for (int i = count; i < pos; ++i) {
                this.m_pageVals.add(null);
            }
            this.m_pageVals.add(pageVal);
        }
        if (this._allEmpty(this.m_pageVals)) {
            this.m_pageVals = null;
        }
    }

    public String[] getPage(int edge) {
        if (this.m_pageVals == null) {
            return null;
        }
        if (edge - 2 < this.m_pageVals.size()) {
            return this.m_pageVals.get(edge - 2);
        }
        return null;
    }

    public boolean isEmpty() {
        return this._allEmpty(this.m_pageVals);
    }

    private boolean _allEmpty(List<String[]> pageVals) {
        if (pageVals == null) {
            return true;
        }
        for (int i = 0; i < pageVals.size(); ++i) {
            String[] vals = pageVals.get(i);
            if (vals == null || vals.length <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Page) {
            Page newPage = (Page)obj;
            if (newPage.m_pageVals == null && this.m_pageVals == null) {
                return true;
            }
            if (this._allEmpty(this.m_pageVals) && this._allEmpty(newPage.m_pageVals)) {
                return true;
            }
            if (newPage.m_pageVals == null) {
                return false;
            }
            if (this.m_pageVals == null) {
                return false;
            }
            int size = this.m_pageVals.size();
            if (newPage.m_pageVals.size() != size) {
                return false;
            }
            Object[] arr1 = null;
            Object[] arr2 = null;
            for (int i = 0; i < size; ++i) {
                arr1 = this.m_pageVals.get(i);
                arr2 = newPage.m_pageVals.get(i);
                if (arr1 == null && arr2 != null && arr2.length == 0 || arr1 != null && arr1.length == 0 && arr2 == null || Arrays.equals(arr1, arr2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.m_pageVals != null) {
            for (Object[] objectArray : this.m_pageVals) {
                if (objectArray == null || objectArray.length <= 0) continue;
                hashCode += Arrays.hashCode(objectArray);
            }
        }
        return hashCode;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this.m_pageVals != null) {
            ArrayList<String[]> newPages = new ArrayList<String[]>();
            for (String[] val : this.m_pageVals) {
                if (val != null) {
                    newPages.add((String[])val.clone());
                    continue;
                }
                newPages.add(null);
            }
            return new Page(newPages);
        }
        return new Page(null);
    }
}

