/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.util.transform.BaseRowIterator;
import oracle.dss.util.transform.ColumnValue;
import oracle.dss.util.transform.ColumnValues;
import oracle.dss.util.transform.DataCell;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.DataColumnProjection;
import oracle.dss.util.transform.DataColumnRowIterator;
import oracle.dss.util.transform.ExtraColumnValue;
import oracle.dss.util.transform.Filter;
import oracle.dss.util.transform.GetMemberInterface;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberCell;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MixedFrequencyProjection;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.RowIterator;
import oracle.dss.util.transform.RowProjection;
import oracle.dss.util.transform.SimpleMemberInterfaceImpl;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.calcColumns.CalcColumnMetadata;
import oracle.dss.util.transform.calcColumns.CalcColumnValue;
import oracle.dss.util.transform.calcColumns.CalculatedColumnSpec;
import oracle.dss.util.transform.total.AggBuckets;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.AggSpec;
import oracle.dss.util.transform.total.TotalPlacement;

public class DataTable {
    protected static final int PROJECTION_STANDARD = 0;
    protected static final int PROJECTION_DATA_COLUMN = 1;
    protected static final int PROJECTION_MIXED_FREQUENCY = 2;
    protected RowProjection m_projection = null;
    protected int m_projectionType = 0;
    protected int m_memberCount = -1;
    protected int m_cellCount = -1;
    protected Hashtable m_memberLookupTable = new Hashtable();
    protected Hashtable m_cellLookupTable = new Hashtable();
    protected Hashtable m_backwardCellLookupTable = new Hashtable();
    protected String[] m_cellNames = null;
    protected List<Row> m_data = null;
    protected String[] m_memberLayers = null;
    protected AggBuckets[] m_aggBucket = null;
    protected AggSpec[][] m_aggs = null;
    protected BaseRowIterator m_iter = null;
    protected Filter[] m_filters = null;
    protected CalculatedColumnSpec[] m_colSpecs = null;
    protected Map<String, CalcColumnMetadata> m_specTable = new HashMap<String, CalcColumnMetadata>();

    protected DataTable() {
    }

    public DataTable(BaseRowIterator iter, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs) throws TransformException {
        this(null, iter, colSpecs, aggs, null, false);
    }

    public DataTable(RowProjection projection) throws TransformException {
        this(projection, null, null, false);
    }

    public DataTable(RowProjection projection, AggSpec[][] aggs) throws TransformException {
        this(projection, aggs, null, false);
    }

    public DataTable(RowProjection projection, AggSpec[][] aggs, boolean includeDataLayerinMembers) throws TransformException {
        this(projection, aggs, null, includeDataLayerinMembers);
    }

    public DataTable(RowProjection projection, AggSpec[][] aggs, Filter[] filters, boolean includeDataLayerinMembers) throws TransformException {
        this(projection, null, null, aggs, filters, includeDataLayerinMembers);
    }

    public DataTable(RowProjection projection, BaseRowIterator iter, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs, Filter[] filters, boolean includeDataLayerinMembers) throws TransformException {
        this.m_projection = projection;
        this.m_iter = iter;
        this.m_aggs = aggs;
        this.setUpCalculatedColumns(colSpecs);
        this.m_filters = filters;
        if (aggs != null) {
            this.m_aggBucket = new AggBuckets[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                if (aggs[i] == null) continue;
                this.m_aggBucket[i] = new AggBuckets(aggs[i], projection);
            }
        }
        if (projection instanceof DataColumnProjection || iter instanceof DataColumnRowIterator) {
            this.m_projectionType = 1;
            this.processDataColumnProjection();
        } else if (projection instanceof MixedFrequencyProjection) {
            this.m_projectionType = 2;
            this.processMixedFrequencyProjection();
        } else {
            this.m_projectionType = 0;
            this.processProjection(includeDataLayerinMembers);
        }
    }

    private void setUpCalculatedColumns(CalculatedColumnSpec[] colSpecs) {
        this.m_colSpecs = colSpecs;
        if (colSpecs != null) {
            for (int i = 0; i < colSpecs.length; ++i) {
                if (colSpecs[i] == null) continue;
                this.m_specTable.put(colSpecs[i].getColumn(), colSpecs[i].getCalcColumnMetadata());
            }
        }
    }

    public Filter[] getFilters() {
        return this.m_filters;
    }

    public AggSpec[][] getAggSpec() {
        return this.m_aggs;
    }

    public List<Row> getRows() {
        return this.m_data;
    }

    public String[] getColumns() {
        int i;
        int memberLayers = this.m_memberLayers != null ? this.m_memberLayers.length : 0;
        Enumeration dataEnum = this.m_cellLookupTable.keys();
        ArrayList dataArray = new ArrayList();
        while (dataEnum.hasMoreElements()) {
            dataArray.add(dataEnum.nextElement());
        }
        int dataSize = dataArray.size();
        String[] cols = new String[memberLayers + dataSize + this.m_specTable.size()];
        for (i = 0; i < memberLayers; ++i) {
            cols[i] = this.m_memberLayers[i];
        }
        for (i = memberLayers; i < memberLayers + dataSize; ++i) {
            cols[i] = (String)dataArray.get(i - memberLayers);
        }
        for (i = dataSize + memberLayers; i < cols.length; ++i) {
            cols[i] = this.m_colSpecs[i - (dataSize + memberLayers)].getColumn();
        }
        return cols;
    }

    public long getRowCount() {
        return this.m_data.size();
    }

    public int getMemberCount() {
        return this.m_memberCount;
    }

    public int getCellCount() {
        return this.m_cellCount;
    }

    public Row getRow(long row) {
        return this.m_data.get((int)row);
    }

    public MemberInterface getMember(long row, int member) {
        if (row < this.getRowCount() && row >= 0L && member < this.m_memberCount && member >= 0) {
            return this.getRow(row).getMember(member).getMemberInterface();
        }
        return null;
    }

    public DataCellInterface getCell(long row, int cell) {
        if (row < this.getRowCount() && row >= 0L && cell < this.m_cellCount && cell >= 0) {
            return this.getRow(row).getCell(cell).getDataCellInterface();
        }
        return null;
    }

    public MemberInterface getMember(long row, String colID) {
        return this.getMember(row, this.getMemberIndexFromID(colID));
    }

    public DataCellInterface getCell(long row, String colID) {
        return this.getCell(row, this.getCellIndexFromID(colID));
    }

    public void setMember(long row, int column, MemberCell newMember) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_memberCount && column >= 0) {
            this.getRow(row).setMember(column, newMember);
        }
    }

    public void setCell(long row, int column, DataCell newCell) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_cellCount && column >= 0) {
            this.getRow(row).setCell(column, newCell);
        }
    }

    public void setMember(long row, String colID, MemberCell newMember) {
        this.setMember(row, this.getMemberIndexFromID(colID), newMember);
    }

    public void setCell(long row, String colID, DataCell newCell) {
        this.setCell(row, this.getCellIndexFromID(colID), newCell);
    }

    protected int getMemberIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_memberLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    protected int getCellIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_cellLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    public void close() throws TransformException {
        if (this.m_iter != null) {
            this.m_iter.close();
        }
        if (this.m_memberLookupTable != null) {
            this.m_memberLookupTable.clear();
        }
        this.m_memberLookupTable = null;
        this.m_memberCount = -1;
        if (this.m_cellLookupTable != null) {
            this.m_cellLookupTable.clear();
        }
        this.m_cellLookupTable = null;
        if (this.m_backwardCellLookupTable != null) {
            this.m_backwardCellLookupTable.clear();
        }
        this.m_backwardCellLookupTable = null;
        this.m_cellNames = null;
        this.m_cellCount = -1;
        this.m_projection = null;
        if (this.m_data != null) {
            long count = this.getRowCount();
            Row r = null;
            for (long i = 0L; i < count; ++i) {
                r = this.getRow(i);
                if (r == null) continue;
                r.release();
            }
        }
        this.m_data = null;
        this.m_memberLayers = null;
        if (this.m_aggBucket != null) {
            for (int i = 0; i < this.m_aggBucket.length; ++i) {
                if (this.m_aggBucket[i] == null) continue;
                this.m_aggBucket[i].release();
            }
        }
        this.m_aggBucket = null;
    }

    protected void processMixedFrequencyProjection() throws TransformException {
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        this.m_data = new ArrayList<Row>();
        Hashtable indices = new Hashtable();
        BaseRowIterator baseRowIterator = this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        while (this.m_iter.nextRow()) {
            this.processMixedFrequencyCurrentRow(this.m_data, indices, this.m_iter);
        }
    }

    protected void processDataColumnProjection() throws TransformException {
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        ColumnValues extraMembers = null;
        Object calcColumns = null;
        Row row2 = null;
        long rowIndex = 0L;
        while (this.m_iter.nextRow()) {
            rowIndex = rowList.size();
            extraMembers = this._collectAggregatedMembers(this.m_iter, rowIndex, true);
            row2 = this.processDataColumnCurrentRow(rowList, this.m_iter, extraMembers, rowIndex);
            if (row2 == null) continue;
            rowList.add(row2);
        }
        if (this.m_specTable.size() > 0) {
            rowIndex = 0L;
            for (Row r : rowList) {
                r.setCalcColumns(this.getCalcColumns(r, rowIndex++));
            }
        }
        if (this.m_aggBucket != null && this.m_aggBucket.length > 0) {
            for (Row row2 : rowList) {
                if (this.m_aggBucket == null || this.m_aggBucket.length <= 0 || this.m_aggBucket[0] == null) continue;
                this.m_aggBucket[0].totalRow(row2);
            }
        }
        List<Row> data = this.integrateAggregations(rowList, this.m_aggBucket != null && this.m_aggBucket.length > 0 ? this.m_aggBucket[0] : null);
        if (this.m_aggBucket != null) {
            for (int i = 1; i < this.m_aggBucket.length; ++i) {
                rowList = new ArrayList();
                if (this.m_aggBucket[i] == null || data == null) continue;
                int count = data.size();
                Row currRow = null;
                for (int r = 0; r < count; ++r) {
                    currRow = data.get(r);
                    rowList.add(currRow);
                    this.m_aggBucket[i].totalRow(currRow);
                }
                data = this.integrateAggregations(rowList, this.m_aggBucket[i]);
            }
        }
        this.m_data = data;
    }

    private boolean _inLayout(String column) {
        String[][] layout;
        String[][] stringArray = layout = this.m_projection != null ? this.m_projection.getLayout() : (String[][])null;
        if (layout == null) {
            return false;
        }
        for (int e = 0; e < layout.length; ++e) {
            if (layout[e] == null) continue;
            for (int l = 0; l < layout[e].length; ++l) {
                if (!column.equals(layout[e][l])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _isDataItem(String col) throws TransformException {
        if (this.m_projection == null) {
            return false;
        }
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        for (int i = 0; i < dataItems.length; ++i) {
            if (dataItems[i] == null || !col.equals(dataItems[i].getValue())) continue;
            return true;
        }
        return false;
    }

    private ColumnValues _collectAggregatedMembers(BaseRowIterator iter, long index, boolean dataColProjection) throws TransformException {
        if (this.m_aggBucket != null) {
            ArrayList<ExtraColumnValue> memberVec = new ArrayList<ExtraColumnValue>();
            ArrayList<String> colList = new ArrayList<String>();
            for (int i = 0; i < this.m_aggBucket.length; ++i) {
                String[] cols;
                if (this.m_aggBucket[i] == null || (cols = this.m_aggBucket[i].getAggColumns()) == null) continue;
                for (int c = 0; c < cols.length; ++c) {
                    if (cols[c] == null || colList.indexOf(cols[c]) != -1 || this._inLayout(cols[c])) continue;
                    colList.add(cols[c]);
                    if (dataColProjection && this._isDataItem(cols[c])) {
                        if (cols[c].equals(iter.getValue(((DataColumnProjection)this.m_projection).getDataItemIDColumn()))) {
                            memberVec.add(new ExtraColumnValue(cols[c], iter.getValue(((DataColumnProjection)this.m_projection).getDataColumn()), index, this.isIgnoredColumn(cols[c])));
                            continue;
                        }
                        memberVec.add(new ExtraColumnValue(cols[c], null, index, this.isIgnoredColumn(cols[c])));
                        continue;
                    }
                    memberVec.add(new ExtraColumnValue(cols[c], iter.getValue(cols[c]), index, this.isIgnoredColumn(cols[c])));
                }
            }
            return new ColumnValues(memberVec.toArray(new ColumnValue[0]));
        }
        return new ColumnValues(new ColumnValue[0]);
    }

    private boolean isIgnoredColumn(String column) {
        String[] ignoredCols;
        String[] stringArray = ignoredCols = this.m_projection != null ? this.m_projection.getIgnoredColumns() : null;
        if (ignoredCols == null) {
            return false;
        }
        for (int i = 0; i < ignoredCols.length; ++i) {
            if (!column.equals(ignoredCols[i])) continue;
            return true;
        }
        return false;
    }

    public CalcColumnMetadata getCalcColumnMetadata(String column) {
        return this.m_specTable.get(column);
    }

    private ColumnValues getCalcColumns(Row row, long index) throws TransformException {
        ArrayList<CalcColumnValue> colVal = new ArrayList<CalcColumnValue>();
        Set<String> colSet = this.m_specTable.keySet();
        Iterator<String> iterSet = colSet.iterator();
        CalcColumnMetadata metadata = null;
        while (iterSet.hasNext()) {
            metadata = this.getCalcColumnMetadata(iterSet.next());
            colVal.add(metadata.getCalculatedColumnSpec().getCalcColumnValueObject(row, index));
        }
        return new ColumnValues(colVal.toArray(new ColumnValue[0]));
    }

    protected void processProjection(boolean includeDataLayerinMembers) throws TransformException {
        this.createMemberLookupTable(includeDataLayerinMembers);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        Row row = null;
        this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        ColumnValues extraMembers = null;
        long rowIndex = 0L;
        if (this.m_iter != null) {
            while (this.m_iter.nextRow()) {
                rowIndex = rowList.size();
                extraMembers = this._collectAggregatedMembers(this.m_iter, rowIndex, false);
                row = this.processCurrentRow(this.m_iter, extraMembers, rowIndex);
                if (row == null) continue;
                rowList.add(row);
                if (this.m_aggBucket == null || this.m_aggBucket.length <= 0 || this.m_aggBucket[0] == null) continue;
                this.m_aggBucket[0].totalRow(row);
            }
        }
        List<Row> data = this.integrateAggregations(rowList, this.m_aggBucket != null && this.m_aggBucket.length > 0 ? this.m_aggBucket[0] : null);
        if (this.m_aggBucket != null) {
            for (int i = 1; i < this.m_aggBucket.length; ++i) {
                rowList = new ArrayList();
                if (this.m_aggBucket[i] == null || data == null) continue;
                int count = data.size();
                Row currRow = null;
                for (int r = 0; r < count; ++r) {
                    currRow = data.get(r);
                    rowList.add(currRow);
                    this.m_aggBucket[i].totalRow(currRow);
                }
                data = this.integrateAggregations(rowList, this.m_aggBucket[i]);
            }
        }
        this.m_data = data;
    }

    private boolean checkFilters(BaseRowIterator rowIter) throws TransformException {
        Filter[] filters = this.getFilters();
        if (filters == null || !(rowIter instanceof GetMemberInterface)) {
            return true;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null || filters[i].filter((GetMemberInterface)((Object)rowIter), null, null)) continue;
            return false;
        }
        return true;
    }

    protected List<Row> integrateAggregations(List<Row> rowList, AggBuckets aggBucket) {
        TotalPlacement[] tp;
        if (aggBucket != null && (tp = aggBucket.getTotalPlacements()) != null) {
            int replacePlacement = this.getReplacementPlacement(tp);
            if (replacePlacement > -1) {
                return tp[replacePlacement].getTotalRows();
            }
            for (int placement = 0; placement < tp.length; ++placement) {
                if (tp[placement] == null) continue;
                rowList.addAll(tp[placement].getTotalRows());
            }
        }
        return rowList;
    }

    protected int getReplacementPlacement(TotalPlacement[] tp) {
        if (tp == null || tp.length > 1) {
            return -1;
        }
        for (int i = 0; i < tp.length; ++i) {
            if (tp[i] == null || tp[i].getAggLocation() != AggLocation.REPLACE) continue;
            return i;
        }
        return -1;
    }

    protected boolean isDataColumnProjection() {
        return this.m_projectionType == 1;
    }

    protected boolean isMixedFrequencyProjection() {
        return this.m_projectionType == 2;
    }

    protected void createMemberLookupTable(boolean includeDataLayerinMembers) throws TransformException {
        if (this.m_projection == null) {
            return;
        }
        String[][] layout = this.m_projection.getLayout();
        LayerInterface dataLayerInt = this.m_projection.getDataLayer();
        String dataLayer = dataLayerInt != null ? dataLayerInt.getValue() : null;
        MemberInterface[] dataItems = this.m_projection.getDataItems();
        ArrayList<String> vDataItems = new ArrayList<String>();
        if (dataItems != null) {
            for (int i = 0; i < dataItems.length; ++i) {
                vDataItems.add(dataItems[i].getValue());
            }
        }
        this.m_memberLookupTable.clear();
        ArrayList<String> memberLayers = new ArrayList<String>();
        int index = 0;
        if (layout != null) {
            for (int edge = 0; edge < layout.length; ++edge) {
                if (layout[edge] == null) continue;
                for (int layer = 0; layer < layout[edge].length; ++layer) {
                    if (!includeDataLayerinMembers && dataLayer.equals(layout[edge][layer])) continue;
                    this.m_memberLookupTable.put(layout[edge][layer], new Integer(index++));
                    memberLayers.add(layout[edge][layer]);
                }
            }
        }
        this.m_memberLayers = memberLayers.toArray(new String[index]);
        this.m_memberCount = index;
    }

    protected void createCellLookupTable() throws TransformException {
        block3: {
            block2: {
                MemberInterface[] dataItems;
                this.m_cellLookupTable.clear();
                this.m_backwardCellLookupTable.clear();
                MemberInterface[] memberInterfaceArray = dataItems = this.m_projection != null ? this.m_projection.getDataItems() : null;
                if (dataItems == null) break block2;
                this.m_cellCount = dataItems.length;
                for (int col = 0; col < this.m_cellCount; ++col) {
                    this.m_cellLookupTable.put(dataItems[col].getValue(), new Integer(col));
                }
                break block3;
            }
            if (this.m_iter == null) break block3;
            String[] cols = this.m_iter.getColumns();
            this.m_cellCount = cols.length;
            this.m_cellNames = new String[this.m_cellCount];
            for (int i = 0; i < cols.length; ++i) {
                this.m_cellLookupTable.put(cols[i], new Integer(i));
                this.m_cellNames[i] = cols[i];
            }
        }
    }

    protected int cellLookup(String dataItemID) {
        Object val = this.m_cellLookupTable.get(dataItemID);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return -1;
    }

    protected DataCellInterface getCell(BaseRowIterator iter, String col, int colCount) throws TransformException {
        if (iter instanceof RowIterator) {
            return ((RowIterator)iter).getCell(col);
        }
        return new DataCellImpl(iter.getValue(col));
    }

    protected MemberInterface getMember(BaseRowIterator iter, String col, int colCount) throws TransformException {
        if (iter instanceof GetMemberInterface) {
            return ((GetMemberInterface)((Object)iter)).getMember(col);
        }
        return new SimpleMemberInterfaceImpl(iter.getValue(col));
    }

    protected Row processCurrentRow(BaseRowIterator iter, ColumnValues extraMembers, long rowIndex) throws TransformException {
        if (!this.checkFilters(iter)) {
            return null;
        }
        MemberCell[] memberCells = null;
        DataCell[] cells = null;
        if (this.m_projection != null) {
            memberCells = new MemberCell[this.m_memberCount >= 0 ? this.m_memberCount : 0];
            for (int col = 0; col < this.m_memberCount; ++col) {
                memberCells[col] = new MemberCell(this.getMember(iter, this.m_memberLayers[col], col), this.m_memberLayers[col]);
            }
            MemberInterface[] dataItems = this.m_projection.getDataItems();
            if (dataItems != null) {
                cells = new DataCell[this.m_cellCount];
                String cellColumn = null;
                for (int col = 0; col < this.m_cellCount; ++col) {
                    cellColumn = dataItems[col].getValue();
                    cells[col] = new DataCell(this.getCell(iter, cellColumn, this.m_memberCount + col), cellColumn);
                }
            }
        } else {
            this.m_memberCount = 0;
            cells = new DataCell[this.m_cellCount];
            String cellColumn = null;
            for (int col = 0; col < this.m_cellCount; ++col) {
                cellColumn = this.m_cellNames[col];
                cells[col] = new DataCell(this.getCell(iter, cellColumn, this.m_memberCount + col), cellColumn);
            }
        }
        Row row = new Row(memberCells, cells, extraMembers, this);
        row.setCalcColumns(this.getCalcColumns(row, rowIndex));
        return row;
    }

    protected DataColumnProjection getDataColumnProjection() {
        if (this.isDataColumnProjection()) {
            return (DataColumnProjection)this.m_projection;
        }
        return null;
    }

    protected MixedFrequencyProjection getMixedFrequencyProjection() {
        if (this.isMixedFrequencyProjection()) {
            return (MixedFrequencyProjection)this.m_projection;
        }
        return null;
    }

    protected Row updateRow(Row row, ArrayList rowList, MemberInterface[] dataItems) throws TransformException {
        if (rowList == null) {
            return null;
        }
        Iterator iter = rowList.iterator();
        Row currRow = null;
        while (iter.hasNext()) {
            currRow = (Row)iter.next();
            if (!row.membersEqual(currRow, dataItems)) continue;
            if (currRow.insertData(row.getCells())) {
                return currRow;
            }
            return null;
        }
        return null;
    }

    protected Row processDataColumnCurrentRow(ArrayList rowList, BaseRowIterator iter, ColumnValues extraMembers, long rowIndex) throws TransformException {
        if (!this.checkFilters(iter)) {
            return null;
        }
        String dataID = null;
        String dataCol = null;
        MemberInterface mi = null;
        if (this.m_projection != null) {
            MemberCell[] members = new MemberCell[this.m_memberCount];
            for (int col = 0; col < this.m_memberCount; ++col) {
                mi = ((GetMemberInterface)((Object)iter)).getMember(this.m_memberLayers[col]);
                members[col] = new MemberCell(mi, this.m_memberLayers[col]);
            }
            DataColumnProjection proj = (DataColumnProjection)this.m_projection;
            dataID = proj.getDataItemIDColumn();
            dataCol = proj.getDataColumn();
            DataCell[] cells = new DataCell[this.m_cellCount];
            mi = ((GetMemberInterface)((Object)iter)).getMember(dataID);
            int cellPos = this.cellLookup(mi.getValue());
            if (cellPos >= 0 && cellPos < this.m_cellCount) {
                cells[cellPos] = iter instanceof RowIterator ? new DataCell(((RowIterator)iter).getCell(dataCol), mi.getValue()) : new DataCell(new DataCellImpl(iter.getValue(dataCol)), null);
                Row row = new Row(members, cells, extraMembers, this);
                row.setCalcColumns(this.getCalcColumns(row, rowIndex));
                Row updatedRow = this.updateRow(row, rowList, proj != null ? proj.getDataItems() : null);
                if (updatedRow != null) {
                    return null;
                }
                return row;
            }
        } else if (iter instanceof DataColumnRowIterator) {
            dataID = ((DataColumnRowIterator)iter).getDataItemIDColumn();
            dataCol = ((DataColumnRowIterator)iter).getDataColumn();
            ArrayList<DataCell> cells = new ArrayList<DataCell>();
            ArrayList<MemberCell> members = new ArrayList<MemberCell>();
            int numCells = 0;
            int memberCount = 0;
            for (int c = 0; c < this.m_cellCount; ++c) {
                if (this.m_cellNames[c].equals(dataID) || this.m_cellNames[c].equals(dataCol)) {
                    int cellPos;
                    Object obj = this.m_cellLookupTable.get(iter.getValue(dataID));
                    int n = cellPos = obj instanceof Integer ? (Integer)obj : -1;
                    if (cellPos == -1) {
                        if (this.m_backwardCellLookupTable.get(new Integer(numCells)) == null) {
                            this.m_cellLookupTable.put(iter.getValue(dataID), new Integer(numCells));
                            this.m_backwardCellLookupTable.put(new Integer(numCells), iter.getValue(dataID));
                            cellPos = numCells;
                        } else {
                            cellPos = -1;
                        }
                    }
                    if (cellPos >= 0 && cellPos < this.m_cellCount) {
                        if (numCells == cellPos) {
                            cells.add(new DataCell(new DataCellImpl(iter.getValue(dataCol)), (String)iter.getValue(dataID)));
                        } else {
                            cells.add(null);
                        }
                    }
                    ++numCells;
                    continue;
                }
                this.m_memberLookupTable.put(this.m_cellNames[c], new Integer(memberCount++));
                members.add(new MemberCell(new SimpleMemberInterfaceImpl(iter.getValue(this.m_cellNames[c])), this.m_cellNames[c]));
            }
            Row row = new Row(members.toArray(new MemberCell[0]), cells.toArray(new DataCell[0]), extraMembers, this);
            Row updatedRow = this.updateRow(row, rowList, null);
            if (updatedRow != null) {
                return null;
            }
            return row;
        }
        return null;
    }

    protected void processMixedFrequencyCurrentRow(List<Row> rowList, Hashtable indices, BaseRowIterator baseIter) throws TransformException {
        if (!(baseIter instanceof RowIterator)) {
            return;
        }
        RowIterator iter = (RowIterator)baseIter;
        MixedFrequencyProjection projection = this.getMixedFrequencyProjection();
        MemberCell[] members1 = new MemberCell[this.m_memberCount];
        MemberCell[] members2 = new MemberCell[this.m_memberCount];
        ArrayList<String> qdrMembers = new ArrayList<String>();
        int dynamicIndex = -1;
        for (int col = 0; col < this.m_memberCount; ++col) {
            if (!projection.getDynamicLayer().equals(this.m_memberLayers[col])) {
                members1[col] = new MemberCell(iter.getMember(this.m_memberLayers[col]), this.m_memberLayers[col]);
                members2[col] = new MemberCell(members1[col].getMemberInterface(), this.m_memberLayers[col]);
                qdrMembers.add(members1[col].getMemberInterface().getValue());
                continue;
            }
            dynamicIndex = col;
        }
        Integer value = (Integer)indices.get(qdrMembers);
        if (value == null) {
            value = new Integer(-1);
        }
        int index = value + 1;
        indices.put(qdrMembers, new Integer(index));
        members1[dynamicIndex] = new MemberCell(projection != null ? projection.getDynamicMember(index, 0) : null, Integer.toString(0));
        members2[dynamicIndex] = new MemberCell(projection != null ? projection.getDynamicMember(index, 1) : null, Integer.toString(1));
        DataCell[] cells1 = new DataCell[this.m_cellCount];
        DataCell[] cells2 = new DataCell[this.m_cellCount];
        MemberInterface[] dataItems = this.m_projection != null ? this.m_projection.getDataItems() : null;
        DataCellInterface frequency = iter.getCell(projection != null ? projection.getMixedFrequencyLayer() : null);
        if (dataItems != null) {
            for (int i = 0; i < dataItems.length; ++i) {
                cells1[i] = new DataCell(frequency, projection != null ? projection.getMixedFrequencyLayer() : null);
                cells2[i] = new DataCell(iter.getCell(dataItems[i].getValue()), dataItems[i].getValue());
            }
        }
        Row row1 = new Row(members1, cells1, null, this);
        Row row2 = new Row(members2, cells2, null, this);
        rowList.add(row1);
        rowList.add(row2);
    }

    protected class DataCellImpl
    implements DataCellInterface {
        protected Object m_value = null;

        public DataCellImpl(Object value) {
            this.m_value = value;
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }

        @Override
        public Object getData(String type) {
            return this.m_value;
        }
    }
}

