/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.util.VectorClone;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseNode
implements VectorClone,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String m_name = null;
    protected int m_index = -1;
    protected static final String XMLName = "Node";
    protected static final String STATE_NAME = "N";
    protected static final String DIMENSION_STATE = "D";
    protected static final String ASYMMETRIC_STATE = "A";

    public BaseNode() {
    }

    public BaseNode(String name) {
        this(name, -1);
    }

    public BaseNode(String name, int index) {
        this.setName(name);
        this.setIndex(index);
    }

    public void setNode(BaseNode newInfo) {
        this.setName(newInfo.getName());
        this.setIndex(newInfo.getIndex());
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public static String[] getStringList(BaseNode[] nodeList) {
        String[] newList = new String[nodeList.length];
        for (int i = 0; i < nodeList.length; ++i) {
            newList[i] = nodeList[i].getName();
        }
        return newList;
    }

    public static BaseNode[] getNodeList(String[] dimList, boolean[] asymmetric, List[] dependencyList) {
        if (dimList == null) {
            return null;
        }
        if (asymmetric == null) {
            asymmetric = new boolean[dimList.length];
        }
        if (dependencyList == null) {
            dependencyList = new List[dimList.length];
        }
        BaseNode[] nodeList = new BaseNode[dimList.length];
        for (int i = 0; i < dimList.length; ++i) {
            nodeList[i] = BaseNode.createNodeObject();
            nodeList[i].setName(dimList[i]);
        }
        return nodeList;
    }

    public static String[][] getStringArray(BaseNode[][] nodeArray) {
        String[][] strArray = new String[nodeArray.length][];
        for (int i = 0; i < nodeArray.length; ++i) {
            strArray[i] = BaseNode.getStringList(nodeArray[i]);
        }
        return strArray;
    }

    public static BaseNode[][] getNodeArray(String[][] stringArray, boolean[][] asymmetric, List[][] dependencyList) {
        if (asymmetric == null) {
            asymmetric = new boolean[stringArray.length][];
        }
        if (dependencyList == null) {
            dependencyList = new List[stringArray.length][];
        }
        BaseNode[][] nodeArray = new BaseNode[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            nodeArray[i] = BaseNode.getNodeList(stringArray[i], asymmetric[i], dependencyList[i]);
        }
        return nodeArray;
    }

    public static List getList(BaseNode[] dims) {
        ArrayList<BaseNode> newList = new ArrayList<BaseNode>();
        for (int i = 0; i < dims.length; ++i) {
            newList.add(dims[i]);
        }
        return newList;
    }

    public boolean equals(Object otherNode) {
        if (this == otherNode) {
            return true;
        }
        BaseNode temp = (BaseNode)otherNode;
        return this.getName().equals(temp.getName()) && this.getIndex() == temp.getIndex();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseNode node = BaseNode.createNodeObject();
        node.setName(this.getName());
        node.setIndex(this.getIndex());
        return node;
    }

    public void setXML(XMLContext context, Object node) {
        ContainerNode root = (ContainerNode)node;
        PropertyNode prop = root.getProperty("name");
        if (prop != null) {
            this.setName(prop.getValueAsString());
        }
    }

    protected static BaseNode createNodeObject() {
        return new BaseNode();
    }
}

