/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JViewport;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.CrosstabScrollPane;

public class ScrollPaneDropAdapter
implements DropTargetListener {
    private CrosstabScrollPane _scrollPane;
    private Crosstab _crosstab;
    private DropTarget _paneViewTarget;
    private DropTarget _paneViewportTarget;
    private DropTarget _columnViewTarget;
    private DropTarget _columnViewportTarget;
    private DropTarget _rowViewTarget;
    private DropTarget _rowViewportTarget;

    public ScrollPaneDropAdapter(CrosstabScrollPane scrollPane, Crosstab crosstab) {
        this._scrollPane = scrollPane;
        this._crosstab = crosstab;
        this._paneViewTarget = new DropTarget((Component)this._scrollPane, (DropTargetListener)this);
        JViewport viewPort = this._scrollPane.getViewport();
        this._paneViewportTarget = new DropTarget((Component)viewPort, (DropTargetListener)this);
        Component c = viewPort.getView();
        viewPort = this._scrollPane.getColumnHeader();
        if (viewPort != null) {
            this._columnViewportTarget = new DropTarget((Component)viewPort, (DropTargetListener)this);
            c = viewPort.getView();
            if (c != null) {
                this._columnViewTarget = new DropTarget(c, (DropTargetListener)this);
            }
        }
        if ((viewPort = this._scrollPane.getRowHeader()) != null) {
            this._rowViewportTarget = new DropTarget((Component)viewPort, (DropTargetListener)this);
            c = viewPort.getView();
            if (c != null) {
                this._rowViewTarget = new DropTarget(c, (DropTargetListener)this);
            }
        }
    }

    public void cleanup() {
        if (this._paneViewTarget != null) {
            this._paneViewTarget.setActive(false);
            this._paneViewTarget.setComponent(null);
        }
        if (this._paneViewportTarget != null) {
            this._paneViewportTarget.setActive(false);
            this._paneViewportTarget.setComponent(null);
        }
        if (this._columnViewTarget != null) {
            this._columnViewTarget.setActive(false);
            this._columnViewTarget.setComponent(null);
        }
        if (this._columnViewportTarget != null) {
            this._columnViewportTarget.setActive(false);
            this._columnViewportTarget.setComponent(null);
        }
        if (this._rowViewTarget != null) {
            this._rowViewTarget.setActive(false);
            this._rowViewTarget.setComponent(null);
        }
        if (this._rowViewportTarget != null) {
            this._rowViewportTarget.setActive(false);
            this._rowViewportTarget.setComponent(null);
        }
        this._paneViewTarget = null;
        this._paneViewportTarget = null;
        this._columnViewTarget = null;
        this._columnViewportTarget = null;
        this._rowViewTarget = null;
        this._rowViewportTarget = null;
        this._scrollPane = null;
        this._crosstab = null;
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        if (!this._acceptDrag(e)) {
            e.rejectDrag();
            return;
        }
        this._setDropLocation(0);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        this._setDropLocation(-1);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        this._setDropLocation(-1);
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ufe) {
            data = null;
        }
        catch (IOException ioe) {
            data = null;
        }
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer layoutTransfer = (PivotTransfer)data;
            Object source = layoutTransfer.getSource();
            int sourceIndex = layoutTransfer.getIndex();
            Component destination = this._scrollPane.getViewport().getView();
            int destinationIndex = 0;
            this._crosstab.firePivotEvent(source, sourceIndex, destination, destinationIndex);
        }
        e.dropComplete(data != null);
    }

    private void _setDropLocation(int index) {
        this._scrollPane.setDropLocation(index);
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }
}

