/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.BIException;
import oracle.dss.util.gui.BIExceptionPanel;
import oracle.dss.util.help.HelpContext;

public class BIExceptionDialog
extends JEWTDialog
implements HelpContext {
    private static final long serialVersionUID = 1L;
    private Throwable m_exception;
    private String m_errMsg;
    private ResourceBundle m_bundle;
    private String m_strHelpContextID;
    private HelpProvider m_helpProvider;
    private boolean m_bHelpEnabled;

    public BIExceptionDialog(Frame frame, Throwable excep, String title, String errMsg, Locale locale) {
        super(frame);
        this.m_exception = excep;
        this.init(locale, title, errMsg);
    }

    public BIExceptionDialog(Dialog dialog, Throwable excep, String title, String errMsg, Locale locale) {
        super(dialog);
        this.m_exception = excep;
        this.init(locale, title, errMsg);
    }

    private void init(Locale locale, String title, String errMsg) {
        if (locale != null) {
            this.loadResources(locale);
        } else {
            this.loadResources(Locale.getDefault());
        }
        if (title != null) {
            this.setTitle(title);
        } else {
            this.setTitle(this.m_bundle.getString("BIException Dialog"));
        }
        this.m_errMsg = errMsg != null ? errMsg : this.m_bundle.getString("An application error has occured");
        this.setButtonMask(1 | 4);
        String _saveStr = this.m_bundle.getString("Save");
        JButton save = new JButton(StringUtils.stripMnemonic((String)_saveStr));
        save.setMnemonic(StringUtils.getMnemonicKeyCode((String)_saveStr));
        this.addCustomButton(save);
        String _okStr = this.m_bundle.getString("OK");
        this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)_okStr));
        this.setDefaultButton(1);
        this.setContent(new BIExceptionPanel((JDialog)((Object)this), this.m_exception, this.m_errMsg, this.m_bundle));
        this.setResizable(true);
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BIExceptionDialog.this.saveStackTrace();
            }
        });
    }

    private void saveStackTrace() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            try {
                FileWriter writer = new FileWriter(file);
                StringWriter _strWrt = new StringWriter();
                PrintWriter _prtWrt = new PrintWriter(_strWrt);
                if (this.m_exception instanceof BIException) {
                    int size = ((BIException)((Object)this.m_exception)).size();
                    for (int i = 0; i < size; ++i) {
                        ((BIException)((Object)this.m_exception)).elementAt(i).printStackTrace(_prtWrt);
                    }
                } else {
                    this.m_exception.printStackTrace(_prtWrt);
                }
                String _str = _strWrt.toString();
                writer.write(_str, 0, _str.length());
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void loadResources(Locale locale) {
        try {
            this.m_bundle = ResourceBundle.getBundle("oracle.dss.util.gui.resource.UtilGUIBundle", locale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void display() {
        this.runDialog();
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)this.m_helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            // empty catch block
        }
        String strMsg = "To add items to the query of your Presentation, select the items from the Available list and move them to the Selected list.";
        BIExceptionDialog h = new BIExceptionDialog(new Frame(), (Throwable)new Exception("Not good."), null, strMsg, null);
        h.display();
        System.exit(0);
    }
}

