/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.dimensionList;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import oracle.dss.util.dimensionList.DefaultListDataModel;
import oracle.dss.util.dimensionList.DimComboCellRenderer;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionComboEvent;
import oracle.dss.util.dimensionList.DimensionComboListener;

public class DimensionCombo
extends JComboBox
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int BELOW_PARENT = 0;
    public static final int ABOVE_PARENT = 1;
    private DefDimComboCellRenderer m_cellRenderer = null;
    private DefaultListDataModel m_dataModel = null;
    private transient boolean m_added = false;
    private transient Vector m_listeners = null;
    protected int m_debugLevel = 0;

    public DimensionCombo() {
        this.init();
    }

    public synchronized void addDimensionComboListener(DimensionComboListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.addElement(l);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.m_added = true;
        this.init();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
    }

    public int getCount() {
        DimListDataModel dm = (DimListDataModel)this.getModel();
        if (dm != null) {
            return dm.size();
        }
        return 0;
    }

    public synchronized void removeDimensionComboListener(DimensionComboListener l) {
        if (this.m_listeners != null && !this.m_listeners.contains(l)) {
            this.m_listeners.removeElement(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
    }

    public synchronized void setModel(DimListDataModel model) {
        super.setModel(model);
        if (model == null) {
            this.init();
        } else if (model.getSize() > 0) {
            super.setSelectedIndex(0);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        int old = super.getSelectedIndex();
        if (old != index) {
            DimensionComboEvent e = new DimensionComboEvent(this, 9, index);
            this.notifyDimensionComboListener(e);
            if (!e.isConsumed()) {
                super.setSelectedIndex(index);
                e = new DimensionComboEvent(this, 10, index);
                this.notifyDimensionComboListener(e);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.init();
        if (this.m_cellRenderer != null) {
            this.m_cellRenderer.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        System.out.println("DimensionCombo: valueChanged: " + e);
        if (!e.getValueIsAdjusting()) {
            this.notifyDimensionComboListener(new DimensionComboEvent(this, 10, e.getFirstIndex()));
        } else {
            this.notifyDimensionComboListener(new DimensionComboEvent(this, 9, e.getLastIndex()));
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        boolean wasPopupVisible = this.isPopupVisible();
        super.processKeyEvent(e);
        if ((e.getKeyCode() == 10 || e.getKeyCode() == 32) && e.getID() == 402) {
            boolean isPopupVisible = this.isPopupVisible();
            if (wasPopupVisible && isPopupVisible) {
                this.setPopupVisible(false);
            }
            if (!wasPopupVisible && !isPopupVisible) {
                this.setPopupVisible(true);
            }
        }
        if (!this.isPopupVisible() && e.getID() == 402 && e.getKeyCode() == 40) {
            this.setPopupVisible(true);
        }
    }

    protected void init() {
        if (this.m_cellRenderer == null) {
            this.m_cellRenderer = new DefDimComboCellRenderer();
        }
        this.setRenderer(this.m_cellRenderer);
        this.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDimensionComboListener(DimensionComboEvent e) {
        if (this.m_listeners != null && this.m_listeners.size() > 0) {
            Vector v;
            DimensionCombo dimensionCombo = this;
            synchronized (dimensionCombo) {
                v = (Vector)this.m_listeners.clone();
            }
            int count = v.size();
            DimListDataModel dm = (DimListDataModel)this.getModel();
            if (e.getDataModel() == null) {
                e.setDataModel(dm);
            }
            switch (e.getID()) {
                case 0: {
                    for (int i = 0; i < count && !e.isConsumed(); ++i) {
                        DimensionComboListener client = (DimensionComboListener)v.elementAt(i);
                        client.dimensionChanged(e);
                    }
                    break;
                }
                case 9: {
                    for (int i = 0; i < count && !e.isConsumed(); ++i) {
                        DimensionComboListener client = (DimensionComboListener)v.elementAt(i);
                        client.dimensionSelecting(e);
                    }
                    break;
                }
                case 10: {
                    for (int i = 0; i < count && !e.isConsumed(); ++i) {
                        DimensionComboListener client = (DimensionComboListener)v.elementAt(i);
                        client.dimensionSelected(e);
                    }
                    break;
                }
            }
        }
    }

    class DefDimComboCellRenderer
    extends JLabel
    implements DimComboCellRenderer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient int m_index = 0;
        private transient int m_level = -1;
        private transient int m_state = 0;
        private transient String m_meta = "";
        private transient boolean m_selected = false;
        private transient Color m_forenorm = Color.black;
        private transient Color m_backnorm = Color.white;
        private transient Color m_foresel = Color.white;
        private transient Color m_backsel = Color.blue;
        private transient Color m_lineColor = Color.lightGray;
        private int m_ascent = 0;
        private int m_indentUnit = 12;
        private transient Color m_listforenorm = Color.black;
        private transient Color m_listbacknorm = Color.white;
        private transient Color m_listforesel = Color.white;
        private transient Color m_listbacksel = new Color(0, 0, 128);

        public DefDimComboCellRenderer() {
            this.init();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.init();
        }

        @Override
        public void setIndentUnit(int value) {
            if (value > -1) {
                this.m_indentUnit = value;
                this.repaint();
            }
        }

        @Override
        public int getIndentUnit() {
            return this.m_indentUnit;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int level = -1;
            int state = 0;
            String src = "";
            String meta = "";
            if (value instanceof String) {
                src = (String)value;
                level = -1;
                state = 0;
            } else {
                DimListDataItem dsItem = (DimListDataItem)value;
                if (dsItem != null) {
                    src = dsItem.getText();
                    level = dsItem.getLevel();
                    state = dsItem.getDrillState();
                    meta = dsItem.getMetaInfo();
                }
            }
            this.setText(src);
            this.m_level = level;
            this.m_state = state;
            this.m_index = index;
            this.m_meta = meta;
            if (index > -1) {
                this.setBackground(isSelected || cellHasFocus ? this.m_backsel : this.m_listbacknorm);
                this.setForeground(isSelected || cellHasFocus ? this.m_listforesel : this.m_listforenorm);
            } else {
                this.setBackground(isSelected || cellHasFocus ? this.m_backsel : this.m_backnorm);
                this.setForeground(isSelected || cellHasFocus ? this.m_foresel : this.m_forenorm);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Dimension size = this.getSize();
            this.clear(g, size.width, size.height);
            if (this.m_index > -1) {
                this.paintTreeLines(g);
            } else {
                this.drawText(g, this.getText(), 0, size.width, size.height, this.m_ascent);
            }
        }

        private void init() {
            FontMetrics _fm;
            Font _font = this.getFont();
            if (_font != null && (_fm = this.getFontMetrics(_font)) != null) {
                this.setIndentUnit(_fm.stringWidth("W"));
                this.m_ascent = _fm.getAscent();
            }
            this.m_forenorm = UIManager.getColor("ComboBox.foreground");
            this.m_backnorm = UIManager.getColor("ComboBox.background");
            this.m_foresel = UIManager.getColor("ComboBox.selectionForeground");
            this.m_backsel = UIManager.getColor("ComboBox.selectionBackground");
            this.m_listforenorm = UIManager.getColor("ComboBox.listForeground");
            this.m_listbacknorm = UIManager.getColor("ComboBox.listBackground");
            this.m_listforesel = UIManager.getColor("List.selectionForeground");
            this.m_listbacksel = UIManager.getColor("List.selectionBackground");
            this.m_lineColor = Color.lightGray;
        }

        private void clear(Graphics g, int cx, int cy) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, cx, cy);
        }

        private void paintTreeLines(Graphics g) {
            int xoffset = 2;
            int iconWidth = 0;
            int colWidth = this.m_indentUnit;
            int cx = this.m_meta.length();
            Dimension size = this.getSize();
            if (cx > 0) {
                int cyHalf = size.height / 2;
                int col = xoffset + cx * colWidth - colWidth / 2;
                g.setColor(this.m_lineColor);
                for (int i = 0; i < cx; ++i) {
                    char ch = this.m_meta.charAt(i);
                    if (i == 0) {
                        if (ch == '0') {
                            g.drawLine(col, 0, col, size.height);
                            g.drawLine(col, cyHalf, col + colWidth / 2, cyHalf);
                        } else {
                            g.drawLine(col, 0, col, cyHalf);
                            g.drawLine(col, cyHalf, col + colWidth / 2, cyHalf);
                        }
                    } else if (ch == '0') {
                        g.drawLine(col, 0, col, size.height);
                    }
                    col -= colWidth;
                }
            }
            this.drawText(g, this.getText(), xoffset + this.m_level * colWidth + iconWidth, size.width, size.height, this.m_ascent);
        }

        private void drawText(Graphics g, String s, int x, int cx, int cy, int ascent) {
            g.setColor(this.getForeground());
            g.drawString(s, x, ascent);
        }
    }
}

