/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import oracle.dss.util.converter.ResourceBundleToXMLFile;
import oracle.dss.util.converter.ResourceBundleToXMLInfo;
import oracle.dss.util.converter.ResourceBundleToXMLProductCodeInfo;

public class ResourceBundleToXMLUtil {
    public String BASEDIR;
    public static final String ERRORTAG_ERROR = "@Error";
    public static final String ERRORTAG_CAUSE = "@Cause";
    public static final String ERRORTAG_ACTION = "@Action";
    public static final String ERRORTAG_STATUS = "@Status";
    public static final String ERRORTAG_SEVERITY_CODE = "@SeverityCode";
    public static final int ERRORCODE_ERROR = 0;
    public static final int ERRORCODE_CAUSE = 1;
    public static final int ERRORCODE_ACTION = 2;
    public static final int ERRORCODE_STATUS = 3;
    public static final int ERRORCODE_UNKNOWN = 4;
    public static final int ERRORCODE_SEVERITY_CODE = 5;
    public static final String STATUSTYPE_STATUSNEW = "new";
    public static final String STATUSTYPE_STATUSDOCUMENTED = "documented";
    public static final String STATUSTYPE_STATUSREVIEWED = "reviewed";
    public static final String STATUSTYPE_STATUSNEEDSCHANGE = "needschange";
    public static final String STATUSTYPE_INVALID = "invalid";
    protected static final String INPUTERRFILEEXT = "txt";
    public static final String CMD_PARAM_LOG_FILE = "-logFile";
    public static final String CMD_PARAM_INPUT_RESOURCE_FILES_LIST = "@";
    public static final String CMD_PARAM_OUTPUT_FILE = "-htmlFile";
    public static final String CMD_PARAM_COMMON_DELIMITER = ";";
    public static final String CMD_PARAM_PRODUCT_CODES = "-productCodes";
    public static final String ERROR_COMM_FILE_PARENT_FOLDER_PATTERN = "resource";
    public static final String ERROR_COMM_FILE_BUNDLE_PATTERN = "Bundle";
    public static final String DEFAULT_ERROR_MSG_UTILITY_LOG = "defaultRB2XML.log";
    public static final String INDENT = "\t";
    protected Vector m_vInputFilesList;
    protected String m_strOutputFile;
    protected HashMap m_hCompNames = new HashMap();
    protected String m_compName;
    protected String m_compCode;
    protected boolean m_bInferProdCodesFromErrorComments = false;
    protected String m_strLogFilePath;
    protected PrintWriter m_logFile = null;

    public static Vector _arrayToVector(String[] args) {
        Vector<String> vArgs = new Vector<String>();
        for (int nIndex = 0; nIndex < args.length; ++nIndex) {
            vArgs.addElement(args[nIndex]);
        }
        return vArgs;
    }

    public static void main(String[] arRealArgs) {
        Vector vRealArgs = ResourceBundleToXMLUtil._arrayToVector(arRealArgs);
        ResourceBundleToXMLUtil _rb2xml = new ResourceBundleToXMLUtil();
        _rb2xml.processConversion(vRealArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processConversion(Vector vArgs) {
        try {
            boolean bRetVal = this.processArgs(vArgs);
            if (!bRetVal) {
                boolean flag;
                boolean bl = flag = bRetVal;
                return bl;
            }
            bRetVal = this.processResourceBundleFiles(this.m_vInputFilesList);
            if (!bRetVal) {
                boolean flag1;
                boolean bl = flag1 = bRetVal;
                return bl;
            }
            bRetVal = this._createOutput();
            if (!bRetVal) {
                boolean flag2;
                boolean bl = flag2 = bRetVal;
                return bl;
            }
        }
        finally {
            try {
                if (this.m_logFile != null) {
                    this.m_logFile.close();
                }
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    protected boolean processArgs(Vector vArgs) {
        if (vArgs == null || 0 == vArgs.size()) {
            return false;
        }
        this.BASEDIR = this.getBaseDirectoryFromArgs(vArgs);
        if (this.BASEDIR == null || this.BASEDIR.length() == 0) {
            return false;
        }
        if (!this._processLogFileArgs(vArgs)) {
            return false;
        }
        if (!this._processInputFilesArgs(vArgs)) {
            return false;
        }
        if (!this._processOutputArgs(vArgs)) {
            return false;
        }
        if (!this._processProductCodeArgs(vArgs)) {
            return false;
        }
        this.logMessage("BEGIN logging processed arguments.");
        this.logMessage("Log File = " + this.m_strLogFilePath + ".");
        this.logMessage("Begin Input File List.");
        if (this.m_vInputFilesList == null || this.m_vInputFilesList.size() == 0) {
            this.logMessage("Input File List is empty or could not be built.");
            this.logMessage("End Input File List.");
            return false;
        }
        for (int i = 0; i < this.m_vInputFilesList.size(); ++i) {
            this.logMessage(" Input File " + i + " = " + this.m_vInputFilesList.elementAt(i) + ".");
        }
        this.logMessage("End Input File List.");
        this.logMessage("Output File = " + this.m_strOutputFile + ".");
        this.logMessage("Begin Product Code List.");
        for (String curProdCode : this.m_hCompNames.keySet()) {
            ResourceBundleToXMLProductCodeInfo rbpci = (ResourceBundleToXMLProductCodeInfo)this.m_hCompNames.get(curProdCode);
            this.logMessage(" Product Code = " + curProdCode + ", Message Id Lower Bound = " + rbpci.lowerBoundAsString() + ", Message Id Upper Bound = " + rbpci.upperBoundAsString() + ".");
        }
        this.logMessage("END Product Code List.");
        this.logMessage("END logging processed arguments.");
        return true;
    }

    private String getBaseDirectoryFromArgs(Vector vArgs) {
        String strRetVal = null;
        int nLogFileArgIndex = vArgs.indexOf("-baseDir");
        if (nLogFileArgIndex != -1) {
            strRetVal = (String)vArgs.elementAt(nLogFileArgIndex + 1);
        }
        if (!this.isValidDirectory(strRetVal)) {
            this.logMessage("Error. The value of baseDir argument is an invalid directory.Verify the value of the -baseDir program argument.");
        } else {
            int i = strRetVal.lastIndexOf("\\");
            if (i == strRetVal.length() - 1) {
                strRetVal = strRetVal.substring(0, strRetVal.length() - 1);
            }
            this.logMessage("ResourceBundleToXMLUtil Log. BASEDIR = " + strRetVal);
        }
        return strRetVal;
    }

    private boolean _processLogFileArgs(Vector vArgs) {
        String strLogFilePath = null;
        int nLogFileArgIndex = vArgs.indexOf(CMD_PARAM_LOG_FILE);
        if (nLogFileArgIndex != -1) {
            strLogFilePath = (String)vArgs.elementAt(nLogFileArgIndex + 1);
        }
        if (null == strLogFilePath || 0 == strLogFilePath.length()) {
            strLogFilePath = DEFAULT_ERROR_MSG_UTILITY_LOG;
        }
        try {
            if (!this._canWriteToFile(strLogFilePath)) {
                this.logMessage("Error. Unable to write to the specified log file. Verify the value of the -logFile program argument. Sending output to System.out.");
            } else {
                this.m_logFile = this.initFile(strLogFilePath);
            }
            this.logMessage("ResourceBundleToXMLUtil Log. Run Date = " + new Date().toString());
        }
        catch (Throwable t) {
            this.m_logFile = null;
            this.logMessage("Error initializing the log file. " + t.getMessage());
            boolean flag = false;
            return flag;
        }
        this.m_strLogFilePath = strLogFilePath;
        return true;
    }

    private boolean _processInputFilesArgs(Vector vArgs) {
        return !this._buildInputFilesList(vArgs) ? true : true;
    }

    public void logMessage(String strMessage) {
        if (null == strMessage || 0 == strMessage.length()) {
            System.out.println("");
            return;
        }
        if (this.m_logFile != null) {
            this.m_logFile.println(strMessage);
        }
    }

    public HashMap getComponentNames() {
        return this.m_hCompNames;
    }

    public boolean getOutputMode() {
        return this.getOutputFile() != null;
    }

    public String getOutputFile() {
        return this.m_strOutputFile;
    }

    public boolean shouldInferProdCodesFromErrorComments() {
        return this.m_bInferProdCodesFromErrorComments;
    }

    public static boolean isValidStatusType(String strArg, boolean bStrict) {
        boolean bRetVal = false;
        if (STATUSTYPE_STATUSNEW.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSDOCUMENTED.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSREVIEWED.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (STATUSTYPE_STATUSNEEDSCHANGE.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        if (!bStrict && STATUSTYPE_INVALID.equalsIgnoreCase(strArg)) {
            bRetVal = true;
            return bRetVal;
        }
        bRetVal = false;
        return bRetVal;
    }

    protected boolean isValidDirectory(String strDirPath) {
        if (null == strDirPath || 0 == strDirPath.length()) {
            return false;
        }
        File dir = null;
        try {
            dir = new File(strDirPath);
            if (dir.exists() && dir.isDirectory()) {
                boolean flag = true;
                return flag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dir = null;
        return false;
    }

    protected boolean isValidFile(String strFilePath, String strExt) {
        if (null == strFilePath || 0 == strFilePath.length()) {
            return false;
        }
        if (strExt != null && strFilePath.endsWith(strExt)) {
            return false;
        }
        File file = null;
        try {
            file = new File(strFilePath);
            if (file.exists() && file.isFile()) {
                boolean flag = true;
                return flag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        file = null;
        return false;
    }

    private boolean _canWriteToFile(String strFilePath) {
        PrintWriter pw = this.initFile(strFilePath);
        if (null == pw) {
            return false;
        }
        try {
            pw.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    protected boolean processResourceBundleFiles(Vector m_vInputFilesList) {
        try {
            for (int i = 0; i < m_vInputFilesList.size(); ++i) {
                String strCurInputFile = (String)m_vInputFilesList.elementAt(i);
                ResourceBundleToXMLFile edf = new ResourceBundleToXMLFile(strCurInputFile, this);
                edf.processErrorFile();
            }
        }
        catch (Throwable t) {
            this.logMessage("Error processing file. " + t.toString());
            boolean flag = false;
            return flag;
        }
        return true;
    }

    private boolean _createOutput() {
        return !this.getOutputMode() || this.getOutputFile() == null || this.getOutputFile().length() <= 0 || this._createXMLOutput(this.getOutputFile());
    }

    protected PrintWriter initFile(String strFile) {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(strFile));
            return printwriter;
        }
        catch (Throwable t) {
            this.logMessage("Error initing file for write operation." + t);
            return null;
        }
    }

    private String _swapExpression(String strText, String strSrchExpr, String strSwapExpr) {
        int nLenSrchExpr = -1;
        int nPos = -1;
        String strNewText = null;
        nLenSrchExpr = strSrchExpr.length();
        nPos = strText.indexOf(strSrchExpr);
        strNewText = new String();
        if (nPos == -1) {
            return strText;
        }
        while (true) {
            if (nPos < 0) break;
            strNewText = strNewText.concat(strText.substring(0, nPos));
            strNewText = strNewText + strSwapExpr;
            strText = strText.substring(nPos + nLenSrchExpr, strText.length());
            nPos = strText.indexOf(strSrchExpr);
        }
        strNewText = strNewText.concat(strText);
        return strNewText;
    }

    private boolean _createXMLOutputForProductCode(PrintWriter xmlFile, String strCurProdCode) {
        ResourceBundleToXMLProductCodeInfo edpci = (ResourceBundleToXMLProductCodeInfo)this.m_hCompNames.get(strCurProdCode);
        Vector vValidErrorComments = edpci.getValidErrorCommentsSortedByErrorNumber();
        for (int i = 0; i < vValidErrorComments.size(); ++i) {
            ResourceBundleToXMLInfo curEdi = (ResourceBundleToXMLInfo)vValidErrorComments.elementAt(i);
            xmlFile.println("\t\t<message>");
            xmlFile.println("\t\t\t<prefix>" + curEdi.m_strProdCode + "</prefix>");
            xmlFile.println("\t\t\t<number>" + curEdi.m_strErrNum + "</number>");
            xmlFile.println("\t\t\t<text>" + curEdi.m_strErrorText + "</text>");
            xmlFile.println("\t\t\t<category>" + (curEdi.m_strErrorCategory == null ? "Programmatic" : curEdi.m_strErrorCategory) + "</category>");
            xmlFile.println("\t\t\t<type>" + curEdi.m_strErrorType + "</type>");
            xmlFile.println("\t\t\t<level>" + curEdi.m_strErrorLevel + "</level>");
            xmlFile.println("\t\t\t<name>" + curEdi.m_strErrorKey + "</name>");
            if (curEdi.m_oStatusInfo.m_strValue != null) {
                xmlFile.println("\t\t\t<documented>" + (curEdi.m_oStatusInfo.m_strValue.equalsIgnoreCase("DOCUMENTED") ? "Yes" : "No") + "</documented>");
            } else {
                xmlFile.println("\t\t\t<documented>No</documented>");
            }
            xmlFile.println("\t\t\t<causes>");
            String _cause = this._swapExpression(curEdi.m_strCause, "<>", " ");
            xmlFile.println("\t\t\t\t<cause>" + this._escapeExpression(_cause) + "</cause>");
            String _action = this._swapExpression(curEdi.m_strAction, "<>", " ");
            xmlFile.println("\t\t\t\t<action>" + this._escapeExpression(_action) + "</action>");
            xmlFile.println("\t\t\t</causes>");
            xmlFile.println("\t\t\t</message>");
        }
        return true;
    }

    private String _escapeExpression(String expression) {
        String _strRetVal = null;
        if (expression != null && expression.length() > 0 && expression.indexOf("<") > 0) {
            StringBuffer _sb = new StringBuffer(expression);
            for (int i = 0; i < _sb.length(); ++i) {
                if (_sb.charAt(i) == '<') {
                    _sb = _sb.replace(i, i + 1, "&lt;");
                    continue;
                }
                if (_sb.charAt(i) != '>') continue;
                _sb = _sb.replace(i, i + 1, "&gt;");
            }
            _strRetVal = _sb.toString();
        } else {
            _strRetVal = expression;
        }
        return _strRetVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _createXMLOutput(String strOutputFile) {
        block17: {
            xmlFile = null;
            try {
                xmlFile = this.initFile(strOutputFile);
                xmlFile.println("<messages>");
                xmlFile.println("\t<component number = '" + this.m_compCode + "'>");
                vProdCodes = new Vector<K>(this.m_hCompNames.keySet());
                Collections.sort(vProdCodes, new SortByProductCodeComparator());
                i = 0;
lbl9:
                // 2 sources

                while (i < vProdCodes.size()) {
                    strCurProdCode = vProdCodes.elementAt(i).toString();
                    if (null == strCurProdCode) {
                        this.logMessage("Error generating XML output. \"Null\" product code encountered.");
                        var7_11 = flag1 = false;
                        break block17;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl44
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                    this.logMessage("Error generating xml file.");
                    var5_8 = flag = false;
                    return var5_8;
                }
                catch (Throwable var9_13) {
                    throw var9_13;
                }
                finally {
                    try {
                        if (xmlFile != null) {
                            xmlFile.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            if (xmlFile == null) return var7_11;
            xmlFile.close();
            return var7_11;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return var7_11;
lbl-1000:
        // 1 sources

        {
            this._createXMLOutputForProductCode(xmlFile, strCurProdCode);
            ++i;
            ** GOTO lbl9
lbl44:
            // 1 sources

            xmlFile.println("\t</component>");
            xmlFile.println("</messages>");
        }
        try {
            if (xmlFile == null) return true;
            xmlFile.close();
            return true;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    private boolean _processProductCodeArgs(Vector vArgs) {
        String strComponentName = null;
        int nCompNamesArgIndex = vArgs.indexOf("-component");
        strComponentName = nCompNamesArgIndex != -1 ? (String)vArgs.elementAt(nCompNamesArgIndex + 1) : "DVT";
        this.m_compName = strComponentName;
        String strCompCode = null;
        int nCompCodeArgIndex = vArgs.indexOf("-compCode");
        strCompCode = nCompCodeArgIndex != -1 ? (String)vArgs.elementAt(nCompCodeArgIndex + 1) : "12330";
        this.m_compCode = strCompCode;
        this.m_hCompNames = new HashMap();
        this.m_bInferProdCodesFromErrorComments = true;
        return true;
    }

    private boolean _canHaveErrorComments(File targetFile, File parentDir) {
        String strFileAbsPath = targetFile.getAbsolutePath();
        if (strFileAbsPath != null && strFileAbsPath.endsWith(".rts")) {
            return true;
        }
        String strFileName = targetFile.getName();
        int nExtIndex = strFileName.lastIndexOf(".");
        if (nExtIndex > 0 && strFileName.substring(nExtIndex + 1).equalsIgnoreCase("JAVA")) {
            strFileName = strFileName.substring(0, nExtIndex);
        }
        return strFileName != null && strFileName.endsWith(ERROR_COMM_FILE_BUNDLE_PATTERN);
    }

    private void _reallyBuildInputFilesForSingleInputDir(HashMap hInputFiles, File parentDir) {
        File[] arChildren = parentDir.listFiles();
        if (null == arChildren) {
            return;
        }
        for (int i = 0; i < arChildren.length; ++i) {
            File curFile = arChildren[i];
            if (curFile.isDirectory() && !curFile.getAbsolutePath().endsWith(".ade_path")) {
                this._reallyBuildInputFilesForSingleInputDir(hInputFiles, curFile);
                continue;
            }
            if (!curFile.isFile() || !this._canHaveErrorComments(curFile, parentDir)) continue;
            String strFilePath = curFile.getAbsolutePath();
            hInputFiles.put(strFilePath, strFilePath);
        }
    }

    private HashMap _buildInputFilesForSingleInputDir(String strInputDir) {
        HashMap hInputFiles = new HashMap();
        try {
            File dir = new File(strInputDir);
            this._reallyBuildInputFilesForSingleInputDir(hInputFiles, dir);
        }
        catch (Throwable t) {
            this.logMessage("Error. Error building list of input files for " + strInputDir + "directory.");
            hInputFiles.clear();
        }
        return hInputFiles;
    }

    private Vector _buildInputFilesListFromInputDirs(Vector vValidDirs) {
        HashMap hInputFiles = new HashMap();
        for (int i = 0; i < vValidDirs.size(); ++i) {
            HashMap hInputFilesForSingleDir = this._buildInputFilesForSingleInputDir((String)vValidDirs.elementAt(i));
            hInputFiles.putAll(hInputFilesForSingleDir);
        }
        return new Vector(hInputFiles.keySet());
    }

    private boolean _buildInputFilesList(Vector vArgs) {
        String strInputParamFile = null;
        int nInputDirsArgIndex = vArgs.indexOf("-inputParamFile");
        if (nInputDirsArgIndex == -1) {
            return false;
        }
        strInputParamFile = (String)vArgs.elementAt(nInputDirsArgIndex + 1);
        BufferedReader inReader = null;
        try {
            inReader = new BufferedReader(new FileReader(strInputParamFile));
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found" + strInputParamFile);
            return false;
        }
        Vector<String> vValidInputDirs = new Vector<String>();
        String thisLine = null;
        try {
            thisLine = inReader.readLine();
            while (thisLine != null) {
                String strCurDirPath = thisLine;
                if (strCurDirPath.startsWith("#")) {
                    thisLine = inReader.readLine();
                    continue;
                }
                strCurDirPath = this.BASEDIR + strCurDirPath;
                vValidInputDirs.add(strCurDirPath);
                if (!this.isValidDirectory(strCurDirPath)) {
                    this.logMessage("Error. Cannot resolve path to input directory. Check the " + strCurDirPath + " path of the " + "-inputDirs" + " program argument.");
                    return false;
                }
                thisLine = inReader.readLine();
            }
        }
        catch (IOException e) {
            System.out.println("Error reading from bundle!");
            System.exit(0);
        }
        if (0 == vValidInputDirs.size()) {
            this.logMessage("Error. No valid input directories specified. Check the -inputParamFile program argument.");
            return false;
        }
        Vector vInputFilesList = this._buildInputFilesListFromInputDirs(vValidInputDirs);
        if (vInputFilesList.size() > 0) {
            this.m_vInputFilesList = vInputFilesList;
        }
        return true;
    }

    private boolean _processOutputArgs(Vector vArgs) {
        String strOutputFilePath = null;
        int nOutputFileArgIndex = vArgs.indexOf("-xmlFile");
        if (nOutputFileArgIndex != -1) {
            strOutputFilePath = (String)vArgs.elementAt(nOutputFileArgIndex + 1);
        }
        if (!this._canWriteToFile(strOutputFilePath)) {
            this.logMessage("Error. Unable to write to the specified output file. Verify the value of the -xmlFile program argument.");
            return false;
        }
        this.m_strOutputFile = strOutputFilePath;
        return true;
    }

    private class SortByProductCodeComparator
    implements Comparator {
        public int compare(Object first, Object second) {
            String strFirstProdCode = first.toString();
            String strSecondProdCode = second.toString();
            if (null == strFirstProdCode || null == strSecondProdCode) {
                return 0;
            }
            return strFirstProdCode.compareTo(strSecondProdCode);
        }

        SortByProductCodeComparator() {
        }
    }
}

