/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.dss.util.Parameter;

public class Operation
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name = null;
    protected Parameter[] parameters;
    protected boolean m_generatesCursor = false;

    public Operation(String n, Parameter[] p, boolean gc) {
        this.name = n;
        this.parameters = p;
        this.m_generatesCursor = gc;
    }

    public Object execute(Object executionTarget) throws InvocationTargetException {
        Method method;
        int paramCount = this.parameters == null ? 0 : this.parameters.length;
        Class[] types = new Class[paramCount];
        Object[] args = new Object[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            types[i] = this.parameters[i].getType() == Integer.class ? Integer.TYPE : (this.parameters[i].getType() == Boolean.class ? Boolean.TYPE : (this.parameters[i].getType() == Long.class ? Long.TYPE : this.parameters[i].getType()));
            args[i] = this.parameters[i].getValue();
        }
        try {
            method = executionTarget.getClass().getMethod(this.name, types);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, this.name);
        }
        Object retVal = null;
        try {
            retVal = method.invoke(executionTarget, args);
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return retVal;
    }

    public void setParameters(Parameter[] p) {
        this.parameters = p;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setGeneratesCursor(boolean generatesCursor) {
        this.m_generatesCursor = generatesCursor;
    }

    public boolean generatesCursor() {
        return this.m_generatesCursor;
    }

    public String toString() {
        String cmd = this.name + "(";
        for (int param = 0; param < this.parameters.length - 1; ++param) {
            cmd = cmd + (this.parameters[param] == null ? "null" : this.parameters[param].toString()) + ",";
        }
        if (this.parameters.length > 0) {
            cmd = cmd + (this.parameters[this.parameters.length - 1] == null ? "null" : this.parameters[this.parameters.length - 1].toString()) + ")";
        }
        return cmd;
    }
}

