/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.CompoundCondition;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SimpleCondition;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public class ConditionDiscriminator
implements DiscriminatorXML {
    private static final long serialVersionUID = 1L;
    protected Object m_dataCondition = null;
    protected String m_dataMap = null;
    public static final String NAME_DC_DISC = "ConditionDisc";

    public ConditionDiscriminator() {
    }

    public ConditionDiscriminator(Object dc, String dataMap) {
        this.m_dataCondition = dc;
        this.m_dataMap = dataMap;
    }

    public void setDataCondition(Object dc, String dataMap) {
        this.m_dataCondition = dc;
        this.m_dataMap = dataMap;
    }

    public Object getDataCondition() {
        return this.m_dataCondition;
    }

    @Override
    public boolean applies(RuleContext context) {
        if (this.getDataCondition() == null || this.m_dataMap == null) {
            return false;
        }
        DataAccess dataAccess = (DataAccess)context.get("DATA_ACCESS");
        ComponentInfo ci = (ComponentInfo)context.get("POSITION");
        if (!(ci instanceof DataComponentInfo)) {
            return false;
        }
        DataComponentInfo dinfo = (DataComponentInfo)ci;
        try {
            Object o = dataAccess.getValue(dinfo.getRow(), dinfo.getColumn(), this.m_dataMap);
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                return b;
            }
        }
        catch (RowOutOfRangeException re) {
        }
        catch (ColumnOutOfRangeException ce) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Object clone() {
        return new ConditionDiscriminator(this.m_dataCondition, this.m_dataMap);
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter converter, boolean emptyElement) {
        ObjectNode node = new ObjectNode(NAME_DC_DISC);
        if (this.m_dataCondition != null) {
            ObjectNode dcxml;
            if (this.m_dataCondition instanceof CompoundCondition) {
                ContainerNode dcxml2 = ((CompoundCondition)this.m_dataCondition).getXML();
                if (dcxml2 != null) {
                    node.addContainer(dcxml2);
                }
            } else if (this.m_dataCondition instanceof SimpleCondition && (dcxml = ((SimpleCondition)this.m_dataCondition).getXML()) != null) {
                node.addProperty(dcxml);
            }
        }
        return node;
    }

    @Override
    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        ContainerNode cNode = node.getContainer("CompoundCondition");
        if (cNode != null) {
            if (this.m_dataCondition == null) {
                this.m_dataCondition = new CompoundCondition();
            }
            return ((CompoundCondition)this.m_dataCondition).setXML(cNode);
        }
        ObjectNode sNode = node.getPropertyValueAsObjectNode("SimpleCondition");
        if (sNode != null) {
            if (this.m_dataCondition == null) {
                this.m_dataCondition = new SimpleCondition();
            }
            ((SimpleCondition)this.m_dataCondition).setXML(sNode);
            return true;
        }
        return false;
    }
}

