/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;

public class OracleLiteConnectionCreator
extends OracleConnectionCreator {
    public static final String OLITE_DRIVER_CLASS = "oracle.lite.poljdbc.POLJDBCDriver";
    public static final String SUBTYPE_OLITE = "oraLite";

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String dsn = props.getProperty("dataSourceName");
        if (dsn != null && dsn.length() > 0) {
            return "jdbc:polite:" + dsn;
        }
        String hostname = this.getPropertyOrThrow(props, "hostname");
        String port = this.getPropertyOrThrow(props, "port");
        String sid = this.getPropertyOrThrow(props, "sid");
        return "jdbc:polite4@" + hostname + ":" + port + ":" + sid;
    }

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return OLITE_DRIVER_CLASS;
    }
}

