/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.sql.DataSource;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DB2ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdeveloper.db.adapter.DatabaseProviderFactory;
import oracle.jdeveloper.db.adapter.MySQLConnectionCreator;
import oracle.jdeveloper.db.adapter.ODBCConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleLiteConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLServerConnectionCreator;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class DatabaseProvider
implements Referenceable,
DataSource {
    private static Map<String, ConnectionCreator> s_creators = new HashMap<String, ConnectionCreator>();
    static final Class PROVIDER_CLASS = DatabaseProvider.class;
    static final String PROVIDER_CLASSNAME = PROVIDER_CLASS.getName();
    public static final String SUBTYPE_CLASS_REFTYPE = "subtype";
    public static final String CUSTOM_URL_CLASS_REFTYPE = "customUrl";
    public static final String DRIVER_CLASS_REFTYPE = "driver";
    public static final String USERNAME_CLASS_REFTYPE = "user";
    public static final String PASSWORD_CLASS_REFTYPE = "password";
    public static final String ROLE_CLASS_REFTYPE = "role";
    public static final String HOSTNAME_CLASS_REFTYPE = "hostname";
    public static final String PORT_CLASS_REFTYPE = "port";
    public static final String SID_CLASS_REFTYPE = "sid";
    public static final String DSN_CLASS_REFTYPE = "dataSourceName";
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";
    public static final String PARAMETERS_CLASS_REFTYPE = "parameters";
    public static final String SERVICENAME_CLASS_REFTYPE = "serviceName";
    public static final String SAVE_PASSWORD_CLASS_REFTYPE = "SavePassword";
    public static final String DEPLOY_PASSWORD_CLASS_REFTYPE = "DeployPassword";
    @Deprecated
    public static final String ALL_SCHEMAS_REFTYPE = "allSchemas";
    private static DatabaseProviderClassLoaderFactory s_clFactory;
    private Properties m_properties;
    private String m_name;
    private transient PrintWriter m_pw;
    private transient int m_timeout;
    private boolean m_skipCredStore;

    public DatabaseProvider() {
        this(null, null);
    }

    public DatabaseProvider(Properties props) {
        this(null, props);
    }

    public DatabaseProvider(String name, Properties props) {
        this.m_name = name;
        Properties properties = this.m_properties = props == null ? new Properties() : props;
        if (this.m_properties.containsKey("INTERNAL_STRINGS_TO_FILE")) {
            this.m_properties.remove("INTERNAL_STRINGS_TO_FILE");
            this.m_skipCredStore = true;
        }
    }

    @Override
    public Reference getReference() {
        ConnectionCreator cc = null;
        try {
            cc = DatabaseProvider.getCreator(this);
        }
        catch (SQLException sqe) {
            cc = new OracleConnectionCreator();
        }
        Reference ref = new Reference(PROVIDER_CLASSNAME, DatabaseProviderFactory.PROVIDER_FACTORY_CLASS, null);
        Enumeration<Object> keys = this.m_properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = this.getProperty(name);
            if (value == null) {
                Object actual = this.m_properties.get(name);
                if (actual == null) continue;
                DatabaseProvider.getLogger().log(Level.WARNING, "Invalid property in connection for key: " + name);
                continue;
            }
            if (cc.shouldEncrypt(name)) {
                PasswordPrompter pp;
                String savePass = this.getProperty(SAVE_PASSWORD_CLASS_REFTYPE);
                if (savePass == null || Boolean.valueOf(savePass).booleanValue()) {
                    if (this.m_skipCredStore || DatabaseProviderHelper.useMe()) {
                        ref.add(new StringRefAddr(name, DatabaseProviderHelper.goingOut(value)));
                        continue;
                    }
                    ref.add((RefAddr)new SecureRefAddr(name, value));
                    continue;
                }
                if (value == null || (pp = DatabaseProviderHelper.getPasswordPrompter()) == null) continue;
                pp.cache(this.m_properties);
                continue;
            }
            if (name.equals("INTERNAL_STRINGS_TO_FILE")) continue;
            ref.add(new StringRefAddr(name, value));
        }
        return ref;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.m_properties);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = (Properties)this.m_properties.clone();
        props.setProperty(USERNAME_CLASS_REFTYPE, username);
        props.setProperty(PASSWORD_CLASS_REFTYPE, password);
        return this.getConnection(props);
    }

    private Connection getConnection(Properties props) throws SQLException {
        PasswordPrompter pp;
        ConnectionCreator creator;
        if (this.m_name != null && this.m_name.length() > 0) {
            Object obj = null;
            try {
                InitialContext ic = new InitialContext();
                try {
                    obj = ic.lookup("jdbc/" + this.m_name + "DS");
                }
                catch (NameNotFoundException nnfe) {
                    // empty catch block
                }
                if (obj == null) {
                    try {
                        obj = ic.lookup("java:comp/env/jdbc/" + this.m_name + "DS");
                    }
                    catch (NameNotFoundException nnfe) {}
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (obj instanceof DataSource) {
                return ((DataSource)obj).getConnection();
            }
        }
        if ((creator = DatabaseProvider.getCreator(this)).shouldPromptForPassword(props) && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            return pp.promptForPassword(props, creator);
        }
        return creator.getConnection(props);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pw;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pw = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    public String getProperty(String name) {
        return this.m_properties.getProperty(name);
    }

    public Properties getProperties() {
        return (Properties)this.m_properties.clone();
    }

    public void setProperty(String name, String value) {
        if ("INTERNAL_STRINGS_TO_FILE".equals(name)) {
            this.m_skipCredStore = value != null;
        } else if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.setProperty(name, value);
        }
    }

    public void disconnect() {
        PasswordPrompter pp = DatabaseProviderHelper.getPasswordPrompter();
        if (pp != null) {
            pp.disconnect(this.m_properties);
        }
    }

    public int hashCode() {
        return this.m_properties.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseProvider && this.equalsImpl((DatabaseProvider)obj);
    }

    private boolean equalsImpl(DatabaseProvider prov) {
        return DatabaseProvider.areEqual(this.m_properties, prov.m_properties);
    }

    public String getConnectionURL() throws SQLException {
        return DatabaseProvider.getCreator(this).getConnectionURL(this.m_properties);
    }

    public String getDriverClassName() throws SQLException {
        return DatabaseProvider.getCreator(this).getDriverClassName(this.m_properties);
    }

    public Attributes getAttributes() {
        BasicAttributes attrs = new BasicAttributes();
        Enumeration<Object> keys = this.m_properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = this.getProperty(name);
            if (value == null) continue;
            attrs.put(new BasicAttribute(name, value));
        }
        return attrs;
    }

    static ClassLoader getClassLoader(String driverClass) {
        ClassLoader cl = null;
        if (s_clFactory != null) {
            cl = s_clFactory.getClassLoader(driverClass);
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = PROVIDER_CLASS.getClassLoader();
        }
        return cl;
    }

    public static void setClassLoaderFactory(DatabaseProviderClassLoaderFactory factory) {
        s_clFactory = factory;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    static ConnectionCreator getCreator(DatabaseProvider dp) throws SQLException {
        String subtype = dp.getProperty(SUBTYPE_CLASS_REFTYPE);
        ConnectionCreator creator = s_creators.get(subtype);
        if (creator != null) {
            return creator;
        }
        throw new SQLException("Unrecognized JDBC URL subtype: " + subtype);
    }

    public static synchronized void registerConnectionCreator(String subtype, ConnectionCreator creator) {
        if (s_creators.containsKey(subtype)) {
            DatabaseProvider.getLogger().log(Level.FINE, "DB Adapter warning: Replacing connection creator " + s_creators.remove(subtype).getClass().getName() + " for subtype " + subtype + " with " + (creator == null ? "null" : creator.getClass().getName()));
        }
        s_creators.put(subtype, creator);
    }

    private static Logger getLogger() {
        return Logger.getLogger("oracle.jdeveloper.db.adapter");
    }

    static {
        s_creators.put("oraJDBC", new OracleConnectionCreator());
        s_creators.put("oraLite", new OracleLiteConnectionCreator());
        s_creators.put("thirdParty", new CustomConnectionCreator());
        s_creators.put("ODBCBridge", new ODBCConnectionCreator());
        s_creators.put("MYSQL", new MySQLConnectionCreator());
        s_creators.put("DB2", new DB2ConnectionCreator());
        s_creators.put("SQLServer", new SQLServerConnectionCreator());
    }
}

