/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.sql.SQLException;
import java.util.Properties;
import oracle.jdeveloper.db.adapter.AbstractConnectionCreator;

public class DB2ConnectionCreator
extends AbstractConnectionCreator {
    public static final String DB2_DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    public static final String SUBTYPE_DB2 = "DB2";

    @Override
    public String getDriverClassName(Properties props) throws SQLException {
        String driverClassName = super.getDriverClassName(props);
        if (this.hasLength(driverClassName)) {
            return driverClassName;
        }
        return DB2_DRIVER_CLASS;
    }

    @Override
    public String getConnectionURL(Properties props) throws SQLException {
        String customURL = super.getConnectionURL(props);
        if (this.hasLength(customURL)) {
            return customURL;
        }
        String server = this.getPropertyOrThrow(props, "hostname");
        String port = props.getProperty("port");
        String dbase = props.getProperty("dataSourceName");
        if (port != null) {
            return "jdbc:db2://" + server + ":" + port + "/" + dbase;
        }
        if (server != null) {
            return "jdbc:db2://" + server + "/" + dbase;
        }
        if (!this.hasLength(customURL) && !this.hasLength(server)) {
            throw new SQLException("No URL specified for DB2 JDBC driver");
        }
        return customURL;
    }
}

