/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.parser.helper.TranslationHelper;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Cursor;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.components.Var;
import oracle.dbtools.migration.translation.util.ASTUtil;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class TemplateManager {
    private StringTemplateGroup m_templateGroup;
    private String m_templateGroupName = null;
    private ExtStringTemplate m_outputTemplate;
    private TranslationHelper m_helper;

    public TemplateManager(TranslationHelper translationHelper) {
        this.m_helper = translationHelper;
    }

    public TranslationHelper getHelper() {
        return this.m_helper;
    }

    public void setHelper(TranslationHelper translationHelper) {
        this.m_helper = translationHelper;
    }

    public ExtStringTemplate getExtTemplate(String string) {
        return new ExtStringTemplate(this.m_templateGroup.getInstanceOf(string));
    }

    public ExtStringTemplate getOutputTemplate() {
        return this.m_outputTemplate;
    }

    public void setOutputTemplate(ExtStringTemplate extStringTemplate) {
        this.m_outputTemplate = extStringTemplate;
    }

    public StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    public void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    public ExtStringTemplate initOutputTemplate() {
        this.m_outputTemplate = this.getExtTemplate("start");
        if (this.getHelper().getTargetDBObjectReference() != null && this.getHelper().getTargetDBObjectReference().getObjName() != null) {
            this.m_outputTemplate.setValue(4, this.getHelper().getTargetDBObjectReference().getObjName());
        }
        return this.m_outputTemplate;
    }

    public StringTemplate getOutputStringTemplate() {
        return this.m_outputTemplate.getStringTemplate();
    }

    public String getTemplateGroupName() {
        return this.m_templateGroupName;
    }

    public void setTemplateGroupName(String string) {
        this.m_templateGroupName = string;
    }

    public void packTemplate(ExtStringTemplate extStringTemplate, Object[] objectArray) {
        if (extStringTemplate.getName().equals("TSQL_executeProcedure")) {
            this.pack_TSQL_executeProcedure(extStringTemplate, objectArray);
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                extStringTemplate.setValue(i, objectArray[i]);
            }
        }
    }

    private void pack_TSQL_executeProcedure(ExtStringTemplate extStringTemplate, Object[] objectArray) {
    }

    public ExtStringTemplate createTranslationLimitationTemplate(AST aST, TranslationLimitation translationLimitation, TranslationHelper translationHelper, String string) {
        return this.createTranslationLimitationTemplate(aST, translationLimitation, translationHelper, string, null);
    }

    public ExtStringTemplate createTranslationLimitationTemplate(AST aST, TranslationLimitation translationLimitation, TranslationHelper translationHelper, String string, String string2) {
        ExtStringTemplate extStringTemplate = null;
        extStringTemplate = translationHelper.getTemplateManager().getExtTemplate("translationLimitation");
        if (translationLimitation == null) {
            translationLimitation = translationHelper.getTranslationMetaData().getTranslationLimitation(aST.getSourceStartLine(), aST.getSourceStartCol());
        }
        if (translationLimitation == null) {
            Block block = translationHelper.getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
            if (block != null && block.getAST() != null) {
                translationLimitation = translationHelper.getTranslationMetaData().getTranslationLimitation(block.getAST().getSourceStartLine(), block.getAST().getSourceStartCol());
            }
            if (translationLimitation == null) {
                return extStringTemplate;
            }
        }
        extStringTemplate.setValue(1, translationLimitation.getLabel());
        extStringTemplate.setValue(2, translationLimitation);
        extStringTemplate.setValue(3, translationHelper.getSourceTextAtPosition(translationLimitation.getStartLine(), translationLimitation.getStartColumn(), translationLimitation.getEndLine(), translationLimitation.getEndColumn(), string2 != null ? string2 : null));
        extStringTemplate.setValue(4, ASTUtil.cloneExtAST(aST, string));
        return extStringTemplate;
    }

    public void fillTemplateWithParameterVars(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, int n) {
        ArrayList<TranslationParameter> arrayList = translationHelper.getDeclareVars();
        for (TranslationParameter translationParameter : arrayList) {
            ExtAST extAST = new ExtAST();
            extAST.initialize(translationParameter.getTreePosition());
            extAST.setText(translationParameter.getName().substring(1));
            ExtStringTemplate extStringTemplate2 = this.getHelper().getTemplateManager().getExtTemplate("variableDeclaration");
            extStringTemplate2.setValue(1, translationParameter.getTreePosition() != null ? extAST : translationParameter.getName());
            extStringTemplate2.setValue(2, translationParameter.getDataType());
            extStringTemplate2.setValue(3, translationParameter.getName());
            extStringTemplate.setValue(n, (Object)extStringTemplate2);
        }
    }

    public void fillTemplateDeclarations(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, Block block, int n) {
        this.fillTemplateWithCursorDeclarations(extStringTemplate, translationHelper, block, n);
        this.fillTemplateWithVarDeclarations(extStringTemplate, translationHelper, block, n);
        this.fillTemplateWithSysErrorVar(extStringTemplate, translationHelper, block, n);
    }

    public void fillTemplateWithPragmas(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, Block block, int n) {
        List<TranslationMetaData.Pragma> list;
        if (block != null && (list = translationHelper.getTranslationMetaData().getPragmas(block)) != null) {
            for (TranslationMetaData.Pragma pragma : list) {
                extStringTemplate.setValue(n, pragma.toString());
            }
        }
    }

    public void fillTemplateWithCursorDeclarations(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, Block block, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Cursor cursor : translationHelper.getCursorHelper().getCursors()) {
            Object object;
            ExtStringTemplate extStringTemplate2;
            if (cursor.getBlock() != block) continue;
            if (cursor.hasMultipleDeclarations()) {
                if (arrayList.contains(cursor.getTargetName())) continue;
                extStringTemplate2 = this.getHelper().getTemplateManager().getExtTemplate("variableDeclaration");
                extStringTemplate2.setValue(1, cursor.getName());
                object = new TranslationDataType("SYS_REFCURSOR");
                extStringTemplate2.setValue(2, object);
                arrayList.add(cursor.getTargetName());
            } else {
                Block block2;
                object = new ExtAST();
                object.initialize(cursor.getTree());
                object.setText(cursor.getName());
                extStringTemplate2 = this.getHelper().getTemplateManager().getExtTemplate("cursorDeclaration");
                extStringTemplate2.setValue(1, object);
                extStringTemplate2.setValue(2, cursor);
                if (cursor.hasMultipleDeclarations()) {
                    extStringTemplate2.setValue(3, true);
                }
                if ((block2 = translationHelper.getCodeBlockManager().findEnclosingBlock(cursor.getTree(), "STMTBLOCK")) != null && block2.getAST() != null) {
                    block2.getAST().setSt(extStringTemplate2.getStringTemplate());
                }
            }
            extStringTemplate.setValue(n, (Object)extStringTemplate2);
        }
    }

    public void fillTemplateWithVarDeclarations(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, Block block, int n) {
        for (Var var : translationHelper.getTranslationMetaData().getVariables(block)) {
            ExtAST extAST = new ExtAST();
            if (!var.isGenerated()) {
                extAST.initialize(var.getTreePosition());
                extAST.setText(var.getName());
            }
            ExtStringTemplate extStringTemplate2 = this.getHelper().getTemplateManager().getExtTemplate("variableDeclaration");
            extStringTemplate2.setValue(1, !var.isGenerated() ? extAST : var.getName());
            if (var.getDataType() != null) {
                extStringTemplate2.setValue(2, var.getDataType());
            }
            if (var.getDefaultValue() != null) {
                extStringTemplate2.setValue(3, var.getDefaultValue());
            }
            Block block2 = translationHelper.getCodeBlockManager().findEnclosingBlock(var.getTreePosition(), "STMTBLOCK");
            if (!var.isGenerated() && block2 != null && block2.getAST() != null) {
                block2.getAST().setSt(extStringTemplate2.getStringTemplate());
            }
            extStringTemplate.setValue(n, (Object)extStringTemplate2);
        }
    }

    public void fillTemplateWithSysErrorVar(ExtStringTemplate extStringTemplate, TranslationHelper translationHelper, Block block, int n) {
        Var var = this.getHelper().getTranslationMetaData().getSystemErrorVariable();
        if (var != null) {
            ExtStringTemplate extStringTemplate2 = this.getHelper().getTemplateManager().getExtTemplate("variableDeclaration");
            extStringTemplate2.setValue(1, var.getName());
            extStringTemplate2.setValue(2, var.getDataType());
            extStringTemplate2.setValue(3, var.getDefaultValue());
            extStringTemplate.setValue(n, (Object)extStringTemplate2);
        }
    }

    public ExtStringTemplate getCursorAssignmentTemplate(Object object, Object object2) {
        ExtStringTemplate extStringTemplate = this.getExtTemplate("varAssignmentList");
        if (object instanceof StringTemplate.STAttributeList && object2 instanceof StringTemplate.STAttributeList) {
            StringTemplate.STAttributeList sTAttributeList = (StringTemplate.STAttributeList)object;
            StringTemplate.STAttributeList sTAttributeList2 = (StringTemplate.STAttributeList)object2;
            StringTemplate.STAttributeList sTAttributeList3 = this.getAliasList(sTAttributeList2);
            for (int i = 0; i <= sTAttributeList.size() - 1; ++i) {
                ExtStringTemplate extStringTemplate2 = this.getExtTemplate("varAssignment");
                extStringTemplate2.setValue(1, sTAttributeList.get(i));
                extStringTemplate2.setValue(2, "rec." + sTAttributeList3.get(i));
                extStringTemplate.setValue(1, (Object)extStringTemplate2);
            }
        } else {
            String string = this.getAlias((StringTemplate)object2);
            ExtStringTemplate extStringTemplate3 = this.getExtTemplate("varAssignment");
            extStringTemplate3.setValue(1, object);
            extStringTemplate3.setValue(2, "rec." + string);
            extStringTemplate.setValue(1, (Object)extStringTemplate3);
        }
        return extStringTemplate;
    }

    public ExtStringTemplate makeAliasExp(ExtStringTemplate extStringTemplate, int n) {
        ExtStringTemplate extStringTemplate2 = this.getExtTemplate("selectItemAs");
        extStringTemplate2.setValue(1, (Object)extStringTemplate);
        String string = extStringTemplate.toString();
        boolean bl = this.isAliasRequired(extStringTemplate);
        if (bl) {
            extStringTemplate2.setValue(2, "alias" + n);
        }
        return extStringTemplate2;
    }

    public boolean isAliasRequired(ExtStringTemplate extStringTemplate) {
        String string = extStringTemplate.getStringTemplate().toStructureString();
        return !string.equals("expression[leftExpr]:\n  dbObject[part]:\n");
    }

    public String getAlias(StringTemplate stringTemplate) {
        String string = null;
        String string2 = stringTemplate.toString();
        int n = string2.lastIndexOf(" AS ") + 4;
        string = n == 3 ? string2 : string2.substring(n);
        return string;
    }

    public StringTemplate.STAttributeList getAliasList(StringTemplate.STAttributeList sTAttributeList) {
        StringTemplate.STAttributeList sTAttributeList2 = new StringTemplate.STAttributeList();
        for (Object e : sTAttributeList) {
            sTAttributeList2.add((Object)this.getAlias((StringTemplate)e));
        }
        return sTAttributeList2;
    }
}

