/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.HashMap;
import java.util.Set;
import oracle.javatools.util.Log;

public class TypeMap<K, V> {
    private HashMap<Class<? extends K>, V> map = new HashMap();
    private static final Log LOG = new Log("typemap");

    public void clear() {
        this.map.clear();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Class<? extends K> key) {
        return this.get(key) != null;
    }

    public V get(Class<? extends K> key) {
        LOG.trace("get {0}", key);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        Class<K> type = key;
        do {
            Class match;
            if ((match = this.matchInterfaces(type.getInterfaces())) != null) {
                V value = this.map.get(match);
                this.map.put(key, value);
                return value;
            }
            if ((type = type.getSuperclass()) == null) {
                return null;
            }
            LOG.trace("test superclass {0}", type);
        } while (!this.map.containsKey(type));
        V value = this.map.get(type);
        this.map.put(key, value);
        return value;
    }

    public V put(Class<? extends K> key, V value) {
        return this.map.put(key, value);
    }

    public Set<Class<? extends K>> keySet() {
        return this.map.keySet();
    }

    private Class matchInterfaces(Class[] interfaces) {
        for (int i = 0; i < interfaces.length; ++i) {
            Class type = interfaces[i];
            LOG.trace("test interface {0}", type);
            if (this.map.containsKey(type)) {
                return type;
            }
            Class match = this.matchInterfaces(type.getInterfaces());
            if (match == null) continue;
            return match;
        }
        return null;
    }
}

