/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ArrayIterator;
import oracle.javatools.util.CommandException;
import oracle.javatools.util.CommandModel;
import oracle.javatools.util.Log;
import oracle.javatools.util.TypeMap;

public class CommandParser {
    private Map<String, String> options = new HashMap<String, String>();
    private Set<String> parameters = new LinkedHashSet<String>();
    private Map<String, Class<?>> types = new HashMap();
    private boolean listParameterDefined = false;
    private String[] requirements = new String[0];
    private List<String[]> conditionalRequirements = new ArrayList<String[]>();
    private Map<String, String[]> supersedingSets = new HashMap<String, String[]>();
    private boolean argumentFilesEnabled;
    private TypeMap<Object, Converter<?>> converters = new TypeMap();
    private static final Log LOG = new Log("command");

    public CommandParser() {
        this.defineConverter(new ByteConverter());
        this.defineConverter(new ShortConverter());
        this.defineConverter(new CharacterConverter());
        this.defineConverter(new IntegerConverter());
        this.defineConverter(new LongConverter());
        this.defineConverter(new FloatConverter());
        this.defineConverter(new DoubleConverter());
        this.defineConverter(new StringConverter());
        this.defineConverter(new FileConverter());
        this.defineConverter(new URLConverter());
        this.defineConverter(new EnumConverter());
    }

    public void setArgumentFilesEnabled(boolean argumentFilesEnabled) {
        this.argumentFilesEnabled = argumentFilesEnabled;
    }

    public void defineConverter(Converter<?> converter) {
        this.converters.put(converter.getType(), converter);
    }

    public void defineOption(String name) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        this.types.put(name, null);
        this.options.put(name, name);
    }

    public void defineOption(String name, Class<?> type) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        if (!this.isConvertable(type)) {
            throw new IllegalArgumentException("no converter defined for " + type);
        }
        this.types.put(name, type);
        this.options.put(name, name);
    }

    public void defineParameter(String name, Class<?> type) {
        if (this.isDefined(name)) {
            throw new IllegalArgumentException(name + " already defined");
        }
        if (!this.isConvertable(type)) {
            throw new IllegalArgumentException("no converter defined for " + type);
        }
        if (type.isArray()) {
            if (this.listParameterDefined) {
                throw new IllegalArgumentException("list parameter already defined");
            }
            this.listParameterDefined = true;
        }
        this.types.put(name, type);
        this.parameters.add(name);
    }

    private boolean isConvertable(Class<?> type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return this.converters.containsKey(type);
    }

    public void defineSuperseding(String ... options) {
        for (String option : options) {
            if (!this.isDefined(option)) {
                throw new IllegalArgumentException("option " + option + " not defined");
            }
            if (this.supersedingSets.containsKey(option)) {
                throw new IllegalArgumentException("option " + option + " already in a superseding set");
            }
            this.supersedingSets.put(option, options);
        }
    }

    public void defineRequirement(String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("names.length == 0");
        }
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.isDefined(name)) continue;
            throw new IllegalArgumentException("name " + name + " not parameter or option");
        }
        this.requirements = names;
    }

    public void defineRequirementPresent(String precedent, String antecedent) {
        if (!this.isDefined(precedent)) {
            throw new IllegalArgumentException(precedent + " not defined");
        }
        if (!this.isDefined(antecedent)) {
            throw new IllegalArgumentException(antecedent + " not defined");
        }
        this.conditionalRequirements.add(new String[]{precedent, antecedent});
    }

    public void defineRequirementAbsent(String precedent, String antecedent) {
        if (!this.isDefined(precedent)) {
            throw new IllegalArgumentException(precedent + " not defined");
        }
        if (!this.isDefined(antecedent)) {
            throw new IllegalArgumentException(antecedent + " not defined");
        }
        this.conditionalRequirements.add(new String[]{precedent, '!' + antecedent});
    }

    public void defineSynonym(String name, String synonym) {
        if (!this.isDefined(name)) {
            throw new IllegalArgumentException("option " + name + " not defined");
        }
        if (this.parameters.contains(name)) {
            throw new IllegalArgumentException(name + " is a parameter");
        }
        if (this.isDefined(synonym)) {
            throw new IllegalArgumentException(synonym + " already defined");
        }
        this.options.put(synonym, name);
        this.types.put(synonym, this.types.get(name));
    }

    public Converter getConverter(Class<?> type) {
        return this.converters.get(type);
    }

    public Class getType(String name) {
        if (!this.isDefined(name)) {
            throw new IllegalArgumentException("name " + name + " not defined");
        }
        return this.types.get(name);
    }

    public boolean isArgumentFilesEnabled() {
        return this.argumentFilesEnabled;
    }

    public boolean isDefined(String name) {
        return this.types.containsKey(name);
    }

    public CommandModel parse(String[] arguments) throws CommandException {
        int i;
        CommandModel parse = new CommandModel(this);
        ArrayList<String> parameterList = new ArrayList<String>();
        URLConverter converter = this.argumentFilesEnabled ? (URLConverter)this.getConverter(URL.class) : null;
        CommandIterator iterator = new CommandIterator(arguments, converter);
        while (iterator.hasNext()) {
            String parameterOrOption = iterator.next();
            if (parameterOrOption.charAt(0) == '-') {
                Class<?> componentType;
                String option = parameterOrOption.substring(1);
                if (!this.options.containsKey(option)) {
                    this.invalidOption(option);
                }
                option = this.options.get(option);
                Class<?> type = this.types.get(option);
                if (this.supersedingSets.containsKey(option)) {
                    String[] options;
                    for (String superseded : options = this.supersedingSets.get(option)) {
                        parse.remove(superseded);
                    }
                }
                if (type == null) {
                    parse.setValue(option, null);
                    continue;
                }
                Class<?> clazz = componentType = type.isArray() ? type.getComponentType() : type;
                if (!iterator.hasNext()) {
                    this.missingOptionValue(option, componentType);
                }
                Object value = this.convertOptionValue(option, componentType, iterator.next());
                if (type.isArray()) {
                    parse.addValue(option, value);
                    continue;
                }
                parse.setValue(option, value);
                continue;
            }
            parameterList.add(parameterOrOption);
        }
        HashMap<String, String> parameterDescriptions = new HashMap<String, String>();
        Iterator<String> parameterIterator = this.parameters.iterator();
        int i2 = 0;
        while (i2 < parameterList.size()) {
            String parameter = (String)parameterList.get(i2++);
            if (!parameterIterator.hasNext()) {
                this.unexpectedParameter(parameter);
            }
            String name = parameterIterator.next();
            Class<?> type = this.types.get(name);
            String description = parameter;
            if (type.isArray()) {
                type = type.getComponentType();
                int length = parameterList.size() - this.parameters.size() + 1;
                if (length <= 0) {
                    length = 1;
                }
                if (length > 1) {
                    description = description + "...";
                }
                while (true) {
                    Object value = this.convertParameterValue(name, type, parameter);
                    parse.addValue(name, value);
                    if (--length != 0) {
                        parameter = (String)parameterList.get(i2++);
                        continue;
                    }
                    break;
                }
            } else {
                Object value = this.convertParameterValue(name, type, parameter);
                parse.setValue(name, value);
            }
            parameterDescriptions.put(name, description);
        }
        int size = this.requirements.length;
        boolean satisfied = size == 0;
        for (i = 0; i < size && !(satisfied = parse.isPresent(this.requirements[i])); ++i) {
        }
        if (!satisfied) {
            this.requirementsUnsatisfied(this.parameters, this.requirements);
        }
        size = this.conditionalRequirements.size();
        for (i = 0; i < size; ++i) {
            String[] requirement = this.conditionalRequirements.get(i);
            String precedent = requirement[0];
            if (!parse.isPresent(precedent)) continue;
            String antecedent = requirement[1];
            if (antecedent.charAt(0) == '!') {
                String name = antecedent.substring(1);
                if (!parse.isPresent(name)) continue;
                this.conditionalRequirementUnsatisfied(precedent, (String)parameterDescriptions.get(precedent), antecedent, (String)parameterDescriptions.get(name));
                continue;
            }
            if (parse.isPresent(antecedent)) continue;
            this.conditionalRequirementUnsatisfied(precedent, (String)parameterDescriptions.get(precedent), antecedent, (String)parameterDescriptions.get(antecedent));
        }
        return parse;
    }

    private Object convertOptionValue(String name, Class<?> type, String argument) throws CommandException {
        Converter<?> converter = this.converters.get(type);
        try {
            return converter.convert(argument, type);
        }
        catch (Throwable e) {
            return this.optionValueConversionFailed(name, converter.getTypeDescription(), argument, e);
        }
    }

    private Object convertParameterValue(String name, Class<?> type, String argument) throws CommandException {
        Converter<?> converter = this.converters.get(type);
        try {
            return converter.convert(argument, type);
        }
        catch (Throwable e) {
            return this.parameterValueConversionFailed(name, converter.getTypeDescription(), argument, e);
        }
    }

    protected void invalidOption(String name) throws CommandException {
        throw new CommandException("invalid-option", name);
    }

    protected void missingOptionValue(String name, Class type) throws CommandException {
        throw new CommandException("missing-option-value", name, type);
    }

    protected Object optionValueConversionFailed(String name, String typeDescription, String argument, Throwable e) throws CommandException {
        throw new CommandException(e, "option-value-conversion-failed", name, typeDescription, argument, e.getMessage());
    }

    protected void unexpectedParameter(String name) throws CommandException {
        throw new CommandException("unexpected-parameter", name);
    }

    protected Object parameterValueConversionFailed(String name, String typeDescription, String argument, Throwable e) throws CommandException {
        throw new CommandException(e, "parameter-value-conversion-failed", name, typeDescription, argument, e.getMessage());
    }

    protected void requirementsUnsatisfied(Set parameters, String[] requirements) throws CommandException {
        String parametersKey = "noparameters";
        StringBuffer parametersList = new StringBuffer();
        String optionsKey = "nooptions";
        StringBuffer optionsList = new StringBuffer();
        for (int i = 0; i < requirements.length; ++i) {
            String name = requirements[i];
            if (parameters.contains(name)) {
                parametersKey = "parameter";
                if (parametersList.length() > 0) {
                    parametersKey = "parameters";
                    parametersList.append(", ");
                }
                parametersList.append(name);
                continue;
            }
            optionsKey = "option";
            if (optionsList.length() > 0) {
                optionsKey = "options";
                optionsList.append(", ");
            }
            optionsList.append(name);
        }
        throw new CommandException(parametersKey + '-' + optionsKey + "-requirements-unsatisfied", parametersList, optionsList);
    }

    protected void conditionalRequirementUnsatisfied(String precedent, String precedentValue, String antecedent, String antecedentValue) throws CommandException {
        boolean negated;
        boolean bl = negated = antecedent.charAt(0) == '!';
        if (negated) {
            antecedent = antecedent.substring(1);
        }
        StringBuffer key = new StringBuffer();
        if (precedentValue != null) {
            key.append("parameter");
        } else {
            key.append("option");
            precedentValue = precedent;
        }
        key.append('-');
        if (antecedentValue != null) {
            key.append("parameter");
        } else {
            key.append("option");
            antecedentValue = antecedent;
        }
        if (negated) {
            key.append("-not-absent");
        } else {
            key.append("-not-present");
        }
        throw new CommandException(key.toString(), precedentValue, antecedentValue);
    }

    private class URLConverter
    implements Converter<URL> {
        private File contextFile;
        private URL contextURL;

        private URLConverter() {
        }

        @Override
        public Class<URL> getType() {
            return URL.class;
        }

        @Override
        public String getTypeDescription() {
            return "URL";
        }

        @Override
        public URL convert(String string, Class<?> type) throws MalformedURLException {
            URL url;
            char c;
            string = string.trim();
            int size = string.length();
            int start = 0;
            if (string.startsWith("url:")) {
                start = 4;
            }
            boolean hasProtocol = false;
            for (int i = start; i < size && (c = string.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                hasProtocol = this.isValid(string.substring(start, i));
                break;
            }
            if (hasProtocol) {
                url = new URL(this.contextURL(), string);
                LOG.trace("converted {0} to {1}, protocol", string, (Object)url);
            } else {
                File file = new File(string);
                if (this.isRelative(file)) {
                    file = new File(this.contextFile(), string);
                }
                url = file.toURI().toURL();
                LOG.trace("converted {0} to {1}, no protocol", string, (Object)url);
            }
            return url;
        }

        private boolean isRelative(File file) {
            if (file.isAbsolute()) {
                return false;
            }
            return file.getPath().charAt(0) != '\\';
        }

        private File contextFile() {
            if (this.contextFile != null) {
                return this.contextFile;
            }
            String directory = System.getProperty("ide.startingcwd");
            if (directory == null) {
                directory = System.getProperty("user.dir");
            }
            if (directory.startsWith("\"") && directory.endsWith("\"")) {
                directory = directory.substring(1, directory.length() - 1);
            }
            this.contextFile = new File(directory);
            return this.contextFile;
        }

        private URL contextURL() throws MalformedURLException {
            if (this.contextURL != null) {
                return this.contextURL;
            }
            this.contextURL = this.contextFile().toURI().toURL();
            return this.contextURL;
        }

        private boolean isValid(String protocol) {
            int size = protocol.length();
            if (size < 2) {
                return false;
            }
            char c = protocol.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            for (int i = 1; i < size; ++i) {
                c = protocol.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
                return false;
            }
            return true;
        }
    }

    private class EnumConverter
    implements Converter<Enum> {
        private EnumConverter() {
        }

        @Override
        public Class<Enum> getType() {
            return Enum.class;
        }

        @Override
        public String getTypeDescription() {
            return "keyword";
        }

        @Override
        public Enum convert(String string, Class<?> type) {
            String description;
            Enum[] constants;
            for (Enum constant : constants = (Enum[])type.getEnumConstants()) {
                String name = constant.name();
                if (!string.equalsIgnoreCase(name)) continue;
                return constant;
            }
            if (constants.length == 1) {
                description = constants[0].name().toLowerCase();
            } else {
                StringBuilder buffer = new StringBuilder("one of ");
                String separator = "";
                for (Enum constant1 : constants) {
                    buffer.append(separator);
                    buffer.append('\"');
                    buffer.append(constant1.name().toLowerCase());
                    buffer.append('\"');
                    separator = ", ";
                }
                description = buffer.toString();
            }
            throw new IllegalArgumentException("expected " + description);
        }
    }

    private class FileConverter
    implements Converter<File> {
        private FileConverter() {
        }

        @Override
        public Class<File> getType() {
            return File.class;
        }

        @Override
        public String getTypeDescription() {
            return "file";
        }

        @Override
        public File convert(String string, Class<?> type) {
            return new File(string);
        }
    }

    private class DoubleConverter
    implements Converter<Double> {
        private DoubleConverter() {
        }

        @Override
        public Class<Double> getType() {
            return Double.class;
        }

        @Override
        public String getTypeDescription() {
            return "double";
        }

        @Override
        public Double convert(String string, Class<?> type) {
            return Double.valueOf(string);
        }
    }

    private class FloatConverter
    implements Converter<Float> {
        private FloatConverter() {
        }

        @Override
        public Class<Float> getType() {
            return Float.class;
        }

        @Override
        public String getTypeDescription() {
            return "float";
        }

        @Override
        public Float convert(String string, Class<?> type) {
            return Float.valueOf(string);
        }
    }

    private class LongConverter
    implements Converter<Long> {
        private LongConverter() {
        }

        @Override
        public Class<Long> getType() {
            return Long.class;
        }

        @Override
        public String getTypeDescription() {
            return "long integer";
        }

        @Override
        public Long convert(String string, Class<?> type) {
            return Long.valueOf(string);
        }
    }

    private class IntegerConverter
    implements Converter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public String getTypeDescription() {
            return "integer";
        }

        @Override
        public Integer convert(String string, Class<?> type) {
            return Integer.valueOf(string);
        }
    }

    private class CharacterConverter
    implements Converter<Character> {
        private CharacterConverter() {
        }

        @Override
        public Class<Character> getType() {
            return Character.class;
        }

        @Override
        public String getTypeDescription() {
            return "character";
        }

        @Override
        public Character convert(String string, Class<?> type) {
            if (string.length() != 1) {
                throw new IllegalArgumentException(string + " not a single character");
            }
            return new Character(string.charAt(0));
        }
    }

    private class ShortConverter
    implements Converter<Short> {
        private ShortConverter() {
        }

        @Override
        public Class<Short> getType() {
            return Short.class;
        }

        @Override
        public String getTypeDescription() {
            return "short integer";
        }

        @Override
        public Short convert(String string, Class<?> type) {
            return Short.valueOf(string);
        }
    }

    private class ByteConverter
    implements Converter<Byte> {
        private ByteConverter() {
        }

        @Override
        public Class<Byte> getType() {
            return Byte.class;
        }

        @Override
        public String getTypeDescription() {
            return "byte";
        }

        @Override
        public Byte convert(String string, Class<?> type) {
            return Byte.valueOf(string);
        }
    }

    private class StringConverter
    implements Converter<String> {
        private StringConverter() {
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String getTypeDescription() {
            return "string";
        }

        @Override
        public String convert(String value, Class<?> type) {
            return value;
        }
    }

    private static class CommandIterator {
        private Iterator<String> commandLine;
        private FileIterator file;
        private String next;
        private URLConverter converter;

        private CommandIterator(String[] arguments, URLConverter converter) {
            this.commandLine = new ArrayIterator<String>(arguments);
            this.converter = converter;
        }

        public boolean hasNext() throws CommandException {
            if (this.next != null) {
                return true;
            }
            while (true) {
                if (this.file != null) {
                    if (this.file.hasNext()) {
                        this.next = this.file.next();
                        return true;
                    }
                    this.file = null;
                    continue;
                }
                if (!this.commandLine.hasNext()) break;
                String next = this.commandLine.next();
                if (next.charAt(0) != '@' || this.converter == null) {
                    this.next = next;
                    return true;
                }
                this.file = new FileIterator(next.substring(1), this.converter);
            }
            return false;
        }

        public String next() throws CommandException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String next = this.next;
            this.next = null;
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static class FileIterator {
            private URL url;
            private BufferedReader reader;
            private String line = "";
            private int index;

            public FileIterator(String name, URLConverter converter) throws CommandException {
                try {
                    this.url = converter.convert(name, (Class)URL.class);
                    this.reader = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream(this.url)));
                }
                catch (Throwable e) {
                    this.argumentFileNotFound(name, e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() throws CommandException {
                if (this.reader == null) {
                    return false;
                }
                while (true) {
                    if (this.index < this.line.length()) {
                        if (Character.isWhitespace(this.line.charAt(this.index))) {
                            ++this.index;
                            continue;
                        }
                        return true;
                    }
                    try {
                        this.index = 0;
                        this.line = this.reader.readLine();
                        if (this.line != null) continue;
                        try {
                            this.reader.close();
                        }
                        catch (IOException f) {
                        }
                        finally {
                            this.reader = null;
                        }
                        return false;
                    }
                    catch (Throwable e) {
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            this.reader = null;
                        }
                        this.argumentFileNotReadable(URLFileSystem.getPlatformPathName(this.url), e);
                        continue;
                    }
                    break;
                }
            }

            public String next() throws CommandException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.line.charAt(this.index) == '\"') {
                    ++this.index;
                    int start = this.index;
                    while (this.index < this.line.length()) {
                        if (this.line.charAt(this.index) != '\"') {
                            ++this.index;
                            continue;
                        }
                        return this.line.substring(start, this.index++);
                    }
                    return this.line.substring(start, this.index);
                }
                int start = this.index;
                while (this.index < this.line.length() && !Character.isWhitespace(this.line.charAt(this.index))) {
                    ++this.index;
                }
                return this.line.substring(start, this.index);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected Object argumentFileNotFound(String name, Throwable e) throws CommandException {
                throw new CommandException(e, "argument-file-not-found", name, e);
            }

            protected Object argumentFileNotReadable(String name, Throwable e) throws CommandException {
                throw new CommandException(e, "argument-file-not-readable", name, e);
            }
        }
    }

    public static interface Converter<T> {
        public Class<T> getType();

        public String getTypeDescription();

        public T convert(String var1, Class<?> var2) throws Exception;
    }
}

