/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.patch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareDifference;
import oracle.javatools.compare.algorithm.sequence.SequenceCompareModel;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.patch.PatchApplyOptions;
import oracle.javatools.patch.PatchContext;
import oracle.javatools.patch.PatchContributor;
import oracle.javatools.patch.PatchCreateOptions;
import oracle.javatools.patch.PatchEntry;
import oracle.javatools.patch.PatchEvent;
import oracle.javatools.patch.PatchFileComparator;
import oracle.javatools.patch.PatchHunk;
import oracle.javatools.patch.PatchHunkLine;
import oracle.javatools.patch.PatchIndexFile;
import oracle.javatools.patch.PatchListener;
import oracle.javatools.patch.PatchMatchOptions;
import oracle.javatools.patch.PatchModel;

public class PatchEngine {
    private static final int ENTRY_STATE_ADDED = 1;
    private static final int ENTRY_STATE_REMOVED = 2;
    private static final int ENTRY_STATE_MODIFIED = 3;
    private final PatchContributor _toFileContributor;
    private final Collection _patchListeners = new ArrayList();

    public PatchEngine(PatchContributor toFileContributor) {
        this._toFileContributor = toFileContributor;
    }

    public void addPatchListener(PatchListener l) {
        this._patchListeners.add(l);
    }

    public void removePatchListener(PatchListener l) {
        this._patchListeners.remove(l);
    }

    public PatchModel createModel(PatchContributor fromFileContributor, PatchCreateOptions createOptions) throws IOException, CompareFailedException {
        final PatchFileComparator fileComparator = new PatchFileComparator();
        fileComparator.setBaseDirectoryPaths(fromFileContributor.getBaseDirectoryPath(), this._toFileContributor.getBaseDirectoryPath());
        fileComparator.setEquivalientPaths(fromFileContributor.getFilePath(), this._toFileContributor.getFilePath());
        ArrayList filePathItems = new ArrayList();
        String[] fromFilePaths = fromFileContributor.listFilePaths(createOptions.isRecursive());
        for (int i = 0; i < fromFilePaths.length; ++i) {
            this.findOrCreateFilePath(filePathItems, fileComparator, fromFilePaths[i]).setFromFilePath(fromFilePaths[i]);
        }
        String[] toFilePaths = this._toFileContributor.listFilePaths(createOptions.isRecursive());
        for (int i = 0; i < toFilePaths.length; ++i) {
            this.findOrCreateFilePath(filePathItems, fileComparator, toFilePaths[i]).setToFilePath(toFilePaths[i]);
        }
        Collections.sort(filePathItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                FilePath fp1 = (FilePath)o1;
                FilePath fp2 = (FilePath)o2;
                String path1 = fp1.getFromFilePath() != null ? fp1.getFromFilePath() : fp1.getToFilePath();
                String path2 = fp2.getFromFilePath() != null ? fp2.getFromFilePath() : fp2.getToFilePath();
                return fileComparator.compare(path1, path2);
            }
        });
        PatchModel model = new PatchModel();
        for (FilePath filePathItem : filePathItems) {
            PatchEntry entry;
            String fromFilePath = filePathItem.getFromFilePath();
            String toFilePath = filePathItem.getToFilePath();
            if (!createOptions.isIncludeNewFiles() && (fromFilePath == null || toFilePath == null)) continue;
            String derivedFromFilePath = null;
            if (fromFilePath != null) {
                derivedFromFilePath = PatchEngine.stripFilePathBase(fromFilePath, fromFileContributor.getBaseDirectoryPath());
            }
            String derivedToFilePath = null;
            if (toFilePath != null) {
                derivedToFilePath = PatchEngine.stripFilePathBase(toFilePath, this._toFileContributor.getBaseDirectoryPath());
            }
            PatchIndexFile fromIndexFile = derivedFromFilePath != null ? fromFileContributor.constructIndexFile(derivedFromFilePath) : null;
            PatchIndexFile toIndexFile = derivedToFilePath != null ? this._toFileContributor.constructIndexFile(derivedToFilePath) : null;
            TextBuffer fromFileTextBuffer = null;
            TextBuffer toFileTextBuffer = null;
            toFileTextBuffer = toIndexFile != null ? toIndexFile.getTextBuffer() : TextBufferFactory.createArrayTextBuffer();
            fromFileTextBuffer = fromIndexFile != null ? fromIndexFile.getTextBuffer() : TextBufferFactory.createArrayTextBuffer();
            if (fromFileTextBuffer != null && toFileTextBuffer != null) {
                String type = fromFilePath != null ? PatchEngine.extractFilePathExtension(fromFilePath) : PatchEngine.extractFilePathExtension(toFilePath);
                boolean ignoreWhitespace = createOptions.isIgnoreWhitespace();
                CompareModel compareModel = CompareModelFactory.createCompareModel(new CompareContributorImpl(fromFileTextBuffer, type, ignoreWhitespace), new CompareContributorImpl(toFileTextBuffer, type, ignoreWhitespace));
                entry = PatchEngine.createPatchEntry((SequenceCompareModel)compareModel);
            } else {
                entry = new PatchEntry();
            }
            if (fromIndexFile != null) {
                entry.setFromFile(fromFilePath);
                entry.setFromFileModificationTime(new Date(fromIndexFile.lastModified()));
                entry.setFromFileRevision(fromIndexFile.getRevision());
            }
            if (toIndexFile != null) {
                entry.setToFile(toFilePath);
                entry.setToFileModificationTime(new Date(toIndexFile.lastModified()));
                entry.setToFileRevision(toIndexFile.getRevision());
            }
            if (fromIndexFile == null && toIndexFile == null) {
                throw new IllegalStateException();
            }
            if (this.getEntryState(entry) == 3 && entry.getHunks().length <= 0) continue;
            model.addEntry(entry);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchContext matchModel(PatchModel patchModel, PatchMatchOptions matchOptions) throws IOException {
        PatchContext context = new PatchContext();
        context.setPrefixSlashNumber(matchOptions.getPrefixSlashNumber());
        PatchEntry[] entries = patchModel.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getFromFile() == null && entries[i].getToFile() == null) continue;
            if (this.getEntryState(entries[i]) == 1) {
                context.setEntryMatched(entries[i], true);
            }
            if (this.getEntryState(entries[i]) == 2) continue;
            String derivedFromFilePath = null;
            if (entries[i].getFromFile() != null) {
                derivedFromFilePath = PatchEngine.stripFilePathPrefix(entries[i].getFromFile(), matchOptions.getPrefixSlashNumber());
            }
            if (derivedFromFilePath == null) continue;
            PatchIndexFile entryIndexFile = this._toFileContributor.constructIndexFile(derivedFromFilePath);
            if (this.getEntryState(entries[i]) != 1 && (!entryIndexFile.exists() || entryIndexFile.isDirectory())) continue;
            context.setEntryMatched(entries[i], true);
            TextBuffer entryTextBuffer = entryIndexFile.getTextBuffer();
            entryTextBuffer.setReadOnly(true);
            PatchHunk[] hunks = entries[i].getHunks();
            for (int j = 0; j < hunks.length; ++j) {
                entryTextBuffer.readLock();
                try {
                    context.setHunkMatchLine(hunks[j], this.findBufferHunkMatchLine(entryTextBuffer, hunks[j], matchOptions));
                    continue;
                }
                finally {
                    entryTextBuffer.readUnlock();
                }
            }
        }
        return context;
    }

    public void applyModel(PatchModel patchModel, PatchContext patchContext, PatchApplyOptions applyOptions) throws IOException {
        PatchEntry[] entries = patchModel.getEntries();
        this.firePatchEvent(new PatchEvent(this, 1));
        this.firePatchEvent(new PatchEvent(this, 12, 0.0f));
        for (int i = 0; i < entries.length; ++i) {
            int entryState;
            this.firePatchEvent(new PatchEvent(this, 12, Math.min((float)((i + 1) / entries.length), 1.0f)));
            if (!patchContext.isEntryMatched(entries[i]) || entries[i].getFromFile() == null && entries[i].getToFile() == null || (entryState = this.getEntryState(entries[i])) <= 0) continue;
            PatchIndexFile entryIndexFile = null;
            if (entries[i].getFromFile() != null) {
                String derivedFromFilePath = PatchEngine.stripFilePathPrefix(entries[i].getFromFile(), patchContext.getPrefixSlashNumber());
                entryIndexFile = this._toFileContributor.constructIndexFile(derivedFromFilePath);
                if (applyOptions.isMakeBackupFiles()) {
                    String backupFileName = entryIndexFile.getBackupName();
                    if (entryIndexFile.createBackup(backupFileName)) {
                        this.firePatchEvent(new PatchEvent(this, 6, derivedFromFilePath, backupFileName));
                    } else {
                        this.firePatchEvent(new PatchEvent(this, 7, derivedFromFilePath, backupFileName));
                        continue;
                    }
                }
                if (this.getEntryState(entries[i]) == 2) {
                    if (entryIndexFile.delete()) {
                        this.firePatchEvent(new PatchEvent(this, 4, derivedFromFilePath));
                        continue;
                    }
                    this.firePatchEvent(new PatchEvent(this, 5, derivedFromFilePath));
                    continue;
                }
            } else {
                String derivedToFilePath = PatchEngine.stripFilePathPrefix(entries[i].getToFile(), patchContext.getPrefixSlashNumber());
                entryIndexFile = this._toFileContributor.constructIndexFile(derivedToFilePath);
                if (!entryIndexFile.exists()) {
                    if (entryIndexFile.createNewFile()) {
                        this.firePatchEvent(new PatchEvent(this, 2, derivedToFilePath));
                    } else {
                        this.firePatchEvent(new PatchEvent(this, 3, derivedToFilePath));
                    }
                }
            }
            TextBuffer entryTextBuffer = entryIndexFile.getTextBuffer();
            this.firePatchEvent(new PatchEvent(this, 8, entryIndexFile.getPath()));
            this.applyEntry(entries[i], patchContext, entryTextBuffer);
            if (entryIndexFile.saveTextBuffer()) {
                this.firePatchEvent(new PatchEvent(this, 9, entryIndexFile.getPath()));
            } else {
                this.firePatchEvent(new PatchEvent(this, 10, entryIndexFile.getPath()));
            }
            Date modTime = entries[i].getToFileModificationTime();
            if (modTime == null) continue;
            entryIndexFile.setLastModified(modTime.getTime());
        }
        this.firePatchEvent(new PatchEvent(this, 12, 1.0f));
        this.firePatchEvent(new PatchEvent(this, 11));
    }

    public PatchModel reverseModel(PatchModel patchModel, String fromFileBaseDirectoryPath) {
        PatchModel copyPatchModel = new PatchModel();
        PatchEntry[] patchEntries = patchModel.getEntries();
        for (int i = 0; i < patchEntries.length; ++i) {
            copyPatchModel.addEntry(this.reversePatchEntry(patchEntries[i], fromFileBaseDirectoryPath));
        }
        return copyPatchModel;
    }

    public static final PatchEntry createPatchEntry(SequenceCompareModel compareModel) {
        SequenceCompareDifference[] differences = compareModel.getDifferenceBlocks();
        PatchEntry entry = new PatchEntry();
        for (int i = 0; i < differences.length; ++i) {
            String[] textBufferLines;
            if (differences[i].getKind() == 0) continue;
            PatchHunk hunk = new PatchHunk();
            hunk.setFromFileLineNumber(differences[i].getStart(ContributorKind.FIRST));
            hunk.setFromFileLineCount(differences[i].getLength(ContributorKind.FIRST));
            hunk.setToFileLineNumber(differences[i].getStart(ContributorKind.SECOND) + 1);
            hunk.setToFileLineCount(differences[i].getLength(ContributorKind.SECOND));
            int entryState = -1;
            if (differences[i].isAddition(ContributorKind.FIRST, ContributorKind.SECOND)) {
                entryState = 1;
            }
            if (differences[i].isRemoval(ContributorKind.FIRST, ContributorKind.SECOND)) {
                entryState = 2;
            }
            if (differences[i].isChange(ContributorKind.FIRST, ContributorKind.SECOND)) {
                entryState = 3;
            }
            if (entryState <= 0) continue;
            TextBuffer fromFileTextBuffer = ((TextCompareContributor)compareModel.getContributor(ContributorKind.FIRST)).getTextBuffer();
            if (entryState == 3 || entryState == 2) {
                textBufferLines = PatchEngine.readTextBufferLines(fromFileTextBuffer, hunk.getFromFileLineNumber(), hunk.getFromFileLineCount());
                hunk.setFromFileLineCount(textBufferLines.length);
                for (int j = 0; j < textBufferLines.length; ++j) {
                    PatchHunkLine hunkLine = new PatchHunkLine(3);
                    hunkLine.setLineData(textBufferLines[j]);
                    hunk.addLine(hunkLine);
                }
            }
            TextBuffer toFileTextBuffer = ((TextCompareContributor)compareModel.getContributor(ContributorKind.SECOND)).getTextBuffer();
            if (entryState == 3 || entryState == 1) {
                textBufferLines = PatchEngine.readTextBufferLines(toFileTextBuffer, hunk.getToFileLineNumber() - 1, hunk.getToFileLineCount());
                hunk.setToFileLineCount(textBufferLines.length);
                for (int j = 0; j < textBufferLines.length; ++j) {
                    PatchHunkLine hunkLine = new PatchHunkLine(2);
                    hunkLine.setLineData(textBufferLines[j]);
                    hunk.addLine(hunkLine);
                }
            }
            if (PatchEngine.hunkContainsRemovedLine(hunk)) {
                hunk.setFromFileLineNumber(hunk.getFromFileLineNumber() + 1);
            }
            if (entryState == 2) {
                hunk.setToFileLineNumber(hunk.getToFileLineNumber() - 1);
            }
            if (hunk.getLines().length <= 0) continue;
            entry.addHunk(hunk);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] readTextBufferLines(TextBuffer entryTextBuffer, int i, int count) {
        String[] lines = new String[]{};
        entryTextBuffer.readLock();
        try {
            LineMap lineMap = entryTextBuffer.getLineMap();
            int n = Math.min(i + count, lineMap.getLineCount());
            lines = new String[Math.max(0, n - i)];
            int j = 0;
            while (i < n) {
                int lineOffset = lineMap.getLineStartOffset(i);
                int lineLength = lineMap.getLineEndOffset(i) - lineOffset;
                lines[j++] = PatchEngine.trimEndOfLineChars(entryTextBuffer.getString(lineOffset, lineLength));
                ++i;
            }
        }
        finally {
            entryTextBuffer.readUnlock();
        }
        return lines;
    }

    private static final String trimEndOfLineChars(String s) {
        int length;
        String endOfLineChars = "\r\f\n";
        for (length = s.length(); length > 0 && endOfLineChars.indexOf(s.charAt(length - 1)) >= 0; --length) {
        }
        return length >= s.length() ? s : s.substring(0, length);
    }

    private static final boolean hunkContainsRemovedLine(PatchHunk hunk) {
        PatchHunkLine[] hunkLines = hunk.getLines();
        for (int i = 0; i < hunkLines.length; ++i) {
            if (hunkLines[i].getIndicator() != 3) continue;
            return true;
        }
        return false;
    }

    private FilePath findOrCreateFilePath(Collection filePathItems, Comparator fileComparator, String path) {
        FilePath equalFilePath = null;
        for (FilePath currentFilePath : filePathItems) {
            String path0 = currentFilePath.getFromFilePath() != null ? currentFilePath.getFromFilePath() : currentFilePath.getToFilePath();
            if (fileComparator.compare(path0, path) != 0) continue;
            equalFilePath = currentFilePath;
            break;
        }
        if (equalFilePath == null) {
            equalFilePath = new FilePath();
            filePathItems.add(equalFilePath);
        }
        return equalFilePath;
    }

    private int getEntryState(PatchEntry entry) {
        if (entry.getFromFile() != null && entry.getToFile() == null) {
            return 2;
        }
        if (entry.getFromFile() == null && entry.getToFile() != null) {
            return 1;
        }
        if (entry.getFromFile() != null && entry.getToFile() != null) {
            return 3;
        }
        return -1;
    }

    private int findBufferHunkMatchLine(TextBuffer entryTextBuffer, PatchHunk patchHunk, PatchMatchOptions matchOptions) throws IOException {
        int line = patchHunk.getFromFileLineNumber();
        if (this.matchHunkFromLine(entryTextBuffer, line, patchHunk, matchOptions)) {
            return line;
        }
        if (matchOptions.getMaximumFuzzFactor() <= 0) {
            return -1;
        }
        int n = line + matchOptions.getMaximumFuzzFactor();
        while (line < n) {
            if (!this.matchHunkFromLine(entryTextBuffer, ++line, patchHunk, matchOptions)) continue;
            return line;
        }
        line = patchHunk.getFromFileLineNumber();
        n = line - matchOptions.getMaximumFuzzFactor();
        while (line > Math.max(1, n)) {
            if (!this.matchHunkFromLine(entryTextBuffer, --line, patchHunk, matchOptions)) continue;
            return line;
        }
        return -1;
    }

    private boolean matchHunkFromLine(TextBuffer entryTextBuffer, int line, PatchHunk patchHunk, PatchMatchOptions matchOptions) throws IOException {
        LineMap lineMap = entryTextBuffer.getLineMap();
        int n = line - 1 + patchHunk.getFromFileLineCount();
        if (lineMap.getLineCount() < n) {
            return false;
        }
        PatchHunkLine[] patchHunkLines = patchHunk.getLines();
        int j = 0;
        for (int i = line; i <= n; ++i) {
            while (true) {
                if (j >= patchHunkLines.length) {
                    return true;
                }
                if (patchHunkLines[j].getIndicator() != 2) break;
                ++j;
            }
            int lineOffset = lineMap.getLineStartOffset(Math.max(0, i - 1));
            int lineLength = lineMap.getLineEndOffset(Math.max(0, i - 1)) - lineOffset;
            String textBufferLineData = PatchEngine.trimEndOfLineChars(entryTextBuffer.getString(lineOffset, lineLength));
            String hunkLineData = patchHunkLines[j++].getLineData();
            if (!(matchOptions.isIgnoreWhitespace() ? !this.equalsIgnoreWhitespace(textBufferLineData, hunkLineData) : !textBufferLineData.equals(hunkLineData))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsIgnoreWhitespace(String s1, String s2) {
        int i = 0;
        int j = 0;
        while (i < s1.length() || j < s2.length()) {
            char thatChar;
            char thisChar = i < s1.length() ? s1.charAt(i) : (char)'\u0000';
            char c = thatChar = j < s2.length() ? s2.charAt(j) : (char)'\u0000';
            if (this.isWhitespace(thisChar)) {
                ++i;
                continue;
            }
            if (this.isWhitespace(thatChar)) {
                ++j;
                continue;
            }
            if (thisChar != thatChar) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyEntry(PatchEntry patchEntry, PatchContext patchContext, TextBuffer entryTextBuffer) {
        entryTextBuffer.setReadOnly(false);
        entryTextBuffer.writeLock();
        try {
            LineMap lineMap = entryTextBuffer.getLineMap();
            ArrayList<PatchHunk> hunksToApply = new ArrayList<PatchHunk>();
            ArrayList<OffsetMark> hunkOffsets = new ArrayList<OffsetMark>();
            PatchHunk[] hunks = patchEntry.getHunks();
            for (int i = 0; i < hunks.length; ++i) {
                int lineNumber = patchContext.getHunkMatchLine(hunks[i]);
                if (lineNumber < 0) continue;
                int n = lineNumber + hunks[i].getFromFileLineCount() - 1;
                if (lineMap.getLineCount() < n) continue;
                if (hunks[i].getFromFileLineCount() > 0) {
                    --lineNumber;
                    --n;
                }
                int lineStartOffset = 0;
                int lineEndOffset = 0;
                lineStartOffset = lineMap.getLineStartOffset(Math.max(0, lineNumber));
                lineEndOffset = hunks[i].getFromFileLineCount() <= 0 ? lineStartOffset : Math.max(lineMap.getLineEndOffset(Math.max(0, n)), lineMap.getLineStartOffset(Math.max(0, n)));
                hunksToApply.add(hunks[i]);
                hunkOffsets.add(entryTextBuffer.addOffsetMark(lineStartOffset));
                hunkOffsets.add(entryTextBuffer.addOffsetMark(lineEndOffset));
            }
            boolean endsWithEol = this.determineLineMapEndsWithEOL(lineMap);
            Iterator itr = hunksToApply.iterator();
            Iterator itr2 = hunkOffsets.iterator();
            while (itr.hasNext()) {
                PatchHunk patchHunk = (PatchHunk)itr.next();
                OffsetMark startOffset = (OffsetMark)itr2.next();
                OffsetMark endOffset = (OffsetMark)itr2.next();
                boolean eof = startOffset.getOffset() >= entryTextBuffer.getLength();
                entryTextBuffer.remove(startOffset.getOffset(), endOffset.getOffset() - startOffset.getOffset());
                String[] toFileData = this.extractHunkToFileData(patchHunk);
                StringBuffer insertionDataBuffer = new StringBuffer();
                char[] eol = entryTextBuffer.getEOLType().toCharArray();
                for (int j = 0; j < toFileData.length; ++j) {
                    if (j > 0 || startOffset.getOffset() > 0 && startOffset.getOffset() == endOffset.getOffset() && eof) {
                        insertionDataBuffer.append(eol);
                    }
                    insertionDataBuffer.append(toFileData[j]);
                }
                if (toFileData.length > 0 && (!eof || itr.hasNext() || endsWithEol)) {
                    insertionDataBuffer.append(eol);
                }
                entryTextBuffer.insert(startOffset.getOffset(), insertionDataBuffer.toString().toCharArray());
            }
            itr = hunkOffsets.iterator();
            while (itr.hasNext()) {
                entryTextBuffer.removeOffsetMark((OffsetMark)itr.next());
            }
        }
        finally {
            entryTextBuffer.writeUnlock();
        }
    }

    private boolean determineLineMapEndsWithEOL(LineMap lineMap) {
        int n = lineMap.getLineCount();
        return n > 0 && lineMap.getLineStartOffset(n - 1) == lineMap.getLineEndOffset(n - 1);
    }

    private String[] extractHunkToFileData(PatchHunk patchHunk) {
        PatchHunkLine[] patchHunkLines = patchHunk.getLines();
        ArrayList<String> fileHunkData = new ArrayList<String>();
        for (int i = 0; i < patchHunkLines.length; ++i) {
            if (patchHunkLines[i].getIndicator() == 3) continue;
            fileHunkData.add(patchHunkLines[i].getLineData());
        }
        return fileHunkData.toArray(new String[0]);
    }

    private void firePatchEvent(PatchEvent pe) {
        PatchListener[] l = this._patchListeners.toArray(new PatchListener[0]);
        block14: for (int i = l.length - 1; i >= 0; --i) {
            switch (pe.getID()) {
                case 1: {
                    l[i].patchApplyStarted(pe);
                    continue block14;
                }
                case 2: {
                    l[i].patchFileCreated(pe);
                    continue block14;
                }
                case 3: {
                    l[i].patchFileCreateFailed(pe);
                    continue block14;
                }
                case 4: {
                    l[i].patchFileDeleted(pe);
                    continue block14;
                }
                case 5: {
                    l[i].patchFileDeleteFailed(pe);
                    continue block14;
                }
                case 6: {
                    l[i].patchFileBackedUp(pe);
                    continue block14;
                }
                case 7: {
                    l[i].patchFileBackupFailed(pe);
                    continue block14;
                }
                case 8: {
                    l[i].patchBufferChanging(pe);
                    continue block14;
                }
                case 9: {
                    l[i].patchFileSaved(pe);
                    continue block14;
                }
                case 10: {
                    l[i].patchFileSaveFailed(pe);
                    continue block14;
                }
                case 11: {
                    l[i].patchApplyFinished(pe);
                    continue block14;
                }
                case 12: {
                    l[i].patchProgressUpdated(pe);
                }
            }
        }
    }

    static final String stripFilePathBase(String path, String basePath) {
        return basePath != null && path.startsWith(basePath) ? path.substring(basePath.length()) : path;
    }

    static final String stripFilePathPrefix(String path, int prefixSlashNumber) {
        int i;
        while (path != null && prefixSlashNumber > 0 && (i = path.indexOf(47)) >= 0) {
            path = path.substring(i + 1);
            --prefixSlashNumber;
        }
        return path;
    }

    static final String createFilePath(String path, String basePath) {
        return basePath != null ? basePath + '/' + path : path;
    }

    static final String extractFilePathExtension(String path) {
        int i = path != null ? path.lastIndexOf(46) : -1;
        return i < 0 ? "" : path.substring(i + 1);
    }

    private PatchEntry reversePatchEntry(PatchEntry patchEntry, String fromFileBaseDirectoryPath) {
        String toFile;
        String fromFile;
        PatchEntry copyPatchEntry = new PatchEntry();
        if (patchEntry.getToFile() != null) {
            String derivedFromFilePath = PatchEngine.stripFilePathBase(patchEntry.getToFile(), this._toFileContributor.getBaseDirectoryPath());
            fromFile = PatchEngine.createFilePath(derivedFromFilePath, fromFileBaseDirectoryPath);
        } else {
            fromFile = null;
        }
        if (patchEntry.getFromFile() != null) {
            String derivedToFilePath = PatchEngine.stripFilePathBase(patchEntry.getFromFile(), fromFileBaseDirectoryPath);
            toFile = PatchEngine.createFilePath(derivedToFilePath, this._toFileContributor.getBaseDirectoryPath());
        } else {
            toFile = null;
        }
        copyPatchEntry.setFromFile(fromFile);
        copyPatchEntry.setFromFileModificationTime(patchEntry.getToFileModificationTime());
        copyPatchEntry.setFromFileRevision(patchEntry.getToFileRevision());
        copyPatchEntry.setToFile(toFile);
        copyPatchEntry.setToFileModificationTime(patchEntry.getFromFileModificationTime());
        copyPatchEntry.setToFileRevision(patchEntry.getFromFileRevision());
        PatchHunk[] patchHunks = patchEntry.getHunks();
        for (int i = 0; i < patchHunks.length; ++i) {
            copyPatchEntry.addHunk(this.reversePatchHunk(patchHunks[i]));
        }
        return copyPatchEntry;
    }

    private PatchHunk reversePatchHunk(PatchHunk patchHunk) {
        PatchHunk copyPatchHunk = new PatchHunk();
        copyPatchHunk.setFromFileLineNumber(patchHunk.getToFileLineNumber());
        copyPatchHunk.setFromFileLineCount(patchHunk.getToFileLineCount());
        copyPatchHunk.setToFileLineNumber(patchHunk.getFromFileLineNumber());
        copyPatchHunk.setToFileLineCount(patchHunk.getFromFileLineCount());
        PatchHunkLine[] patchHunkLines = patchHunk.getLines();
        for (int i = 0; i < patchHunkLines.length; ++i) {
            copyPatchHunk.addLine(this.reversePatchHunkLine(patchHunkLines[i]));
        }
        return copyPatchHunk;
    }

    private PatchHunkLine reversePatchHunkLine(PatchHunkLine patchHunkLine) {
        PatchHunkLine copyPatchHunkLine = patchHunkLine;
        if (patchHunkLine.getIndicator() == 2) {
            copyPatchHunkLine = new PatchHunkLine(3);
        }
        if (patchHunkLine.getIndicator() == 3) {
            copyPatchHunkLine = new PatchHunkLine(2);
        }
        copyPatchHunkLine.setLineData(patchHunkLine.getLineData());
        copyPatchHunkLine.setNoNewlineAtEOF(patchHunkLine.isNoNewlineAtEOF());
        return copyPatchHunkLine;
    }

    private class CompareContributorImpl
    extends TextCompareContributor {
        private final TextBuffer _textBuffer;
        private final String _type;

        CompareContributorImpl(TextBuffer textBuffer, String type, boolean ignoreWhitespace) {
            this.setIgnoreWhitespace(ignoreWhitespace);
            this._textBuffer = textBuffer;
            this._type = type;
        }

        @Override
        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        @Override
        public String getType() {
            return this._type;
        }

        @Override
        public String getLongLabel() {
            return "";
        }

        @Override
        public String getShortLabel() {
            return "";
        }
    }

    private class FilePath {
        private String _fromFilePath;
        private String _toFilePath;

        private FilePath() {
        }

        void setFromFilePath(String fromFilePath) {
            this._fromFilePath = fromFilePath;
        }

        String getFromFilePath() {
            return this._fromFilePath;
        }

        void setToFilePath(String toFilePath) {
            this._toFilePath = toFilePath;
        }

        String getToFilePath() {
            return this._toFilePath;
        }
    }
}

