/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public class LexerLiteral
implements JavaConstants {
    private static boolean[] isHexDigit;
    private static boolean[] isOctDigit;
    private static boolean[] isDecDigit;
    private static byte[] hexValue;
    public final short literalToken;
    public short literalError = 0;
    public boolean flag_dw = false;
    public boolean literalBoolean = false;
    public char literalChar = '\u0000';
    public String literalString = null;
    public long literalInteger = 0L;
    public double literalFloat = 0.0;

    public static LexerLiteral scanConstant(FastLexer lexer) {
        boolean literal;
        int token = lexer.getToken();
        boolean bl = literal = 8 <= token && token < 16;
        if (!literal) {
            return null;
        }
        ReadTextBuffer textBuffer = lexer.getTextBuffer();
        int startOffset = lexer.getStartOffset();
        int endOffset = lexer.getEndOffset();
        return new LexerLiteral(textBuffer, token, startOffset, endOffset);
    }

    public static LexerLiteral scanConstant(LexerToken lexerToken, ReadTextBuffer textBuffer) {
        boolean literal;
        int token = lexerToken.getToken();
        boolean bl = literal = 8 <= token && token < 16;
        if (!literal) {
            return null;
        }
        int startOffset = lexerToken.getStartOffset();
        int endOffset = lexerToken.getEndOffset();
        return new LexerLiteral(textBuffer, token, startOffset, endOffset);
    }

    public static LexerLiteral copyConstant(LexerLiteral source) {
        return new LexerLiteral(source);
    }

    private LexerLiteral(LexerLiteral other) {
        this.literalToken = other.literalToken;
        this.literalError = other.literalError;
        this.flag_dw = other.flag_dw;
        this.literalBoolean = other.literalBoolean;
        this.literalChar = other.literalChar;
        this.literalString = other.literalString;
        this.literalInteger = other.literalInteger;
        this.literalFloat = other.literalFloat;
    }

    private LexerLiteral(ReadTextBuffer textBuffer, int token, int start, int end) {
        this.literalToken = (short)token;
        switch (token) {
            case 12: {
                this.scanBooleanLiteral(textBuffer, start, end);
                break;
            }
            case 13: {
                this.scanCharLiteral(textBuffer, start, end);
                break;
            }
            case 9: {
                this.flag_dw = true;
            }
            case 8: {
                this.scanIntegerLiteral(textBuffer, start, end);
                break;
            }
            case 11: {
                this.flag_dw = true;
            }
            case 10: {
                this.scanFloatLiteral(textBuffer, start, end);
                break;
            }
            case 14: {
                this.scanStringLiteral(textBuffer, start, end);
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public Object getConstantValue() {
        switch (this.literalToken) {
            case 12: {
                return this.literalBoolean;
            }
            case 13: {
                return Character.valueOf(this.literalChar);
            }
            case 9: {
                return this.literalInteger;
            }
            case 8: {
                return (int)this.literalInteger;
            }
            case 11: {
                return this.literalFloat;
            }
            case 10: {
                return Float.valueOf((float)this.literalFloat);
            }
            case 14: {
                return this.literalString;
            }
        }
        return null;
    }

    private void scanBooleanLiteral(ReadTextBuffer buffer, int start, int end) {
        this.literalBoolean = buffer.getChar(start) == 't';
    }

    private void scanStringLiteral(ReadTextBuffer buffer, int start, int end) {
        if (end > start + 2) {
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            this.literalString = this.source2string(chars);
        } else {
            this.literalString = "";
        }
    }

    private void scanCharLiteral(ReadTextBuffer buffer, int start, int end) {
        if (end == start + 2) {
            this.literalError = (short)75;
        } else if (end > start + 2) {
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            String string = this.source2string(chars);
            this.literalChar = string.charAt(0);
            if (string.length() > 1) {
                this.literalError = (short)76;
            }
        }
    }

    private void scanIntegerLiteral(ReadTextBuffer buffer, int start, int end) {
        int value = 0;
        try {
            int pos = start;
            char ch = buffer.getChar(pos++);
            if (ch == '0') {
                if (end == pos) {
                    return;
                }
                if ((ch = buffer.getChar(pos++)) == 'x' || ch == 'X') {
                    while (pos < end && (ch = buffer.getChar(pos++)) < '\u0100' && isHexDigit[ch]) {
                        value *= 16;
                        value += hexValue[ch];
                    }
                } else {
                    while (pos < end && (ch = buffer.getChar(pos++)) < '\u0100' && isOctDigit[ch]) {
                        value *= 8;
                        value += hexValue[ch];
                    }
                }
            } else {
                value = hexValue[ch];
                if (value != 0) {
                    while (pos < end && (ch = buffer.getChar(pos++)) < '\u0100' && isDecDigit[ch]) {
                        value *= 10;
                        value += hexValue[ch];
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        this.literalInteger = value;
    }

    private boolean isZeroFloating(ReadTextBuffer buffer, int start, int end) {
        for (int i = start; i < end; ++i) {
            char ch = buffer.getChar(i);
            if (49 >= i || i > 57) continue;
            return false;
        }
        return true;
    }

    private strictfp void scanFloatLiteral(ReadTextBuffer buffer, int start, int end) {
        this.flag_dw = true;
        char ch = buffer.getChar(end - 1);
        boolean includeLast = true;
        if (ch == 'f' || ch == 'F') {
            this.flag_dw = false;
            includeLast = false;
        } else if (ch == 'd' || ch == 'D') {
            includeLast = false;
        }
        int effectiveLength = end - start;
        if (!includeLast) {
            --effectiveLength;
        }
        String text = buffer.getString(start, effectiveLength);
        try {
            double value = this.flag_dw ? Double.parseDouble(text) : (double)Float.parseFloat(text);
            if (value == 0.0 && !this.isZeroFloating(buffer, start, end)) {
                this.literalError = (short)6;
            } else if (value == Double.POSITIVE_INFINITY) {
                this.literalError = (short)5;
            }
            this.literalFloat = value;
        }
        catch (NumberFormatException e) {
            this.literalError = (short)4;
        }
    }

    private String source2string(char[] input) {
        int count = input.length;
        return this.source2string(input, 0, count);
    }

    private String source2string(char[] source, int offset, int length) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        block12: while (i < length) {
            if (source[offset + i] == '\\' && i + 1 < length) {
                switch (source[offset + ++i]) {
                    case 'n': {
                        buffer.append('\n');
                        ++i;
                        continue block12;
                    }
                    case 't': {
                        buffer.append('\t');
                        ++i;
                        continue block12;
                    }
                    case 'b': {
                        buffer.append('\b');
                        ++i;
                        continue block12;
                    }
                    case 'r': {
                        buffer.append('\r');
                        ++i;
                        continue block12;
                    }
                    case 'f': {
                        buffer.append('\f');
                        ++i;
                        continue block12;
                    }
                    case '\'': {
                        buffer.append('\'');
                        ++i;
                        continue block12;
                    }
                    case '\"': {
                        buffer.append('\"');
                        ++i;
                        continue block12;
                    }
                    case '\\': {
                        buffer.append('\\');
                        ++i;
                        continue block12;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        StringBuilder octalValue = new StringBuilder();
                        octalValue.append(source[offset + i]);
                        ++i;
                        for (int count = 1; count < 3 && i < length && LexerLiteral.isOctalDigit(source[offset + i]); ++count, ++i) {
                            octalValue.append(source[offset + i]);
                        }
                        buffer.append((char)Integer.valueOf(octalValue.toString(), 8).intValue());
                        continue block12;
                    }
                    case 'u': {
                        int l;
                        for (l = i + 1; l < length && source[offset + l] == 'u'; ++l) {
                        }
                        if (l + 4 > length) break;
                        char code = '\u0000';
                        int d = 0;
                        for (int k = 0; k < 4; ++k) {
                            d = LexerLiteral.digit2int(source[offset + l + k], 16);
                            if (d < 0) {
                                this.literalError = (short)77;
                                break;
                            }
                            code = (char)(code << 4);
                            code = (char)(code + (char)d);
                        }
                        if (d < 0) break;
                        buffer.append(code);
                        i = l + 4;
                        continue block12;
                    }
                }
                this.literalError = (short)77;
            }
            char b = source[offset + i++];
            buffer.append(b);
        }
        return buffer.toString();
    }

    private static boolean isOctalDigit(char ch) {
        int intValue = LexerLiteral.digit2int(ch, 10);
        return intValue >= 0 && intValue < 8;
    }

    public static int digit2int(char ch, int base) {
        if ('0' <= ch && ch <= '9' && ch < 48 + base) {
            return ch - 48;
        }
        if ('A' <= ch && ch < 65 + base - 10) {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch < 97 + base - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    static {
        int i;
        isHexDigit = new boolean[256];
        isOctDigit = new boolean[256];
        isDecDigit = new boolean[256];
        hexValue = new byte[256];
        for (i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            LexerLiteral.isOctDigit[i] = true;
            LexerLiteral.isDecDigit[i] = true;
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 48);
        }
        LexerLiteral.isOctDigit[56] = false;
        LexerLiteral.isOctDigit[57] = false;
        for (i = 97; i <= 102; i = (int)((byte)(i + 1))) {
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((byte)(i + 1))) {
            LexerLiteral.isHexDigit[i] = true;
            LexerLiteral.hexValue[i] = (byte)(i - 65 + 10);
        }
    }
}

