/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocReferenceSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.DotExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class ImportHelper
implements InternalConstants {
    private final FileSym fileSym;
    private final Set importNames;
    private final SourcePreferences preferences;
    private ArrayList<TypeSym> typeSyms = new ArrayList();
    private ArrayList<DotExpr> dotExprs = new ArrayList();
    private ArrayList<DocReferenceSym> docReferenceSyms = new ArrayList();
    private ArrayList<AnnotateSym> annotateSyms = new ArrayList();
    public String addImportName;
    public String simplifiedName;

    public ImportHelper(FileSym fileSym) {
        this.fileSym = fileSym;
        this.importNames = fileSym.getSourceImportNames();
        this.preferences = fileSym.getPreferences();
    }

    public void process() {
        ImportHelperTraversal iht = new ImportHelperTraversal();
        this.processImpl(iht);
    }

    public void process(Sym subtree) {
        ImportHelperTraversal iht = new ImportHelperTraversal(false);
        this.processImpl(iht);
    }

    private void processImpl(ImportHelperTraversal iht) {
        Iterator<TreeSym> iterator;
        this.fileSym.traverseSelf(iht);
        if (!this.typeSyms.isEmpty()) {
            for (TypeSym typeSym : this.typeSyms) {
                this.performAutoImport(typeSym);
            }
            this.typeSyms.clear();
        }
        if (!this.dotExprs.isEmpty()) {
            iterator = this.dotExprs.iterator();
            while (iterator.hasNext()) {
                try {
                    DotExpr dotExpr = (DotExpr)iterator.next();
                    if (dotExpr.getParent() == null) continue;
                    this.performAutoImport(dotExpr);
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            }
            this.dotExprs.clear();
        }
        if (!this.docReferenceSyms.isEmpty()) {
            iterator = this.docReferenceSyms.iterator();
            while (iterator.hasNext()) {
                try {
                    DocReferenceSym docReferenceSym = (DocReferenceSym)iterator.next();
                    this.performAutoImport(docReferenceSym);
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            }
            this.dotExprs.clear();
        }
        if (!this.annotateSyms.isEmpty()) {
            for (AnnotateSym annotateSym : this.annotateSyms) {
                this.performAutoImport(annotateSym);
            }
            this.annotateSyms.clear();
        }
    }

    public final void performAutoImport(TypeSym typeSym) {
        this.performAutoImport(typeSym, typeSym.getName());
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(typeSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(DotExpr dotExpr) {
        String name = dotExpr.getQualifiedName();
        this.performAutoImport(dotExpr, name);
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(dotExpr, this.simplifiedName);
        }
    }

    public final void performAutoImport(DocReferenceSym docReferenceSym) {
        String name = docReferenceSym.refClassName;
        this.performAutoImport(docReferenceSym, name);
        if (this.addImportName == null && this.simplifiedName != null) {
            this.dropPrefix(docReferenceSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(AnnotateSym annotateSym) {
        this.performAutoImport(annotateSym, annotateSym.getName());
        if (this.addImportName != null) {
            this.importNames.add(this.addImportName);
        }
        if (this.simplifiedName != null) {
            this.dropPrefix(annotateSym, this.simplifiedName);
        }
    }

    public final void performAutoImport(Sym sym, String typeName) {
        JavaType resolvedType;
        String targetName;
        this.addImportName = null;
        this.simplifiedName = null;
        int typeLastDot = typeName.lastIndexOf(46);
        if (typeLastDot == -1) {
            return;
        }
        String prefix = typeName.substring(0, typeLastDot);
        String importName = targetName = typeName.substring(typeLastDot + 1);
        JavaProvider provider = this.fileSym.getProvider();
        if (provider == null) {
            return;
        }
        CompilerDriver compiler = new CompilerDriver(provider, this.fileSym.j2se);
        JavaType prefixResult = compiler.resolveType(sym, prefix);
        if (prefixResult != null) {
            boolean importInnerClassName = this.preferences.getBoolean(64);
            String fullPrefix = prefixResult.getQualifiedName();
            if (!prefix.equals(fullPrefix)) {
                if (!importInnerClassName) {
                    return;
                }
                prefix = fullPrefix;
            } else if (!importInnerClassName) {
                prefix = prefixResult.getPackageName();
                importName = prefixResult.getName();
                targetName = typeName.substring(prefix.length() + 1);
            }
        }
        boolean needsImport = true;
        boolean requiresNarrow = false;
        JavaType result = compiler.resolveType(sym, importName);
        if (result != null) {
            int lastDot;
            String resultQualified = result.getQualifiedName();
            String resultPrefix = resultQualified.substring(0, lastDot = resultQualified.lastIndexOf(46));
            if (!prefix.equals(resultPrefix)) {
                requiresNarrow = true;
                if (!this.isSafeToAddNarrowImport(importName)) {
                    return;
                }
            } else {
                needsImport = false;
            }
        }
        if (!(prefixResult != null || result != null || (resolvedType = compiler.resolveType(sym, typeName)) != null && this.isSafeToAddNarrowImport(importName))) {
            return;
        }
        if (needsImport) {
            this.addImportName = prefix + '.' + importName;
        }
        this.simplifiedName = targetName;
    }

    private void dropPrefix(TypeSym sym, String targetName) {
        TypeSym typeSym = sym;
        typeSym.setName(targetName);
    }

    private void dropPrefix(DotExpr sym, String targetName) {
        DotExpr dotExpr = sym;
        FileSym fileSym = dotExpr.symFile;
        SymFactory factory = fileSym.getSymFactory();
        try {
            Expr e = (Expr)factory.createExpression(targetName);
            dotExpr.replaceSelf(e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void dropPrefix(DocReferenceSym sym, String targetName) {
        try {
            DocReferenceSym clone = (DocReferenceSym)sym.cloneSelf(this.fileSym);
            clone.refClassName = targetName;
            sym.replaceSelf(clone);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void dropPrefix(AnnotateSym sym, String targetName) {
        sym.setName(targetName);
    }

    private boolean isSafeToAddNarrowImport(String name) {
        if (name.length() == 0) {
            return false;
        }
        for (String imported : this.importNames) {
            if (!imported.endsWith(name)) continue;
            return false;
        }
        SourceClass c = this.fileSym.getSourceClass(name);
        return c == null;
    }

    private class ImportHelperTraversal
    extends Sym.SymTraversal {
        private final boolean onlyNew;

        ImportHelperTraversal() {
            this(true);
        }

        ImportHelperTraversal(boolean onlyNew) {
            this.onlyNew = onlyNew;
        }

        @Override
        protected boolean enter(Sym sym) {
            if (this.onlyNew && (sym.symFormat & 2) == 0) {
                return true;
            }
            if ((sym.symFormat & 0x20) != 0) {
                return true;
            }
            switch (sym.symKind) {
                case 27: {
                    ImportHelper.this.typeSyms.add((TypeSym)sym);
                    break;
                }
                case 49: {
                    DotExpr dotExpr = (DotExpr)sym;
                    if (!dotExpr.isQualifiedName()) break;
                    while (dotExpr != null) {
                        DotExpr e = dotExpr;
                        dotExpr = null;
                        JavaHasType result = e.getResolvedObject();
                        if (result != null && result.getElementKind() == 3) {
                            ImportHelper.this.dotExprs.add(e);
                            continue;
                        }
                        Expr lhs = e.getLhsOperandSym();
                        if (lhs == null || lhs.symKind != 49) continue;
                        dotExpr = (DotExpr)lhs;
                    }
                    break;
                }
                case 66: {
                    DocReferenceSym docReferenceSym = (DocReferenceSym)sym;
                    String className = docReferenceSym.refClassName;
                    if (className == null || className.length() <= 0) break;
                    ImportHelper.this.docReferenceSyms.add(docReferenceSym);
                    break;
                }
                case 1: {
                    ImportHelper.this.annotateSyms.add((AnnotateSym)sym);
                }
            }
            return true;
        }
    }
}

