/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareUtils;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.util.FormatRegion;
import oracle.javatools.parser.java.v2.internal.util.TokenMap;

public final class FormatHelper
extends InternalUtilities {
    private final FileSym fileSym;
    private FileSym formattedFile = null;
    private final FormatRegion[] regions;
    private boolean success = false;
    private TokenMap tokenMap;

    public FormatHelper(FileSym fileSym, FormatRegion region) {
        if (region == null) {
            throw new IllegalArgumentException();
        }
        this.fileSym = fileSym;
        this.regions = new FormatRegion[]{region};
    }

    public FormatHelper(FileSym fileSym, FormatRegion[] regions) {
        if (regions == null) {
            throw new IllegalArgumentException();
        }
        this.fileSym = fileSym;
        this.regions = regions;
    }

    public boolean process() {
        if (this.fileSym.getTransactionSym() == null) {
            FormatHelper.panic();
        }
        if (this.success) {
            FormatHelper.panic();
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.fileSym.print(printWriter);
            TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
            char[] chars = stringWriter.toString().toCharArray();
            textBuffer.insert(0, chars);
            this.formattedFile = (FileSym)JavaParser.parse(textBuffer, this.fileSym.j2se);
            this.formattedFile.setTextBuffer(textBuffer);
            this.tokenMap = new TokenMap(this.fileSym, this.formattedFile);
            int count = this.regions.length;
            for (int i = count - 1; i >= 0; --i) {
                FormatRegion region = this.regions[i];
                this.performRegionReplace(region);
            }
            this.success = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.success;
    }

    private void performRegionReplace(FormatRegion region) {
        int dirtyStartIndex = region.fromIndices.getStartOffset();
        int dirtyStartOffset = this.fileSym.tokens.tokenStarts[dirtyStartIndex];
        int dirtyEndIndex = region.fromIndices.getEndOffset();
        int dirtyEndOffset = this.fileSym.tokens.tokenEnds[dirtyEndIndex];
        int dirtyLength = dirtyEndOffset - dirtyStartOffset;
        if (dirtyLength <= 0) {
            FormatHelper.panic();
        }
        int targetStartIndex = region.toIndices.getStartOffset();
        int targetStartOffset = this.formattedFile.tokens.tokenStarts[targetStartIndex];
        int targetEndIndex = region.toIndices.getEndOffset();
        int targetEndOffset = this.formattedFile.tokens.tokenEnds[targetEndIndex];
        int targetLength = targetEndOffset - targetStartOffset;
        if (targetLength <= 0) {
            FormatHelper.panic();
        }
        TextBuffer formattedBuffer = this.formattedFile.getTextBuffer();
        char[] targetText = formattedBuffer.getChars(targetStartOffset, targetLength);
        TextBuffer textBuffer = this.fileSym.getTextBuffer();
        CompareUtils.replaceText(textBuffer, dirtyStartOffset, dirtyLength, targetText);
    }
}

