/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;

public final class DotExpr
extends Expr
implements SourceDotExpression {
    @Override
    public Object getConstantValue() {
        if (!this.isQualifiedName()) {
            return null;
        }
        JavaHasType result = this.getResolvedObject();
        if (result == null || result.getElementKind() != 5) {
            return null;
        }
        JavaField thing = (JavaField)result;
        return thing.getConstantValue();
    }

    @Override
    public Expr getLhsOperandSym() {
        return this.getNthOperandSym(0);
    }

    @Override
    public void setLhsOperandSym(Expr e) {
        this.setSym((byte)83, e);
    }

    public boolean isQualifiedName() {
        Expr lhsSym = this.getLhsOperandSym();
        return lhsSym != null && lhsSym.flag_maybePackage();
    }

    public String getQualifiedName() {
        if (!this.isQualifiedName()) {
            throw new UnsupportedOperationException("Not a qualified name");
        }
        String name = this.getName();
        Expr lhs = this.getLhsOperandSym();
        try {
            if (lhs.symKind == 57) {
                SimpleNameExpr e = (SimpleNameExpr)lhs;
                return e.getName() + '.' + name;
            }
            DotExpr e = (DotExpr)lhs;
            return e.getQualifiedName() + '.' + name;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("Not a qualified name");
        }
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected boolean isValidChild(Sym child, byte filter) {
        switch (child.symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChild(child, filter);
    }

    @Override
    protected void linkChildTrigger(Sym child, byte filter) {
        super.linkChildTrigger(child, filter);
        boolean addMaybePackage = false;
        switch (child.symKind) {
            case 57: {
                addMaybePackage = true;
                break;
            }
            case 49: {
                DotExpr dotExpr = (DotExpr)child;
                addMaybePackage = dotExpr.isQualifiedName();
            }
        }
        if (!addMaybePackage) {
            return;
        }
        Expr childExpr = (Expr)child;
        if (!childExpr.flag_maybePackage()) {
            childExpr.symFlags = (byte)(childExpr.symFlags | 0x40);
            Sym sym = this;
            Sym parentSym = sym.getParentSym();
            while (parentSym != null && parentSym.symKind == 49) {
                sym.symFlags = (byte)(sym.symFlags | 0x40);
                sym = parentSym;
                parentSym = sym.getParentSym();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym child, byte filter) {
        super.unlinkChildTrigger(child, filter);
        switch (child.symKind) {
            case 49: 
            case 57: {
                break;
            }
            default: {
                return;
            }
        }
        Expr childExpr = (Expr)child;
        if (childExpr.flag_maybePackage()) {
            childExpr.symFlags = (byte)(childExpr.symFlags & 0xFFFFFFBF);
            Sym sym = this;
            Sym parentSym = sym.getParentSym();
            while (parentSym != null && parentSym.symKind == 49) {
                sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFBF);
                sym = parentSym;
                parentSym = sym.getParentSym();
            }
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

