/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public class TypeSym
extends ObjectSym
implements SourceTypeReference {
    public short typeBaseDimension = 0;
    public short typeXtraDimension = 0;
    public short typeToken;
    public JavaType typeResolved;

    @Override
    public boolean isPrimitive() {
        return 96 <= this.typeToken && this.typeToken < 146;
    }

    @Override
    public boolean isArray() {
        return this.getArrayDimension() > 0;
    }

    @Override
    public SourceTypeReference getQualifyingType() {
        return this.getTypeSym();
    }

    @Override
    public List getTypeArguments() {
        return this.getChildren((byte)25);
    }

    @Override
    public int getArrayDimension() {
        if (!this.isVarargs()) {
            return this.typeBaseDimension + this.typeXtraDimension;
        }
        return this.typeBaseDimension + this.typeXtraDimension + 1;
    }

    @Override
    public String getText() {
        String text = super.getText();
        for (int i = 0; i < this.typeXtraDimension; ++i) {
            text = text + "[]";
        }
        if (this.isVarargs()) {
            text = text + "...";
        }
        return text;
    }

    @Override
    public JavaElement getCompiledObject() {
        return this.getResolvedType();
    }

    @Override
    public JavaType getResolvedType() {
        if (this.typeResolved == null) {
            this.resolve();
        }
        return this.typeResolved;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.typeResolved = null;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 20: 
            case 25: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        super.linkSelfTrigger(parent, filter);
        this.symAccess = (char)(this.symAccess & 0xFFFFEFFF);
    }

    @Override
    protected void unlinkSelfTrigger(TreeSym parent, byte filter) {
        this.symKind = (byte)27;
        super.unlinkSelfTrigger(parent, filter);
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        if (this.typeResolved == null && !this.isProcessed()) {
            this.typeResolved = compiler.resolve(this);
        }
        return this.typeResolved;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        JavaElement result = super.compileImpl(compiler);
        if (result != null) {
            compiler.compile(this);
        }
        return result;
    }

    private String qualifySelfImpl() {
        TypeSym nestedType;
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null && !resolvedType.isPrimitive() && resolvedType instanceof JavaClass && resolvedType.isExported() && (nestedType = this.getTypeSym()) == null) {
            JavaClass javaClass = (JavaClass)resolvedType;
            String qualifiedName = javaClass.getRawName();
            int firstBracket = qualifiedName.indexOf(91);
            if (firstBracket >= 0) {
                qualifiedName = qualifiedName.substring(0, firstBracket);
            }
            if (TypeSym.isValidQualifiedName(qualifiedName) && !this.getName().equals(qualifiedName)) {
                return qualifiedName;
            }
        }
        return null;
    }

    @Override
    public final void qualifySelf() {
        NameSym nameSym;
        String qualifiedName = this.qualifySelfImpl();
        if (qualifiedName != null && (nameSym = this.getNameSym()) != null) {
            nameSym.setValue(qualifiedName);
            this.symFormat = (char)(this.symFormat | 0x20);
        }
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        NameSym nameSym;
        String qualifiedName;
        TypeSym sym = (TypeSym)super.cloneSelf(targetFile);
        sym.typeBaseDimension = this.typeBaseDimension;
        sym.typeXtraDimension = this.typeXtraDimension;
        sym.typeToken = this.typeToken;
        SourcePreferences preferences = this.symFile.getPreferences();
        if (preferences.getBoolean(67) && (qualifiedName = this.qualifySelfImpl()) != null && (nameSym = sym.getNameSym()) != null) {
            nameSym.nameString = qualifiedName;
        }
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        this.print(out);
    }
}

