/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;

public class TypeArgumentSym
extends ObjectSym
implements SourceTypeArgument {
    public byte argBound;
    public JavaType argResolved;

    @Override
    public int getBound() {
        return this.argBound;
    }

    @Override
    public JavaElement getCompiledObject() {
        return this.getResolvedType();
    }

    @Override
    public JavaType getResolvedType() {
        if (this.argResolved == null) {
            this.resolve();
        }
        return this.argResolved;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.argResolved = null;
    }

    @Override
    public String printCompiledInfo() {
        JavaType resolvedType = this.getResolvedType();
        if (resolvedType != null) {
            return "refers to " + resolvedType.getDescriptor();
        }
        return "refers to <unknown>";
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 27: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        if (this.argResolved == null && !this.isProcessed()) {
            this.argResolved = compiler.resolve(this);
        }
        return this.argResolved;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        TypeArgumentSym sym = (TypeArgumentSym)super.cloneSelf(targetFile);
        sym.argBound = this.argBound;
        return sym;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void print(PrintWriter out, int ignored) {
        switch (this.argBound) {
            default: {
                out.print('?');
                break;
            }
            case 1: {
                out.print("? extends ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 2: {
                out.print("? super ");
                TypeArgumentSym.print(this.getTypeSym(), out);
                break;
            }
            case 0: {
                TypeArgumentSym.print(this.getTypeSym(), out);
            }
        }
    }
}

