/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.scanner.TokenArray;

public final class SymIndex
extends TreeSym {
    public Sym getSymAt(int offset) {
        int index = this.getIndexFor(offset);
        if (index < 0) {
            return null;
        }
        Sym symAt = this.treeChildren[index];
        switch (symAt.symKind) {
            case 69: 
            case 70: {
                symAt = symAt.symParent;
            }
        }
        if (symAt.symKind == 63) {
            symAt = this.getChildSymAt(symAt, offset);
        }
        while (symAt.testSymFlag((byte)2)) {
            symAt = symAt.symParent;
        }
        return symAt;
    }

    SymIndex(FileSym fileSym) {
        this.symKind = (byte)75;
        this.symFile = fileSym;
        this.buildSelf();
        if (this.treeChildren.length == 0) {
            SymIndex.panic("Empty index");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSelf() {
        FileSym fileSym = this.symFile;
        synchronized (fileSym) {
            TokenArray tokens = this.symFile.tokens;
            if (tokens == null) {
                SymIndex.panic("No token array");
            }
            int count = tokens.tokenCount;
            Sym[] index = new Sym[count];
            int end = this.symFile.indexSelf(index, 0, tokens);
            while (end < count) {
                index[end++] = this;
            }
            this.treeChildren = index;
        }
    }

    private int getIndexFor(int offset) {
        if (offset < 0) {
            return -1;
        }
        TokenArray tokens = this.symFile.tokens;
        int i = tokens.search(offset);
        if (i < 0) {
            return -(i + 1);
        }
        if (i == 0) {
            return 0;
        }
        if (offset == tokens.tokenStarts[i]) {
            if (offset != tokens.tokenEnds[i - 1]) {
                return i;
            }
            Sym nextSym = this.treeChildren[i];
            Sym prevSym = this.treeChildren[i - 1];
            if (nextSym == prevSym) {
                return i;
            }
            if (nextSym.symStart < i) {
                return i - 1;
            }
            if (i <= prevSym.symEnd) {
                return i;
            }
            return i;
        }
        if (this.treeChildren[i].symStart <= offset) {
            return i;
        }
        if (offset <= this.treeChildren[i - 1].symEnd) {
            return i - 1;
        }
        return -1;
    }

    private Sym getChildSymAt(Sym parent, int offset) {
        if (parent instanceof TreeSym) {
            Sym child;
            int start;
            TreeSym treeSym = (TreeSym)parent;
            int count = treeSym.treeChildren.length;
            for (int i = 0; i < count && offset >= (start = (child = treeSym.treeChildren[i]).getStartOffset()); ++i) {
                Sym nextChild;
                int nextStart;
                int end = child.getEndOffset();
                if (offset < end) {
                    return this.getChildSymAt(child, offset);
                }
                if (offset != end) continue;
                if (i + 1 < count && (nextStart = (nextChild = treeSym.treeChildren[i + 1]).getStartOffset()) == offset) {
                    return this.getChildSymAt(nextChild, offset);
                }
                return this.getChildSymAt(child, offset);
            }
        }
        return parent;
    }
}

