/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.Collection;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

public class FieldSym
extends VariableSym
implements SourceFieldVariable {
    @Override
    public int getElementKind() {
        return 5;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public final JavaClass getOwningClass() {
        return this.getOwningClassSym();
    }

    @Override
    public final DocCommentSym getJavadocSym() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getJavadocSym();
        }
        return null;
    }

    @Override
    public final void setJavadocSym(DocCommentSym javadoc) {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            if (parent.getVariables().size() > 1) {
                this.separateSelf();
            }
            parent.setJavadocSym(javadoc);
        } else {
            FieldSym.unsupported("Can't set doc comment on an unattached field variable");
        }
    }

    @Override
    public final Collection getDeclaredAnnotations() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getDeclaredAnnotations();
        }
        return null;
    }

    @Override
    public List getSourceAnnotations() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getSourceAnnotations();
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null && parent.isDeprecated()) {
            return true;
        }
        return super.isDeprecated();
    }

    @Override
    public SourceExpression getInitializer() {
        return this.getExpression();
    }

    @Override
    public Object getConstantValue() {
        if (!this.isStatic()) {
            return null;
        }
        return super.getConstantValue();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaField) {
            return CommonUtilities.equals(this, (JavaField)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    protected boolean isValidAccess(char access) {
        ClassSym classSym = this.getOwningClassSym();
        int allowed = classSym != null && classSym.isInterface() ? 25 : 4319;
        return super.isValidAccess((char)(access & ~allowed));
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private FieldDeclSym getFieldDeclParent() {
        Sym parent = this.getParentSym();
        if (parent != null && parent.symKind == 9) {
            return (FieldDeclSym)parent;
        }
        return null;
    }
}

