/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.javatools.parser.java.v2.common.QuickHasType;
import oracle.javatools.parser.java.v2.common.QuickLocalVariable;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.write.SourceComparator;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

public final class ClassBodySym
extends TreeSym
implements SourceClassBody {
    public QuickMethod bodyDefaultConstructor;
    public List bodyImplicitMethods;

    @Override
    public List getSourceMembers() {
        return this.getChildren((byte)79);
    }

    @Override
    public Collection getSourceMemberVariables() {
        return this.getSyms((byte)90);
    }

    public SourceMemberVariable getSourceMemberVariable(String name) {
        for (EnumConstantSym thing : this.getSourceEnumConstants()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        for (FieldSym fieldSym : this.getSourceFieldVariables()) {
            if (!name.equals(fieldSym.getName())) continue;
            return fieldSym;
        }
        return null;
    }

    @Override
    public List getSourceEnumConstants() {
        return this.getChildren((byte)7);
    }

    @Override
    public List getSourceFieldDeclarations() {
        return this.getChildren((byte)9);
    }

    @Override
    public Collection getSourceFieldVariables() {
        return this.getSyms((byte)91);
    }

    public SourceFieldVariable getSourceFieldVariable(String name) {
        for (FieldSym fieldSym : this.getSourceFieldVariables()) {
            if (!name.equals(fieldSym.getName())) continue;
            return fieldSym;
        }
        return null;
    }

    @Override
    public List getSourceMethods() {
        return this.getChildren((byte)19);
    }

    public Collection getSourceMethods(String name) {
        ArrayList<MethodSym> list = new ArrayList<MethodSym>();
        for (MethodSym sym : this.getSourceMethods()) {
            if (!name.equals(sym.getName())) continue;
            list.add(sym);
        }
        return list;
    }

    @Override
    public List getSourceConstructors() {
        return this.getChildren((byte)6);
    }

    @Override
    public List getSourceClasses() {
        return this.getChildren((byte)3);
    }

    public SourceClass getSourceClass(String name) {
        for (ClassSym thing : this.getSourceClasses()) {
            if (!name.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    @Override
    public List getSourceInitializers() {
        return this.getChildren((byte)5);
    }

    protected Collection getDeclaredConstructors() {
        if (this.bodyDefaultConstructor == null) {
            return this.getObjects((byte)6);
        }
        Sym constructor = this.getChild((byte)6);
        if (constructor == null) {
            return Arrays.asList(this.bodyDefaultConstructor);
        }
        return kEmptyList;
    }

    protected Collection getDeclaredMethods() {
        List methods = this.getObjects((byte)19);
        if (this.bodyImplicitMethods == null) {
            return methods;
        }
        ArrayList list = new ArrayList();
        list.addAll(methods);
        list.addAll(this.bodyImplicitMethods);
        return list;
    }

    protected Collection getDeclaredClasses() {
        return this.getObjects((byte)3);
    }

    @Override
    protected boolean isValidChild(Sym target, byte argument) {
        switch (target.symKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return super.isValidChild(target, argument);
    }

    @Override
    protected int getTargetIndex(Sym target, byte filter) {
        int i;
        if (target.is((byte)80) && (i = this.indexOf((byte)80)) != -1) {
            int next;
            Sym firstSym;
            SourcePreferences p = this.symFile.getPreferences();
            Comparator comparator = p != null ? p.getMemberComparator() : SourceComparator.memberComparator();
            if (comparator.compare(target, firstSym = this.getNthChild(i)) < 0) {
                return i;
            }
            while ((next = this.indexOf((byte)80, i + 1)) != -1) {
                Sym sym = this.getNthChild(next);
                if (comparator.compare(target, sym) < 0) {
                    return i + 1;
                }
                i = next;
            }
        }
        return super.getTargetIndex(target, filter);
    }

    @Override
    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        this.buildDefaultConstructor();
        super.linkSelfTrigger(parent, filter);
    }

    @Override
    protected void unlinkSelfTrigger(TreeSym parent, byte filter) {
        this.bodyDefaultConstructor = null;
        this.bodyImplicitMethods = null;
        super.unlinkSelfTrigger(parent, filter);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        if (this.bodyDefaultConstructor != null && added.symKind == 6) {
            this.bodyDefaultConstructor = null;
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        if (removed.symKind == 6) {
            this.buildSelf();
        }
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
        this.buildDefaultConstructor();
    }

    void buildDefaultConstructor() {
        ClassSym classSym;
        Sym parentSym;
        this.bodyDefaultConstructor = null;
        if (this.count((byte)6) == 0 && (parentSym = this.getParentSym()) != null && parentSym.symKind == 3 && !(classSym = (ClassSym)this.symParent).isInterface()) {
            char access;
            if (classSym.isEnum()) {
                access = '\u0002';
            } else {
                access = classSym.symAccess;
                access = (char)(access & 7);
            }
            access = (char)(access | 0x1000);
            List<JavaVariable> parameters = null;
            JavaType outerClass = ClassBodySym.getOuterClassOfNonstaticInner(classSym);
            if (outerClass != null) {
                QuickLocalVariable parameter = QuickLocalVariable.createLocalVariable(outerClass, "this$0");
                parameters = Arrays.asList(parameter);
            }
            this.bodyDefaultConstructor = QuickMethod.createMethod(classSym, access, null, "<init>", parameters, null);
        }
    }

    protected final void buildEnumMethods(ClassSym owningSym) {
        this.bodyImplicitMethods = null;
        if (!owningSym.isEnum()) {
            return;
        }
        int access = 4105;
        JavaType arrayOfOwning = ClassBodySym.createArrayType(this.symFile.getProvider(), owningSym, 1);
        QuickMethod valuesMethod = QuickMethod.createMethod(owningSym, '\u1009', arrayOfOwning, "values", null, null);
        ArrayList<QuickLocalVariable> parameterList = new ArrayList<QuickLocalVariable>();
        QuickHasType stringType = QuickHasType.createHasTypeByVMName(this.symFile, "java/lang/String");
        QuickLocalVariable nameParameter = QuickLocalVariable.createLocalVariable(stringType, "name");
        parameterList.add(nameParameter);
        QuickMethod valueOfMethod = QuickMethod.createMethod(owningSym, '\u1009', owningSym, "valueOf", parameterList, null);
        this.bodyImplicitMethods = Arrays.asList(valuesMethod, valueOfMethod);
    }

    @Override
    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

