/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.util.IdentityHashMap;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.BlanklineSym;
import oracle.javatools.parser.java.v2.internal.symbol.CommentSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.SqljSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.WhitespaceSym;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.write.SourcePreferences;

abstract class FormatLayer1
extends FormatUtilities {
    private short stackTop = 0;
    private int enterDepth = 0;
    private FormatInfo[] stack = new FormatInfo[]{new FormatInfo(), new FormatInfo()};
    private short lastToken = 0;
    TokenArray tokens;
    SourcePreferences preferences;
    Emitter emitter;
    private IdentityHashMap handledWhitespace;
    private int newlinesPending = 0;
    private int newlinesEmitted = 0;
    private int blanklineSyms = 0;
    private boolean flag_space = false;
    private boolean flag_init = false;
    boolean flag_justindent = false;
    boolean flag_docindent = false;
    boolean flag_lessindentonce = false;
    private int indentNumSpaces = 0;
    private boolean wrapAlign = true;
    private int alignmentMark_height = -1;
    private int markBoundary_height = -1;

    FormatLayer1() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Sym s) {
        if (this.flag_init) {
            FormatLayer1.panic("Traversal already in progress");
        }
        this.stackTop = 0;
        this.enterDepth = 0;
        this.lastToken = 0;
        this.newlinesPending = 0;
        this.newlinesEmitted = 1;
        this.handledWhitespace = new IdentityHashMap(this.tokens.tokenCount);
        this.flag_justindent = false;
        this.flag_docindent = false;
        this.flag_lessindentonce = false;
        this.alignmentMark_height = -1;
        this.markBoundary_height = -1;
        this.indentNumSpaces = this.preferences.getInt(0);
        if (this.indentNumSpaces < 0) {
            this.indentNumSpaces = 0;
        }
        try {
            this.emitter.init(s);
        }
        finally {
            this.flag_init = true;
        }
        this.wrapAlign = this.preferences.getBoolean(51);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fini(Sym s) {
        if (!this.flag_init) {
            FormatLayer1.panic("No traversal in progress");
        }
        this.flush();
        try {
            this.emitter.fini(s);
        }
        finally {
            this.flag_init = false;
        }
    }

    protected final int newlines() {
        return this.newlinesPending + this.newlinesEmitted;
    }

    public final void print(Sym sym) {
        FormatLayer1.panic();
    }

    final void print(TreeSym sym) {
        for (Sym child : sym.treeChildren) {
            this.handle(child);
        }
    }

    public final void print(NameSym sym) {
        this.print(sym.getText());
    }

    public final void print(SqljSym sym) {
        this.print(sym.getText());
        this.ensureNewlines(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(CommentSym sym) {
        if (sym.flag_lineStart()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
        int savedUnflushed = this.newlinesPending;
        try {
            this.newlinesPending = 0;
            if (this.newlines() == 0 && !this.flag_justindent) {
                this.flag_space = true;
            }
            this.print(sym.getText());
        }
        finally {
            this.newlinesPending = savedUnflushed;
        }
        if (sym.tokenValue == 24 || sym.flag_lineEnd()) {
            this.ensureNewlines(1);
            this.flushNewlines(1);
        }
    }

    public final void print(BlanklineSym sym) {
        int blanklinePreserveCount = this.preferences.getInt(7);
        ++this.blanklineSyms;
        if (this.blanklineSyms > blanklinePreserveCount) {
            this.blanklineSyms = blanklinePreserveCount;
        }
        if (this.blanklineSyms > 0) {
            this.ensureNewlines(this.blanklineSyms + 1);
            this.flushNewlines(this.blanklineSyms + 1);
        }
    }

    public final void enter(Sym s) {
        TreeSym parentSym;
        int previousIndex;
        if (this.enterDepth > 0 && (previousIndex = s.symSiblingIndex - 1) >= 0 && (parentSym = (TreeSym)s.symParent) != null) {
            Sym sibling;
            if (parentSym.treeChildren.length <= previousIndex) {
                FormatLayer1.panic();
            }
            if ((sibling = parentSym.treeChildren[previousIndex]).is((byte)88)) {
                this.handle(sibling);
            }
        }
        if (this.flag_docindent) {
            this.checkIndent();
        }
        if (s.symKind != 11) {
            ++this.enterDepth;
        }
        if ((s.symFormat & 4) != 0) {
            this.flush();
        }
        this.emitter.enter(s);
    }

    public final void leave(Sym s) {
        if (this.enterDepth > 0 && s instanceof TreeSym) {
            TreeSym ts = (TreeSym)s;
            int count = ts.treeChildren.length;
            if (count > 0) {
                Sym last = ts.treeChildren[count - 1];
                if (last.symKind == 69) {
                    this.handle(last);
                }
            }
        }
        int symEnd = s.getEndIndex();
        if (s.symKind != 11) {
            --this.enterDepth;
        }
        this.emitter.leave(s);
    }

    private void handleImpl(Sym s) {
        if (s instanceof WhitespaceSym) {
            if (this.handledWhitespace.containsKey(s)) {
                return;
            }
            this.handledWhitespace.put(s, null);
        }
        s.print((FormatDriver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handle(Sym s) {
        if (s == null) {
            return;
        }
        if (s.isSynthetic()) {
            return;
        }
        int id = this.push();
        try {
            this.handleImpl(s);
        }
        finally {
            this.pop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handle(Sym s, byte decoration) {
        if (s == null) {
            return;
        }
        int id = this.push(decoration);
        try {
            switch (decoration) {
                case 1: {
                    if (s.symKind == 29) {
                        boolean newlineBlockBraces = this.preferences.getBoolean(23);
                        if (!newlineBlockBraces) break;
                        boolean indentControlBlocks = this.preferences.getBoolean(5);
                        if (indentControlBlocks) {
                            this.indent(1);
                        }
                        this.ensureNewlines(1);
                        break;
                    }
                    this.indent(1);
                    this.println();
                    break;
                }
                case 3: {
                    this.indent(1);
                }
            }
            this.handleImpl(s);
        }
        finally {
            this.pop(id);
        }
    }

    final void handleComment(Sym s) {
        TreeSym parentSym;
        int previousIndex = s.symSiblingIndex - 1;
        if (previousIndex >= 0 && (parentSym = (TreeSym)s.symParent) != null) {
            Sym sibling;
            if (parentSym.treeChildren.length <= previousIndex) {
                FormatLayer1.panic();
            }
            if ((sibling = parentSym.treeChildren[previousIndex]).is((byte)88)) {
                this.handle(sibling);
            }
        }
    }

    final void indent(int increment) {
        int newIndent = this.stack[this.stackTop].indent + increment * this.indentNumSpaces;
        if (newIndent < 0) {
            newIndent = 0;
        } else if (newIndent > 127) {
            newIndent = 127;
        }
        this.stack[this.stackTop].indent = (byte)newIndent;
    }

    final int getIndent() {
        int alignment;
        if (this.stack[this.stackTop].alignmentStamp == this.emitter.getColumnStamp() && (alignment = this.stack[this.stackTop].alignment) > 0) {
            return alignment;
        }
        byte indent = this.stack[this.stackTop].indent;
        if (!this.flag_lessindentonce) {
            return indent;
        }
        return indent - this.indentNumSpaces;
    }

    final int push() {
        return this.push((byte)0);
    }

    private int push(byte decoration) {
        if (this.stack.length == this.stackTop + 1) {
            FormatInfo[] newStack = new FormatInfo[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        short s = this.stackTop;
        this.stackTop = (short)(s + 1);
        short height = s;
        if (this.stack[this.stackTop] == null) {
            this.stack[this.stackTop] = new FormatInfo();
        }
        FormatInfo info = this.stack[this.stackTop];
        info.decoration = decoration;
        info.indent = this.stack[height].indent;
        info.alignment = this.stack[height].alignment;
        info.alignmentStamp = this.stack[height].alignmentStamp;
        info.saved_alignmentMark_height = -1;
        return height;
    }

    final void pop(int height) {
        if (height < 0 || this.stackTop < height) {
            FormatLayer1.panic();
        }
        this.stackTop = (short)height;
        if (this.stackTop < 0) {
            FormatLayer1.panic();
        }
    }

    final void markWrapAlignment() {
        if (!this.wrapAlign) {
            return;
        }
        if (0 <= this.alignmentMark_height && this.alignmentMark_height < this.stackTop) {
            this.stack[this.stackTop].saved_alignmentMark_height = this.alignmentMark_height;
        }
        this.alignmentMark_height = this.stackTop;
    }

    final void markWrapBoundary(int wrap) {
        int tri = this.preferences.getInt(wrap);
        if (tri == 0) {
            return;
        }
        if (tri != 2) {
            this.markBoundary_height = this.stackTop;
        } else {
            this.emitter.forceLineWrapping();
            this.flag_justindent = true;
        }
    }

    final void println(short tk) {
        this.print(tk);
        this.println();
    }

    final void print(short tk, char ws) {
        this.print(tk);
        this.print(ws);
    }

    private final void checkWrapBoundary() {
        if (this.markBoundary_height >= 0) {
            boolean lineStart;
            boolean bl = lineStart = this.newlines() > 0 || this.flag_justindent;
            if (!lineStart) {
                this.emitter.markWrapBoundary(this.markBoundary_height);
            }
            this.markBoundary_height = -1;
        }
    }

    private final void checkWrapAlignment() {
        if (this.alignmentMark_height >= 0) {
            int column = this.emitter.getColumn();
            int i = this.stackTop;
            while (this.alignmentMark_height >= 0) {
                byte before = this.stack[this.alignmentMark_height].indent;
                int delta = column - before;
                while (i >= this.alignmentMark_height) {
                    this.stack[i].alignment = this.stack[i].indent + delta;
                    this.stack[i].alignmentStamp = this.emitter.getColumnStamp();
                    --i;
                }
                this.stack[this.alignmentMark_height].alignment = column;
                this.stack[this.alignmentMark_height].alignmentStamp = this.emitter.getColumnStamp();
                int nextHeight = this.stack[this.alignmentMark_height].saved_alignmentMark_height;
                if (this.alignmentMark_height <= nextHeight) {
                    FormatLayer1.panic();
                }
                this.alignmentMark_height = nextHeight;
            }
            this.alignmentMark_height = -1;
        }
    }

    final void checkIndent() {
        this.flush();
        if (this.newlines() > 0) {
            this.emitter.emitIndent(this.getIndent());
            this.newlinesEmitted = 0;
            this.newlinesPending = 0;
            this.blanklineSyms = 0;
            this.flag_justindent = true;
        }
    }

    private final void checkSpace(int tk) {
        if (this.flag_justindent) {
            return;
        }
        if (this.newlines() == 0 && !this.flag_space) {
            boolean space = false;
            if (32 <= this.lastToken && this.lastToken < 81) {
                switch (this.lastToken) {
                    case 39: {
                        space = this.preferences.getBoolean(34);
                        break;
                    }
                    case 75: {
                        space = this.preferences.getBoolean(36);
                        break;
                    }
                    case 55: {
                        if (tk == 72) break;
                        space = this.preferences.getBoolean(47);
                        break;
                    }
                    case 50: {
                        if (tk == 71) break;
                        space = this.preferences.getBoolean(48);
                        break;
                    }
                    case 69: {
                        break;
                    }
                    case 38: {
                        space = this.preferences.getBoolean(40);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(this.lastToken) == 0) break;
                        space = this.preferences.getBoolean(45);
                    }
                }
            }
            if (!space) {
                switch (tk) {
                    case 39: {
                        space = this.preferences.getBoolean(33);
                        break;
                    }
                    case 75: {
                        space = this.preferences.getBoolean(35);
                        break;
                    }
                    case 72: {
                        if (this.lastToken == 55) break;
                        space = this.preferences.getBoolean(47);
                        break;
                    }
                    case 71: {
                        if (this.lastToken == 50) break;
                        space = this.preferences.getBoolean(48);
                        break;
                    }
                    case 49: {
                        space = this.preferences.getBoolean(49);
                        break;
                    }
                    default: {
                        if (FormatLayer1.asg_op(tk) == 0) break;
                        space = this.preferences.getBoolean(45);
                    }
                }
            }
            if (this.lastToken == 119 || tk == 119) {
                space = true;
            }
            this.flag_space = space;
        }
        if (this.flag_space) {
            this.emitter.emit(' ');
        }
        this.flag_space = false;
    }

    final void print(String s) {
        if (s.length() == 0) {
            return;
        }
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(4);
        this.checkWrapAlignment();
        this.emitter.emit(s);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = (short)4;
    }

    final void print(short tk) {
        this.checkIndent();
        this.checkWrapBoundary();
        this.checkSpace(tk);
        this.checkWrapAlignment();
        this.emitter.emit(tk);
        this.flag_lessindentonce = false;
        this.flag_justindent = false;
        this.lastToken = tk;
    }

    final void print(char ws) {
        switch (ws) {
            case ' ': {
                this.flag_space = true;
                break;
            }
            case '\n': {
                this.println();
                break;
            }
            default: {
                this.checkIndent();
                this.emitter.emit(ws);
                this.flag_justindent = false;
            }
        }
    }

    final void println() {
        this.flag_space = false;
        ++this.newlinesPending;
        this.lastToken = (short)5;
    }

    final void ensureNewlines(int count) {
        int newlines = this.newlines();
        if (count <= newlines) {
            return;
        }
        this.flag_space = false;
        this.newlinesPending += count - newlines;
        this.lastToken = (short)5;
    }

    private void flushNewlines(int count) {
        if (this.newlinesEmitted >= count) {
            return;
        }
        int diff = count - this.newlinesEmitted;
        if (this.newlinesPending < diff) {
            FormatLayer1.panic("Insufficient newlines");
        }
        for (int i = 0; i < diff; ++i) {
            this.emitter.emit('\n');
        }
        this.newlinesEmitted += diff;
        this.newlinesPending -= diff;
        this.alignmentMark_height = -1;
    }

    private void flush() {
        if (this.newlinesPending > 0) {
            for (int i = 0; i < this.newlinesPending; ++i) {
                this.emitter.emit('\n');
            }
            this.newlinesEmitted += this.newlinesPending;
            this.newlinesPending = 0;
            this.alignmentMark_height = -1;
        }
    }

    protected final void printTypeArgumentsStart() {
        if (this.flag_space) {
            this.emitter.emit(' ');
            this.flag_space = false;
        }
        this.print('<');
    }

    private static class FormatInfo {
        private int decoration = 0;
        private byte indent = 0;
        private int alignment = 0;
        private int alignmentStamp = 0;
        private int saved_alignmentMark_height = -1;

        private FormatInfo() {
        }
    }
}

