/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;

abstract class BufferedEmitter
extends Emitter {
    private final StringWriter writer = new StringWriter();
    private final PrintWriter printer = new PrintWriter(this.writer);
    final StringBuffer buffer = this.writer.getBuffer();
    protected byte tabSize = (byte)4;
    protected boolean replaceWithTabs = false;

    BufferedEmitter() {
    }

    @Override
    public TextBuffer getOutputBuffer() {
        TextBuffer textBuffer = TextBufferFactory.createArrayTextBuffer();
        String text = this.getBuffer().toString();
        textBuffer.insert(0, text.toCharArray());
        return textBuffer;
    }

    final StringBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final String toString() {
        return this.getBuffer().toString();
    }

    @Override
    void init(Sym s) {
        this.buffer.setLength(0);
        int size = this.formatter.preferences.getInt(2);
        this.tabSize = BufferedEmitter.int2unsignedByte(size);
        this.replaceWithTabs = this.formatter.preferences.getBoolean(1);
    }

    @Override
    void fini(Sym s) {
        int length = this.buffer.length();
        for (int i = length - 1; i >= 0; --i) {
            char ch = this.buffer.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            while (i >= 1 && this.buffer.charAt(i - 1) == ' ') {
                this.buffer.deleteCharAt(--i);
            }
        }
    }

    private void emitImpl(String s) {
        this.printer.print(s);
    }

    final void emitIndentImpl(int spaces, boolean docindent) {
        if (this.replaceWithTabs && this.tabSize > 0) {
            while (spaces >= this.tabSize) {
                this.printer.print('\t');
                spaces -= this.tabSize;
            }
        }
        for (int i = 0; i < spaces; ++i) {
            this.printer.print(' ');
        }
        if (docindent) {
            this.printer.print(" * ");
        }
    }

    @Override
    abstract void emitIndent(int var1);

    @Override
    void emit(String s) {
        this.emitImpl(s);
    }

    @Override
    void emit(short tk) {
        this.emitImpl(BufferedEmitter.tk2text(tk));
    }

    @Override
    void emit(char ch) {
        if (ch == '\n') {
            this.printer.println();
        } else {
            this.printer.print(ch);
        }
    }
}

