/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer2;
import oracle.javatools.parser.java.v2.internal.compiler.InputImpl;
import oracle.javatools.parser.java.v2.internal.compiler.OutputImpl;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.MethodCallExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.SwitchStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;

abstract class CompilerLayer3a
extends CompilerLayer2
implements CallerContext.Constants {
    CompilerLayer3a() {
    }

    protected final JavaHasType resolveName(TreeSym hasName, JavaHasType primary, boolean ambiguous) {
        String name = hasName.getName();
        if (name.length() == 0) {
            return null;
        }
        return this.resolveName(hasName, primary, name, ambiguous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaHasType resolveName(Sym cookie, JavaHasType primary, String name, boolean ambiguous) {
        CompilerContext oldContext = this.context;
        try {
            JavaHasType javaHasType;
            JavaHasType result;
            this.context = this.newContext(cookie);
            if (primary == null) {
                JavaHasType found = this.processSimpleName(name, ambiguous, true);
                if (found == null && !cookie.testSymFlag((byte)64)) {
                    this.error(cookie, (short)56, name);
                    if (this.flag_forgiving) {
                        found = this.processSimpleName(name, ambiguous, false);
                    }
                }
                result = found;
            } else {
                JavaType primaryType = this.processLhs(primary);
                result = this.processSimpleSelector(name, primaryType, ambiguous);
                if (result == null && !cookie.testSymFlag((byte)64)) {
                    this.error(cookie, (short)53, name, primaryType);
                }
            }
            if (result == null) {
                javaHasType = null;
                return javaHasType;
            }
            this.recordUsage(cookie, result);
            if (primary != null) {
                this.context.cleanScope();
                if (primary instanceof JavaType) {
                    this.context.flag_instance = false;
                }
            }
            if (this.flag_forgiving || this.context.allowAccess(result, primary)) {
                javaHasType = result;
                return javaHasType;
            }
            javaHasType = (JavaType)this.error(cookie, (short)57, result);
            return javaHasType;
        }
        finally {
            this.context = oldContext;
        }
    }

    protected final JavaMethod resolveMethodCall(MethodCallExpr e, JavaHasType primary, JavaType[] typeArguments, JavaType[] arguments, boolean isConstructor) {
        String name = isConstructor ? "<init>" : e.getName();
        if (name.length() == 0) {
            return (JavaMethod)this.error(e, (short)50);
        }
        NameSym nameSym = e.getNameSym();
        Sym cookie = e;
        if (nameSym != null) {
            cookie = nameSym;
        }
        return this.resolveMethodCall(cookie, name, primary, typeArguments, arguments);
    }

    protected final JavaMethod resolveMethodCall(ClassCreatorExpr e, JavaHasType primary, JavaType[] typeArguments, JavaType[] arguments) {
        TypeSym typeSym = e.getTypeSym();
        TreeSym cookie = e;
        if (typeSym != null) {
            cookie = typeSym;
        }
        return this.resolveMethodCall(cookie, "<init>", primary, typeArguments, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaMethod resolveMethodCall(Sym cookie, String name, JavaHasType primary, JavaType[] typeArguments, JavaType[] arguments) {
        CompilerContext savedContext = this.context;
        try {
            JavaMethod result;
            this.context = this.newContext(cookie);
            boolean hasNullArgument = false;
            int argumentCount = arguments.length;
            for (int i = 0; i < argumentCount; ++i) {
                if (arguments[i] != null) continue;
                hasNullArgument = true;
            }
            if (hasNullArgument) {
                this.context.suppressErrors = true;
            }
            if ((result = primary == null ? this.processSimpleMethodCall(name, arguments, true) : this.processSelectorMethodCall(name, primary, typeArguments, arguments, true)) != null) {
                this.recordUsage(cookie, result);
                JavaMethod i = result;
                return i;
            }
            JavaType scopeClass = primary != null ? this.processLhs(primary) : cookie.getOwningClassSym();
            this.error(cookie, (short)54, name, arguments, scopeClass);
            if (!this.flag_forgiving) {
                JavaMethod javaMethod = null;
                return javaMethod;
            }
            result = primary == null ? this.processSimpleMethodCall(name, arguments, false) : this.processSelectorMethodCall(name, primary, typeArguments, arguments, false);
            JavaMethod javaMethod = result;
            return javaMethod;
        }
        finally {
            this.context = savedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void resolveExceptions(Expr e, JavaMethod method) {
        CompilerContext savedContext = this.context;
        NameSym nameSym = e.getNameSym();
        Sym cookie = e;
        if (nameSym != null) {
            cookie = nameSym;
        }
        try {
            this.context = this.newContext(cookie);
            this.processExceptions(e, method);
        }
        finally {
            this.context = savedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkException(Sym cookie, JavaType thrown) {
        if (thrown == null) {
            return;
        }
        JavaClass javaLangThrowable = this.getPreloadedClass((byte)7);
        if (thrown.isSubtypeOf(javaLangThrowable)) {
            CompilerContext savedContext = this.context;
            try {
                this.context = this.newContext(cookie);
                this.processException(thrown);
            }
            finally {
                this.context = savedContext;
            }
        } else {
            this.error(cookie, (short)61, thrown);
        }
    }

    protected final ClassSym resolveEnclosingScope(Sym inputScope, JavaType target) {
        boolean firstClass = true;
        CompilerContext tmpContext = this.newContext(inputScope);
        Sym scope = tmpContext.cleanScope();
        while (scope != null) {
            ClassSym classSym;
            if (scope.symKind == 3 && (classSym = (ClassSym)scope).isSubtypeOf(target)) {
                return classSym;
            }
            if (scope.isStatic()) break;
            scope = tmpContext.nextScope();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void listNames(Sym cookie, JavaHasType lhs, InputImpl options, OutputImpl output) {
        if (options.input == 0) {
            throw new IllegalArgumentException("Empty set");
        }
        if (lhs == null && ("this".equals(options.name) || "super".equals(options.name))) {
            JavaHasType thisSuper = this.resolveName(cookie, null, options.name, true);
            if (thisSuper == null) {
                return;
            }
            lhs = thisSuper;
            options.name = "<init>";
        }
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(cookie);
            if (lhs == null) {
                this.processAllPrimaries(options, output);
            } else {
                this.processAllSelectors(lhs, options, output);
            }
        }
        finally {
            this.context = savedContext;
        }
        if (lhs == null && !options.squash((byte)2) && options.input((byte)2)) {
            options.input = (byte)2;
            JavaPackage root = this.provider.getPackage("");
            this.listNames(cookie, root, options, output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void listNames(Sym cookie, JavaPackage lhs, InputImpl options, OutputImpl output) {
        if (lhs == null) {
            if (options.squash((byte)2)) {
                options.input = (byte)(options.input & 0xFFFFFFFD);
            }
            lhs = this.provider.getPackage("");
        }
        if (options.input == 0) {
            return;
        }
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(cookie);
            this.context.listNames(lhs, options, output);
        }
        finally {
            this.context = savedContext;
        }
    }

    private JavaHasType processSimpleName(String name, boolean ambiguous, boolean useStrict) {
        boolean thisName = "this".equals(name);
        boolean superName = "super".equals(name);
        Object out = null;
        Sym scope = this.context.cleanScope();
        while (scope != null) {
            switch (scope.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)scope;
                    if (thisName) {
                        JavaVariable thing = classSym.getThisVariable();
                        if (!this.context.flag_instance) {
                            this.error(this.context.symCookie, (short)62, name);
                        }
                        return thing;
                    }
                    if (superName) {
                        if (this.context.flag_instance) {
                            return classSym.getSuperVariable();
                        }
                        return classSym.getSuperclass();
                    }
                    if (this.context.findVisibleVariable(classSym, name)) {
                        return this.context.findMemberVariable(classSym, name);
                    }
                    if (!ambiguous) break;
                    if (this.context.findVisibleType(classSym, name)) {
                        return this.context.findMemberType(classSym, name);
                    }
                    JavaType foundParameter = this.context.findType(classSym, name);
                    if (foundParameter == null) break;
                    return foundParameter;
                }
                case 41: {
                    JavaType resolvedType;
                    SwitchStmt switchStmt = (SwitchStmt)scope;
                    Expr switchExpr = switchStmt.getExpressionSym();
                    if (switchExpr != null && (resolvedType = switchExpr.getResolvedType()) != null && resolvedType.isEnum()) {
                        if (this.context.findVisibleVariable(resolvedType, name)) {
                            return this.context.findMemberVariable(resolvedType, name);
                        }
                        return null;
                    }
                }
                default: {
                    JavaType foundType;
                    JavaVariable foundVariable = this.context.findVariable(scope, name, useStrict);
                    if (foundVariable != null) {
                        return foundVariable;
                    }
                    if (!ambiguous || (foundType = this.context.findType(scope, name)) == null) break;
                    return foundType;
                }
            }
            scope = this.context.nextScope();
        }
        this.context.cleanScope();
        return this.findImportedName(name, ambiguous);
    }

    private JavaHasType processSimpleSelector(String name, JavaType primaryType, boolean ambiguous) {
        if (primaryType == null) {
            return null;
        }
        if (this.context.findVisibleVariable(primaryType, name)) {
            return this.context.findMemberVariable(primaryType, name);
        }
        if (ambiguous && this.context.findVisibleType(primaryType, name)) {
            return this.context.findMemberType(primaryType, name);
        }
        return null;
    }

    private JavaMethod processSimpleMethodCall(String name, JavaType[] arguments, boolean strict) {
        boolean thisName = "this".equals(name);
        boolean superName = "super".equals(name);
        Sym scope = this.context.cleanScope();
        while (scope != null) {
            int scopeType = scope.getSymbolKind();
            if (scopeType == 3) {
                ClassSym classSym = (ClassSym)scope;
                if (thisName || superName) {
                    if (!this.context.flag_instance) {
                        return (JavaMethod)this.error(this.context.symCookie, (short)62, name);
                    }
                    JavaType searchClass = classSym;
                    if (superName) {
                        searchClass = classSym.getSuperclass();
                    }
                    if (searchClass == null) {
                        return null;
                    }
                    return this.context.findMethod(searchClass, "<init>", arguments);
                }
                if (strict) {
                    boolean visible = this.context.findVisibleMethod(classSym, name);
                    if (visible) {
                        return this.context.findMethod(classSym, name, arguments);
                    }
                } else {
                    JavaMethod single = this.context.findSingleMethod(classSym, name, arguments);
                    if (single != null) {
                        return single;
                    }
                }
            }
            scope = this.context.nextScope();
        }
        if (strict) {
            return this.findImportedMethod(name, arguments);
        }
        return null;
    }

    private JavaMethod processSelectorMethodCall(String name, JavaHasType primary, JavaType[] typeArguments, JavaType[] arguments, boolean strict) {
        JavaMethod m;
        JavaType resolvedType = this.processLhs(primary);
        if (resolvedType == null) {
            return null;
        }
        if (strict) {
            if (primary instanceof JavaType && !"<init>".equals(name)) {
                this.context.flag_instance = false;
            }
            return this.context.findMethod(resolvedType, name, typeArguments, arguments);
        }
        if (!"<init>".equals(name) && (m = this.context.findMethod(resolvedType, name, typeArguments, arguments)) != null) {
            return m;
        }
        return this.context.findSingleMethod(resolvedType, name, arguments);
    }

    private void processAllPrimaries(InputImpl options, OutputImpl output) {
        ClassSym classSym;
        Sym cookie;
        if (options.squash((byte)64) && options.input((byte)4) && (cookie = this.context.symCookie) != null && (classSym = cookie.getOwningClassSym()) != null) {
            output.keys().add(classSym.getName());
        }
        Sym scope = this.context.cleanScope();
        while (scope != null) {
            if (options.input == 0) {
                return;
            }
            if (scope.symKind == 3) {
                classSym = (ClassSym)scope;
                this.context.listMembers(classSym, options, output);
            } else {
                this.context.listNames(scope, options, output);
            }
            scope = this.context.nextScope();
        }
    }

    private void processAllSelectors(JavaHasType lhs, InputImpl options, OutputImpl output) {
        JavaType resolvedLhs = this.processLhs(lhs);
        if (resolvedLhs == null) {
            return;
        }
        this.context.listMembers(resolvedLhs, options, output);
    }

    private JavaType processLhs(JavaHasType primary) {
        if (primary == null) {
            return null;
        }
        JavaType resolvedType = primary.getResolvedType();
        if (resolvedType == null) {
            return null;
        }
        if (resolvedType.isPrimitive()) {
            return (JavaType)this.error(null, (short)51, resolvedType);
        }
        if (primary instanceof JavaType) {
            this.context.flag_instance = false;
        } else {
            this.context.flag_static = false;
        }
        return resolvedType;
    }

    private void processExceptions(Expr e, JavaMethod method) {
        if (method == null) {
            return;
        }
        for (JavaType exception : method.getExceptions()) {
            JavaClass cloneable;
            JavaType lhsType;
            if ("clone".equals(method.getName()) && "java/lang/CloneNotSupportedException".equals(exception.getVMName()) && ((lhsType = this.processLhs(e.getResolvedLhs())) == null || (cloneable = this.provider.getClassByVMName("java/lang/Cloneable")) != null && lhsType.isSubtypeOf(cloneable))) continue;
            this.processException(exception);
        }
    }

    private final void processException(JavaType thrown) {
        JavaClass runtimeException = this.getPreloadedClass((byte)5);
        if (thrown.isSubtypeOf(runtimeException)) {
            return;
        }
        JavaClass error = this.getPreloadedClass((byte)2);
        if (thrown.isSubtypeOf(error)) {
            return;
        }
        Sym scope = this.context.cleanScope();
        while (scope != null && !this.context.checkException(scope, thrown)) {
            scope = this.context.nextScope();
        }
    }

    private JavaMethod findImportedMethod(String name, JavaType[] arguments) {
        this.context.cleanScope();
        return this.context.findImportedMethod(name, arguments);
    }

    private JavaHasType findImportedName(String name, boolean ambiguous) {
        this.context.cleanScope();
        JavaVariable variable = this.context.findImportedVariable(name);
        if (variable != null) {
            return variable;
        }
        if (ambiguous) {
            return this.findImportedType(name);
        }
        return null;
    }

    protected final JavaHasType processExpression(Expr e) {
        JavaElement out = e.resolve((CompilerDriver)this);
        if (out != null) {
            return (JavaHasType)out;
        }
        return null;
    }

    protected final JavaType processExpressionType(Expr e, boolean typeAllowed) {
        JavaHasType hasType = this.processExpression(e);
        if (hasType == null) {
            return null;
        }
        if (hasType instanceof JavaType) {
            JavaType type = (JavaType)hasType;
            if (!typeAllowed) {
                this.error(e, (short)68, type);
            }
            return (JavaType)hasType;
        }
        return hasType.getResolvedType();
    }
}

