/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer1;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeArgumentSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;

abstract class CompilerLayer2
extends CompilerLayer1 {
    CompilerLayer2() {
    }

    protected abstract JavaType processInnerCreatorType(Expr var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType resolve(TypeSym typeSym) {
        JavaType result;
        this.checkCancel();
        if (typeSym == null) {
            return null;
        }
        typeSym.setProcessed();
        CompilerContext savedContext = this.context;
        short token = typeSym.typeToken;
        if (96 <= token && token < 146) {
            result = PrimitiveType.PRIMITIVE_lookup[token - 96];
            if (result == null) {
                this.error(typeSym, (short)69, typeSym.getName());
            }
        } else {
            String name = typeSym.getName();
            if (name.length() == 0) {
                return (JavaType)this.error(typeSym, (short)50);
            }
            try {
                this.context = this.newContext(typeSym);
                TypeSym qualifyingTypeSym = typeSym.getTypeSym();
                JavaType qualifyingType = null;
                if (qualifyingTypeSym != null && (qualifyingType = qualifyingTypeSym.getResolvedType()) == null) {
                    JavaType javaType = null;
                    return javaType;
                }
                result = this.processType(qualifyingType, name);
                if (result == null) {
                    JavaType javaType = (JavaType)this.error(typeSym, (short)69, name);
                    return javaType;
                }
                if (!this.context.allowAccess(result)) {
                    JavaType javaType = (JavaType)this.error(typeSym, (short)57, result);
                    return javaType;
                }
                this.recordUsage(typeSym, result);
            }
            finally {
                this.context = savedContext;
            }
        }
        if ((result = this.processTypeFilters(typeSym, result)) == null) {
            return null;
        }
        List arguments = typeSym.getTypeArguments();
        if (!arguments.isEmpty()) {
            try {
                this.context = this.newContext(typeSym);
                JavaType[] resolvedTypeArguments = this.resolveTypeArguments(result, arguments);
                if (resolvedTypeArguments != null) {
                    result = CommonUtilities.createParameterizedType(this.provider, result, resolvedTypeArguments);
                }
            }
            finally {
                this.context = savedContext;
            }
        }
        if (result == null) {
            return null;
        }
        int arrayDimension = typeSym.getArrayDimension();
        return this.provider.getArrayType(result, arrayDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compile(TypeSym typeSym) {
        this.checkCancel();
        if (typeSym == null) {
            return;
        }
        JavaType type = typeSym.getResolvedType();
        if (type == null) {
            return;
        }
        CompilerContext savedContext = this.context;
        List arguments = typeSym.getTypeArguments();
        if (!arguments.isEmpty()) {
            try {
                this.context = this.newContext(typeSym);
                if (type.isArray()) {
                    type = type.getBaseComponentType();
                }
                if (type != null) {
                    this.checkTypeArguments(type);
                }
            }
            finally {
                this.context = savedContext;
            }
        }
    }

    public final JavaType resolve(TypeArgumentSym sym) {
        JavaType type;
        TypeSym typeSym;
        byte bound = sym.argBound;
        if (bound != 3 && (typeSym = sym.getTypeSym()) != null && (type = typeSym.getResolvedType()) != null) {
            return CommonUtilities.createWildcardType(bound, type, this.provider);
        }
        return CommonUtilities.createWildcardType((byte)3, null, this.provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType resolveType(Sym cookie, String name) {
        if (name.indexOf(91) >= 0 || name.indexOf(60) >= 0) {
            if (cookie == null) {
                return null;
            }
            SymFactory symFactory = cookie.symFile.getSymFactory();
            TypeSym typeSym = (TypeSym)symFactory.createTypeFromText(name);
            if (typeSym == null) {
                return null;
            }
            CallerContextImpl callerContext = (CallerContextImpl)CallerContext.createContext(cookie, false);
            typeSym.setContext(callerContext);
            return typeSym.getResolvedType();
        }
        PrimitiveType primitive = PrimitiveType.lookupPrimitive(name);
        if (primitive != null) {
            return primitive;
        }
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(cookie);
            JavaType javaType = this.processType(null, name);
            return javaType;
        }
        finally {
            this.context = savedContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JavaType resolveType(Sym cookie, JavaType lhs, String name) {
        if (lhs == null) {
            return null;
        }
        CompilerContext savedContext = this.context;
        try {
            this.context = this.newContext(cookie);
            if (!this.context.allowAccess(lhs)) {
                JavaType javaType = (JavaType)this.error(this.context.symCookie, (short)57, lhs);
                return javaType;
            }
            JavaClass javaClass = this.context.findMemberType(lhs, name);
            return javaClass;
        }
        finally {
            this.context = savedContext;
        }
    }

    private JavaType processType(JavaType qualifyingType, String name) {
        if (qualifyingType == null) {
            int firstDot = name.indexOf(46);
            JavaType out = firstDot == -1 ? this.processSimpleType(name) : this.processQualifiedType(name);
            return out;
        }
        return this.processMemberType(qualifyingType, name);
    }

    protected JavaType[] resolveTypeArguments(JavaIsGeneric type, Collection arguments) {
        Collection parameters = type.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            this.error(null, (short)60, type);
            return null;
        }
        int argumentCount = arguments.size();
        if (parameterCount != argumentCount) {
            this.error(null, (short)67, type);
            return null;
        }
        JavaType[] array = new JavaType[argumentCount];
        Iterator argumentIterator = arguments.iterator();
        int i = 0;
        while (argumentIterator.hasNext()) {
            TypeArgumentSym sym = (TypeArgumentSym)argumentIterator.next();
            array[i++] = sym.getResolvedType();
        }
        return array;
    }

    protected void checkTypeArguments(JavaIsGeneric type) {
        Collection arguments = type.getActualTypeArguments();
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        Collection parameters = type.getTypeParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        try {
            boolean success = true;
            Iterator pIterator = parameters.iterator();
            Iterator aIterator = arguments.iterator();
            while (pIterator.hasNext() && success) {
                JavaType parameter = (JavaType)pIterator.next();
                JavaType argument = (JavaType)aIterator.next();
                if (parameter != null && argument != null && parameter.isAssignableFrom(argument)) continue;
                success = false;
            }
            if (success) {
                return;
            }
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        this.error(null, (short)67, type);
    }

    private JavaType processTypeFilters(TypeSym typeSym, JavaType target) {
        Sym parentSym = typeSym.getParentSym();
        if (parentSym == null) {
            return target;
        }
        if (target.isPrimitive() || target.isArray()) {
            switch (parentSym.symKind) {
                case 24: {
                    this.error(typeSym, (short)61, target);
                    break;
                }
                case 15: 
                case 22: {
                    this.error(typeSym, (short)52, target);
                }
            }
        } else {
            switch (parentSym.symKind) {
                case 24: {
                    JavaClass javaLangThrowable = this.getPreloadedClass((byte)7);
                    if (target.isSubtypeOf(javaLangThrowable)) break;
                    return (JavaType)this.error(typeSym, (short)61, target);
                }
                case 22: {
                    if (target.isInterface()) {
                        return (JavaType)this.error(typeSym, (short)40, target);
                    }
                    if (target.isEnum()) {
                        return (JavaType)this.error(typeSym, (short)38, target);
                    }
                    if (!Modifier.isFinal(target.getModifiers())) break;
                    return (JavaType)this.error(typeSym, (short)39, target);
                }
                case 15: {
                    if (target.isInterface()) break;
                    return (JavaType)this.error(typeSym, (short)41, target);
                }
            }
        }
        return target;
    }

    private JavaType processSimpleType(String name) {
        ClassCreatorExpr e;
        Expr lhs;
        Sym cookie = this.context.symCookie;
        Sym parent = cookie.getParentSym();
        if (parent != null && parent.symKind == 55 && (lhs = (e = (ClassCreatorExpr)parent).getLhsOperandSym()) != null) {
            return this.processInnerCreatorType(lhs, name);
        }
        Sym scope = this.context.cleanScope();
        boolean allowMemberClasses = true;
        while (scope != null) {
            switch (scope.symKind) {
                case 3: {
                    ClassSym classSym = (ClassSym)scope;
                    if (allowMemberClasses && this.context.findVisibleType(classSym, name)) {
                        return this.context.findMemberType(classSym, name);
                    }
                    JavaType found = this.context.findType(scope, name);
                    if (found != null) {
                        return found;
                    }
                    allowMemberClasses = true;
                    break;
                }
                case 15: 
                case 22: {
                    allowMemberClasses = false;
                }
                default: {
                    JavaType found = this.context.findType(scope, name);
                    if (found == null) break;
                    return found;
                }
            }
            scope = this.context.nextScope();
        }
        this.context.cleanScope();
        return this.findImportedType(name);
    }

    private JavaType processQualifiedType(String name) {
        int dot = name.indexOf(46);
        String firstName = name.substring(0, dot);
        JavaType firstType = this.processSimpleType(firstName);
        if (firstType == null) {
            return this.provider.getClass(name);
        }
        return this.processMemberType(firstType, name.substring(dot + 1));
    }

    private JavaType processMemberType(JavaType qualifyingType, String name) {
        JavaType currentType = qualifyingType;
        int previousDot = -1;
        while (currentType != null) {
            this.recordUsage(this.context.symCookie, currentType);
            if (!this.context.allowAccess(currentType)) {
                return (JavaType)this.error(this.context.symCookie, (short)57, currentType);
            }
            int nextDot = name.indexOf(46, previousDot + 1);
            String nextTarget = nextDot == -1 ? name.substring(previousDot + 1) : name.substring(previousDot + 1, nextDot);
            currentType = this.context.findMemberType(currentType, nextTarget);
            if (nextDot == -1) break;
            previousDot = nextDot;
        }
        return currentType;
    }

    protected final JavaType findImportedType(String name) {
        JavaClass foundClass;
        JavaClass found;
        FileSym sourceFile = this.context.symCookie.symFile;
        List importSyms = sourceFile.getSourceImports();
        for (ImportSym importSym : importSyms) {
            ArrayList importList;
            String fqname;
            int lastDot;
            String importedName;
            if (!importSym.isNarrow() || !(importedName = (lastDot = (fqname = importSym.getName()).lastIndexOf(46)) == -1 ? fqname : fqname.substring(lastDot + 1)).equals(name)) continue;
            importSym.setUsed();
            if (importSym.isInvalid()) {
                return null;
            }
            importSym.resolve();
            if (!importSym.isStatic()) {
                return (JavaType)importSym.getImportedElementAt(0);
            }
            JavaClass result = this.provider.getClass(fqname);
            if (result != null && (importList = importSym.getImportObj().importList) != null && !importList.contains(result)) {
                importList.add(result);
            }
            return result;
        }
        String packageName = sourceFile.getPackageName();
        if (packageName.length() > 0 ? (found = this.provider.getClass(packageName, name)) != null : (found = this.provider.getClass(name)) != null) {
            return found;
        }
        ImportSym foundImport = null;
        JavaClass alreadyFound = null;
        boolean javaLangSearched = false;
        HashSet<String> importKeys = new HashSet<String>();
        for (ImportSym importSym : importSyms) {
            if (importSym.isNarrow() || importSym.isInvalid()) continue;
            String importName = importSym.getName();
            if ("java.lang.*".equals(importName)) {
                javaLangSearched = true;
            }
            if (importKeys.contains(importName)) continue;
            importKeys.add(importName);
            String prefix = importName.substring(0, importName.length() - 2);
            JavaClass foundClass2 = this.provider.getClass(prefix, name);
            if (foundClass2 == null) continue;
            if (alreadyFound != null) {
                boolean foundClassCanAccess = this.context.allowAccess(foundClass2);
                boolean alreadyFoundCanAccess = this.context.allowAccess(alreadyFound);
                if (foundClassCanAccess && alreadyFoundCanAccess) {
                    this.error(importSym, (short)34, name);
                    continue;
                }
                if (!foundClassCanAccess) continue;
                alreadyFound = foundClass2;
                foundImport = importSym;
                continue;
            }
            alreadyFound = foundClass2;
            foundImport = importSym;
        }
        if (!javaLangSearched && (foundClass = this.provider.getClass("java.lang", name)) != null) {
            if (alreadyFound == null) {
                alreadyFound = foundClass;
            } else {
                this.error(foundImport, (short)34, name);
            }
        }
        if (foundImport != null) {
            foundImport.setUsed();
            ArrayList importList = foundImport.getImportObj().importList;
            if (importList != null && !importList.contains(alreadyFound)) {
                importList.add(alreadyFound);
            }
        }
        return alreadyFound;
    }
}

