/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.net.URL;
import java.util.concurrent.CancellationException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JavaProvider2;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.util.UsageHook;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;

abstract class CompilerLayer1
extends CompilerUtilities
implements ObjConstants {
    protected static final byte ___code_conventions = 0;
    protected Thread thread = Thread.currentThread();
    protected byte j2se = (byte)2;
    protected JavaProvider2 provider = null;
    protected CompilerContext context = null;
    private UsageHook hook = null;
    protected JavaClass[] preloadedClasses = new JavaClass[15];
    protected volatile boolean cancel = false;
    protected Throwable cancelTrace;
    protected Object cancelLock = new Throwable();
    public boolean flag_forgiving = false;

    CompilerLayer1() {
    }

    public Thread getThread() {
        return this.thread;
    }

    public JavaElement resolve(Sym sym) {
        CompilerLayer1.panic(sym);
        return null;
    }

    protected void setProvider(JavaProvider provider) {
        this.provider = new JavaProvider2Proxy(provider);
    }

    final CompilerContext newContext(Sym cookie) {
        return new CompilerContext((CompilerDriver)this, cookie);
    }

    public final void setCompilationUnit(Sym cookie) {
        if (this.context != null) {
            CompilerLayer1.panic(cookie);
        }
        this.context = this.newContext(cookie);
    }

    public final boolean inUsageMode() {
        return this.hook != null;
    }

    public final UsageHook getUsageHook() {
        return this.hook;
    }

    public final void setUsageHook(UsageHook hook) {
        this.hook = hook;
    }

    protected final void recordDefine(Sym thing) {
        if (this.hook == null) {
            return;
        }
        this.hook.handleDeclare(thing);
    }

    protected final void recordUsage(Sym cookie, JavaElement result) {
        if (this.hook == null) {
            return;
        }
        this.hook.handleUsage(cookie, result);
    }

    public boolean isJdkLoaded() {
        return this.getPreloadedClass((byte)4) != null;
    }

    public final boolean preloadClasses() {
        for (byte i = 0; i < 8; i = (byte)(i + 1)) {
            JavaClass loaded = this.getPreloadedClass(i);
            if (loaded != null) continue;
            return false;
        }
        return true;
    }

    protected final JavaClass getPreloadedClass(byte n) {
        if (this.preloadedClasses[n] == null) {
            this.preloadedClasses[n] = this.provider.getClassByVMName(CLASS_vmnames[n]);
        }
        if (this.preloadedClasses[n] != null) {
            return this.preloadedClasses[n];
        }
        if (n >= 8 && this.j2se < 3) {
            return null;
        }
        this.error(null, (short)69, CLASS_vmnames[n]);
        return null;
    }

    protected final JavaClass getSystemClass(String vmName) {
        JavaClass type = this.provider.getClassByVMName(vmName);
        if (type != null) {
            return type;
        }
        this.error(null, (short)69, vmName);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            this.cancel = true;
            this.cancelTrace = new Throwable("cancel origin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearCancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            this.cancel = false;
            this.cancelTrace = null;
        }
    }

    protected final void checkCancel() {
        Thread.currentThread();
        if (Thread.interrupted()) {
            this.cancel();
        }
        if (!this.cancel) {
            return;
        }
        this.error(null, (short)36);
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.cancel) {
                return;
            }
            CancellationException cancellation = new CancellationException();
            cancellation.initCause(this.cancelTrace);
            throw cancellation;
        }
    }

    public final JavaElement error(Sym s, short errorCode) {
        return this.errorImpl(s, errorCode, EMPTY_OBJECT_ARRAY);
    }

    public final JavaElement error(Sym s, short errorCode, Object data) {
        if (data != null) {
            return this.errorImpl(s, errorCode, new Object[]{data});
        }
        return this.error(s, errorCode);
    }

    public final JavaElement error(Sym s, short errorCode, Object data0, Object data1) {
        if (data1 != null) {
            return this.errorImpl(s, errorCode, new Object[]{data0, data1});
        }
        return this.error(s, errorCode, data0);
    }

    public final JavaElement error(Sym s, short errorCode, Object data0, Object data1, Object data2) {
        if (data2 != null) {
            return this.errorImpl(s, errorCode, new Object[]{data0, data1, data2});
        }
        return this.error(s, errorCode, data0, data1);
    }

    public final JavaElement errorImpl(Sym s, short errorCode, Object[] data) {
        FileSym symFile;
        if (this.context != null && this.context.suppressErrors && InternalUtilities.error2severity(errorCode) >= 3) {
            return null;
        }
        Sym cookie = s;
        if (cookie == null) {
            if (this.context == null) {
                return null;
            }
            cookie = this.context.symCookie;
            if (cookie == null) {
                return null;
            }
        }
        if ((symFile = cookie.symFile) == null) {
            return null;
        }
        this.generateErrorImpl(symFile, cookie, errorCode, data);
        return null;
    }

    private static class JavaProvider2Proxy
    implements JavaProvider2 {
        private JavaProvider javaProvider;
        private boolean isJavaProvider2;

        private JavaProvider2Proxy(JavaProvider javaProvider) {
            this.javaProvider = javaProvider;
            this.isJavaProvider2 = javaProvider instanceof JavaProvider2;
        }

        @Override
        public JavaClass getClassInterruptibly(String fqName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassInterruptibly(fqName);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClass(fqName);
        }

        @Override
        public JavaClass getClassInterruptibly(String fqPrefix, String name) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassInterruptibly(fqPrefix, name);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClass(fqPrefix, name);
        }

        @Override
        public JavaClass getClassByVMNameInterruptibly(String fqVmName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassByVMNameInterruptibly(fqVmName);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClassByVMName(fqVmName);
        }

        @Override
        public SourceClass getSourceClassInterruptibly(String fqName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getSourceClassInterruptibly(fqName);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getSourceClass(fqName);
        }

        @Override
        public JavaClass getClass(String fqName) {
            return this.getClassInterruptibly(fqName);
        }

        @Override
        public JavaClass getClass(String fqPrefix, String name) {
            return this.getClassInterruptibly(fqPrefix, name);
        }

        @Override
        public JavaClass getClassByVMName(String fqVmName) {
            return this.getClassByVMNameInterruptibly(fqVmName);
        }

        @Override
        public JavaType getArrayType(JavaType componentType, int dimensions) {
            return this.javaProvider.getArrayType(componentType, dimensions);
        }

        @Override
        public SourceClass getSourceClass(String fqName) {
            return this.getSourceClassInterruptibly(fqName);
        }

        @Override
        public JavaPackage getPackage(String fqPrefix) {
            return this.javaProvider.getPackage(fqPrefix);
        }

        @Override
        public TextBuffer getTextBuffer(URL url) {
            return this.javaProvider.getTextBuffer(url);
        }
    }
}

