/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.Parameterization;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.WrapperClass;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

final class ParameterizedClass
extends WrapperClass {
    private final JavaClass owningClass;
    final Parameterization params;
    private JavaType boundSuperclass = null;
    private Collection boundInterfaces = null;
    private Collection fields = null;
    private Collection methods = null;
    private Collection constructors = null;
    private Collection classes = null;

    ParameterizedClass(JavaProvider provider, JavaClass baseType, JavaType[] arguments) {
        super(baseType);
        this.params = new Parameterization(provider, baseType, arguments);
        this.owningClass = null;
    }

    @Override
    public JavaClass getOwningClass() {
        if (this.owningClass == null) {
            return super.getOwningClass();
        }
        return this.owningClass;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.params.boundArguments.length > 0;
    }

    @Override
    public Collection getActualTypeArguments() {
        if (this.params.boundArguments.length == 0) {
            return kEmptyCollection;
        }
        return Arrays.asList(this.params.boundArguments);
    }

    @Override
    public JavaClass getTypeErasure() {
        return super.getTypeErasure();
    }

    private String getNameImpl(boolean qualified) {
        JavaClass owningClass = this.getOwningClass();
        String prefix = owningClass == null ? (qualified ? this.thing.getQualifiedName() : this.thing.getUnqualifiedName()) : (qualified ? owningClass.getQualifiedName() + '.' + this.getName() : owningClass.getUnqualifiedName() + '.' + this.getName());
        if (prefix.length() == 0) {
            return "";
        }
        int count = this.params.boundArguments.length;
        if (count == 0) {
            return prefix;
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('<');
        boolean needComma = false;
        for (int i = 0; i < count; ++i) {
            JavaType arg;
            if (needComma) {
                buffer.append(", ");
            }
            if ((arg = this.params.boundArguments[i]) != null) {
                if (qualified) {
                    buffer.append(arg.getQualifiedName());
                } else {
                    buffer.append(arg.getUnqualifiedName());
                }
            } else {
                buffer.append('N');
            }
            needComma = true;
        }
        buffer.append('>');
        return buffer.toString();
    }

    @Override
    public String getUnqualifiedName() {
        return this.getNameImpl(false);
    }

    @Override
    public String getQualifiedName() {
        return this.getNameImpl(true);
    }

    @Override
    public String getDescriptor() {
        JavaClass erasure = this.getTypeErasure();
        if (erasure != null) {
            return erasure.getDescriptor();
        }
        return super.getDescriptor();
    }

    @Override
    public JavaType getSuperclass() {
        if (this.boundSuperclass == null) {
            JavaType superclass = super.getSuperclass();
            if (superclass == null) {
                return null;
            }
            this.boundSuperclass = this.params.bind(superclass);
        }
        return this.boundSuperclass;
    }

    @Override
    public Collection getInterfaces() {
        if (this.boundInterfaces == null) {
            this.boundInterfaces = this.params.bind(super.getInterfaces());
        }
        return this.boundInterfaces;
    }

    @Override
    public Collection getDeclaredFields() {
        if (this.fields == null) {
            Collection thingFields = super.getDeclaredFields();
            if (thingFields.isEmpty()) {
                this.fields = thingFields;
            } else {
                JavaField[] array = new JavaField[thingFields.size()];
                Iterator iterator = thingFields.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaField thing = (JavaField)iterator.next();
                    if (thing.isStatic()) {
                        array[i++] = thing;
                        continue;
                    }
                    array[i++] = new BoundMemberField(this, thing);
                }
                this.fields = Arrays.asList(array);
            }
        }
        return this.fields;
    }

    @Override
    public Collection getDeclaredMethods() {
        if (this.methods == null) {
            Collection thingMethods = super.getDeclaredMethods();
            if (thingMethods.isEmpty()) {
                this.methods = thingMethods;
            } else {
                JavaMethod[] array = new JavaMethod[thingMethods.size()];
                Iterator iterator = thingMethods.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaMethod thing = (JavaMethod)iterator.next();
                    if (thing.isStatic()) {
                        array[i++] = thing;
                        continue;
                    }
                    array[i++] = new BoundMemberMethod(this, thing);
                }
                this.methods = Arrays.asList(array);
            }
        }
        return this.methods;
    }

    @Override
    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            Collection thingConstructors = super.getDeclaredConstructors();
            if (thingConstructors.isEmpty()) {
                this.constructors = thingConstructors;
            } else {
                JavaMethod[] array = new JavaMethod[thingConstructors.size()];
                Iterator iterator = thingConstructors.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaMethod thing = (JavaMethod)iterator.next();
                    if (thing.isStatic()) {
                        array[i++] = thing;
                        continue;
                    }
                    array[i++] = new BoundMemberMethod(this, thing);
                }
                this.constructors = Arrays.asList(array);
            }
        }
        return this.constructors;
    }

    @Override
    public Collection getDeclaredClasses() {
        if (this.classes == null) {
            Collection thingClasses = super.getDeclaredClasses();
            if (thingClasses.isEmpty()) {
                this.classes = thingClasses;
            } else {
                JavaClass[] array = new JavaClass[thingClasses.size()];
                Iterator iterator = thingClasses.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JavaClass thing = (JavaClass)iterator.next();
                    if (thing.isStatic()) {
                        array[i++] = thing;
                        continue;
                    }
                    array[i++] = new BoundMemberClass(thing);
                }
                this.classes = Arrays.asList(array);
            }
        }
        return this.classes;
    }

    private class BoundMemberMethod
    extends WrapperMethod {
        private JavaType type;
        private Collection parameters;
        private Collection exceptions;
        private JavaClass owningClass;

        private BoundMemberMethod(JavaClass owningClass, JavaMethod thing) {
            super(thing);
            this.type = null;
            this.parameters = null;
            this.exceptions = null;
            this.owningClass = owningClass;
        }

        @Override
        public JavaType getReturnType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                if (this.type == null) {
                    this.type = PrimitiveType.PRIMITIVE_objects[9];
                }
            }
            return this.type;
        }

        @Override
        public JavaType getResolvedType() {
            return this.getReturnType();
        }

        @Override
        public Collection getParameters() {
            if (this.parameters == null) {
                Collection thingParameters = this.thing.getParameters();
                if (thingParameters.isEmpty()) {
                    this.parameters = thingParameters;
                } else {
                    BoundParameter[] array = new BoundParameter[thingParameters.size()];
                    Iterator iterator = thingParameters.iterator();
                    int i = 0;
                    while (iterator.hasNext()) {
                        JavaLocalVariable parameter = (JavaLocalVariable)iterator.next();
                        array[i++] = new BoundParameter(parameter);
                    }
                    this.parameters = Arrays.asList(array);
                }
            }
            return this.parameters;
        }

        @Override
        public Collection getExceptions() {
            if (this.exceptions == null) {
                this.exceptions = ParameterizedClass.this.params.bind(this.thing.getExceptions());
            }
            return this.exceptions;
        }

        @Override
        public JavaClass getOwningClass() {
            return this.owningClass;
        }

        @Override
        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        private class BoundParameter
        extends WrapperLocalVariable {
            private JavaType type;

            private BoundParameter(JavaLocalVariable thing) {
                super(thing);
                this.type = null;
            }

            @Override
            public JavaType getResolvedType() {
                if (this.type == null) {
                    this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
                }
                return this.type;
            }

            @Override
            public UnresolvedType getUnresolvedType() {
                return this.thing.getUnresolvedType();
            }

            @Override
            public JavaElement getOwner() {
                return BoundMemberMethod.this;
            }
        }
    }

    private class BoundMemberField
    extends WrapperField {
        private JavaType type;
        private JavaClass owningClass;

        private BoundMemberField(JavaClass owningClass, JavaField thing) {
            super(thing);
            this.type = null;
            this.owningClass = owningClass;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
            }
            return this.type;
        }

        @Override
        public JavaClass getOwningClass() {
            return this.owningClass;
        }
    }

    private class BoundMemberClass
    extends WrapperClass {
        private JavaType type;

        private BoundMemberClass(JavaClass thing) {
            super(thing);
            this.type = null;
        }

        @Override
        public JavaClass getOwningClass() {
            return ParameterizedClass.this;
        }

        @Override
        public JavaType getResolvedType() {
            if (this.type == null) {
                this.type = ParameterizedClass.this.params.bind(this.thing.getResolvedType());
            }
            return this.type;
        }

        @Override
        public String getQualifiedName() {
            StringBuilder buf = new StringBuilder();
            String owningClassQualfiedName = ParameterizedClass.this.getQualifiedName();
            if (owningClassQualfiedName != null && owningClassQualfiedName.length() > 0) {
                buf.append(owningClassQualfiedName);
                buf.append('.');
            }
            buf.append(this.getName());
            return buf.toString();
        }

        @Override
        public Collection getDeclaredMethods() {
            return this.handleDeclaredMethods(super.getDeclaredMethods());
        }

        @Override
        public Collection getDeclaredConstructors() {
            return this.handleDeclaredMethods(super.getDeclaredConstructors());
        }

        private Collection handleDeclaredMethods(Collection methods) {
            if (methods.size() == 0) {
                return methods;
            }
            ArrayList<JavaMethod> boundMethods = new ArrayList<JavaMethod>(methods.size());
            for (JavaMethod method : methods) {
                if (method.isStatic()) {
                    boundMethods.add(method);
                    continue;
                }
                boundMethods.add(new BoundMemberMethod(this, method));
            }
            return boundMethods;
        }

        @Override
        public Collection getDeclaredFields() {
            Collection fields = super.getDeclaredFields();
            if (fields.size() == 0) {
                return fields;
            }
            ArrayList<JavaField> boundFields = new ArrayList<JavaField>(fields.size());
            for (JavaField field : fields) {
                if (field.isStatic()) {
                    boundFields.add(field);
                    continue;
                }
                boundFields.add(new BoundMemberField(this, field));
            }
            return boundFields;
        }
    }
}

