/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;

public abstract class AbstractClass
extends AbstractType
implements JavaClass {
    @Override
    public int getElementKind() {
        return 3;
    }

    @Override
    public JavaClass getTypeErasure() {
        return this;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isExported() {
        JavaClass owning = this.getOwningClass();
        if (owning == null) {
            return true;
        }
        if (this.isMemberClass0(owning)) {
            return owning.isExported();
        }
        return false;
    }

    @Override
    public boolean isMemberClass() {
        JavaClass owning = this.getOwningClass();
        if (owning == null) {
            return false;
        }
        String name = this.getName();
        if (name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            return false;
        }
        return this.getQualifiedName().startsWith(owning.getQualifiedName());
    }

    private boolean isMemberClass0(JavaClass owning) {
        if (owning == null) {
            return false;
        }
        String name = this.getName();
        if (name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(ch)) {
            return false;
        }
        return this.getQualifiedName().startsWith(owning.getQualifiedName());
    }
}

