/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.PrintStream;
import java.net.URL;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClassConstants;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.classfile.NamePool;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.CommonUtilities;

public final class ClassFile
implements ClassConstants {
    private static final ClassField[] EMPTY_FIELD_ARRAY;
    private static final ClassMethod[] EMPTY_METHOD_ARRAY;
    private static final ClassAnnotation[] EMPTY_ANNOTATION_ARRAY;
    private static final ComponentValue[] EMPTY_VALUE_ARRAY;
    private static final ClassAnnotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY;
    private static final int PROCESSED = Integer.MIN_VALUE;
    private static final int DEPRECATED = 65536;
    private static final int HIDDEN_ATTR = 0x20000000;
    private static final Name[] ATTRIBUTE_names;
    private static final byte[] ATTRIBUTE_indices;
    private static final Name kInitS;
    private static final Name kClinitS;
    private static final Name kJavaLangObjectS;
    private byte[] buffer;
    private int bp;
    private int[] poolIdx;
    private Object[] poolObj;
    private int implBp;
    private int fieldBp;
    private int methodBp;
    private int attrBp;
    private URL url;
    private int modifiers;
    private Name thisClassName;
    private Name sourceFilename;
    private Name classSignature;
    private NameType baseClass;
    private NameType[] baseInterfaces;
    private ClassField[] fields;
    private ClassMethod clinit;
    private ClassMethod[] methods;
    private ClassMethod[] constructors;
    private NameType outerClass;
    private NameType[] innerClasses;
    private ClassAnnotation[] classAnnotations;
    public static int ___constant_pool;
    public static final int ___inner_classes = 0;
    private static final int kMember_AttrPos = 6;

    private static final byte name2attribute(Name name) {
        int index = name.index;
        if (0 <= index && index < ATTRIBUTE_indices.length) {
            return ATTRIBUTE_indices[index];
        }
        return 0;
    }

    public ClassFile(byte[] buffer, URL url) {
        block2: {
            this.implBp = 0;
            this.fieldBp = 0;
            this.methodBp = 0;
            this.attrBp = 0;
            this.sourceFilename = null;
            this.classSignature = null;
            this.baseClass = null;
            this.baseInterfaces = null;
            this.fields = null;
            this.clinit = null;
            this.methods = null;
            this.constructors = null;
            this.outerClass = null;
            this.innerClasses = null;
            this.classAnnotations = null;
            this.buffer = buffer;
            this.url = url;
            try {
                this.readHeader();
                this.indexFields();
                this.indexMethods();
                this.readClassAttributes();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (url == null) break block2;
                System.err.println("Error when processing " + url);
            }
        }
    }

    public ClassFile(byte[] buffer) {
        this(buffer, null);
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        if (this.classSignature != null) {
            return this.classSignature.toString();
        }
        return null;
    }

    public boolean isDeprecated() {
        this.readClassAttributes();
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isHidden() {
        this.readClassAttributes();
        return (this.modifiers & 0x20000000) != 0;
    }

    public String getFullClassName() {
        return this.thisClassName.toString();
    }

    public NameType getBaseClass() {
        return this.baseClass;
    }

    public NameType[] getBaseInterfaces() {
        if (this.baseInterfaces == null) {
            this.readBaseInterfaces();
        }
        return this.baseInterfaces;
    }

    public NameType getOuterClass() {
        if (this.outerClass == null) {
            this.readClassAttributes();
        }
        return this.outerClass;
    }

    public ClassField[] getDeclaredFields() {
        if (this.fields == null) {
            this.readFields();
        }
        return this.fields;
    }

    public ClassMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.methods;
    }

    public ClassMethod[] getDeclaredConstructors() {
        if (this.constructors == null) {
            this.readMethods();
        }
        return this.constructors;
    }

    public ClassMethod getClinitMethod() {
        if (this.methods == null) {
            this.readMethods();
        }
        return this.clinit;
    }

    public NameType[] getDeclaredInnerClasses() {
        if (this.innerClasses == null) {
            this.readClassAttributes();
        }
        return this.innerClasses;
    }

    public ClassAnnotation[] getDeclaredAnnotations() {
        if (this.classAnnotations == null) {
            this.readClassAttributes();
        }
        return this.classAnnotations;
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            return null;
        }
        return this.sourceFilename.toString();
    }

    public URL getURL() {
        return this.url;
    }

    private void readHeader() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            this.fileError("Bad magic number");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion * 100 + minorVersion < 4503) {
            this.fileError("Wrong version");
        }
        this.indexConstantPool();
        this.modifiers = this.nextChar();
        this.thisClassName = (Name)this.readPoolObject(this.nextChar());
        this.baseClass = this.readPoolClass(this.nextChar());
        this.implBp = this.bp;
        char interfaceCount = this.nextChar();
        this.bp += 2 * interfaceCount;
        this.fieldBp = this.bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int fieldCount = this.nextChar();
            for (int i = 0; i < fieldCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.methodBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            for (int i = 0; i < methodCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.attrBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBaseInterfaces() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.baseInterfaces != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.implBp;
            int interfaceCount = this.nextChar();
            NameType[] newBaseInterfaces = new NameType[interfaceCount];
            for (int i = 0; i < interfaceCount; ++i) {
                NameType n = this.readPoolClass(this.nextChar());
                if (n == null) {
                    String message = "Invalid reference";
                    this.fileError("Invalid reference");
                    continue;
                }
                newBaseInterfaces[i] = n;
            }
            this.bp = savedBp;
            this.baseInterfaces = newBaseInterfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.fields != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.fieldBp;
            int fieldCount = this.nextChar();
            ClassField[] newFields = ClassFile.createFieldArray(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                newFields[i] = new ClassField();
            }
            if (this.methodBp == 0) {
                this.methodBp = this.bp;
            } else {
                this.bp = savedBp;
            }
            this.fields = newFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methods != null) {
                return;
            }
            int savedBp = this.bp;
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            if (methodCount == 0) {
                this.methods = EMPTY_METHOD_ARRAY;
                this.constructors = EMPTY_METHOD_ARRAY;
                this.clinit = null;
            } else {
                ClassMethod[] allMethods = new ClassMethod[methodCount];
                int nConstructors = 0;
                int nClInit = 0;
                for (int i = 0; i < methodCount; ++i) {
                    ClassMethod m;
                    allMethods[i] = m = new ClassMethod();
                    if (m.isConstructor()) {
                        ++nConstructors;
                        continue;
                    }
                    if (!m.isClinit()) continue;
                    ++nClInit;
                }
                ClassMethod[] newMethods = ClassFile.createMethodArray(methodCount - nConstructors - nClInit);
                ClassMethod[] newConstructors = ClassFile.createMethodArray(nConstructors);
                ClassMethod newClinit = null;
                int m = 0;
                int c = 0;
                for (int i = 0; i < methodCount; ++i) {
                    ClassMethod method = allMethods[i];
                    if (method.isConstructor()) {
                        newConstructors[c++] = method;
                        continue;
                    }
                    if (method.isClinit()) {
                        if (newClinit != null) {
                            // empty if block
                        }
                        newClinit = method;
                        continue;
                    }
                    newMethods[m++] = method;
                }
                this.constructors = newConstructors;
                this.clinit = newClinit;
                this.methods = newMethods;
            }
            if (this.attrBp == 0) {
                this.attrBp = this.bp;
            } else {
                this.bp = savedBp;
            }
        }
    }

    private void readInnerClasses() {
        int count = this.nextChar();
        NameType[] preliminary = new NameType[count];
        int actual = 0;
        while (count-- > 0) {
            NameType inner = this.readPoolClass(this.nextChar());
            NameType outer = this.readPoolClass(this.nextChar());
            this.bp += 2;
            char flags = this.nextChar();
            if (outer != null && outer.name.index == this.thisClassName.index) {
                preliminary[actual++] = inner;
                continue;
            }
            if (inner == null || inner.name.index != this.thisClassName.index) continue;
            int tmpMods = this.modifiers & 0xFFFFFFFE;
            this.outerClass = outer;
            this.modifiers = tmpMods | flags & 0xF;
        }
        if (actual == 0) {
            this.innerClasses = NameType.EMPTY_ARRAY;
        } else {
            this.innerClasses = new NameType[actual];
            System.arraycopy(preliminary, 0, this.innerClasses, 0, actual);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassAttributes() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if ((this.modifiers & Integer.MIN_VALUE) != 0) {
                return;
            }
            int savedBp = this.bp;
            if (this.attrBp == 0) {
                this.indexMethods();
            }
            try {
                this.bp = this.attrBp;
                int attrCount = this.nextChar();
                block15: for (int i = 0; i < attrCount; ++i) {
                    char attrIndex = this.nextChar();
                    int attrLen = this.nextInt();
                    int attrSavedBp = this.bp;
                    Name attrName = this.readPoolName(attrIndex);
                    byte attribute = ClassFile.name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            continue block15;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            continue block15;
                        }
                        case 15: {
                            this.classSignature = this.readPoolExternal(this.nextChar());
                            continue block15;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            continue block15;
                        }
                        case 11: 
                        case 13: {
                            this.classAnnotations = this.readAnnotations(this.classAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (this.bp != endBp) {
                                this.fileError("Invalid annotations length");
                            }
                            this.bp = endBp;
                            continue block15;
                        }
                        case 16: {
                            this.sourceFilename = this.readPoolName(this.nextChar());
                            continue block15;
                        }
                        case 7: {
                            this.readInnerClasses();
                            continue block15;
                        }
                        default: {
                            this.bp += attrLen;
                        }
                    }
                }
                if (this.innerClasses == null) {
                    this.innerClasses = NameType.EMPTY_ARRAY;
                }
                if (this.classAnnotations == null) {
                    this.classAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                this.modifiers |= Integer.MIN_VALUE;
            }
            finally {
                this.bp = savedBp;
            }
        }
    }

    private void indexConstantPool() {
        int entryCount = this.nextChar();
        this.poolIdx = new int[entryCount];
        this.poolObj = new Object[entryCount];
        int i = 1;
        block6: while (i < entryCount) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buffer[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block6;
                }
            }
            this.fileError("Bad constant pool tag: " + tag);
        }
    }

    private Object readPoolObject(int poolIndex) {
        Object o;
        if (poolIndex < 0 || this.poolObj.length <= poolIndex) {
            this.fileError("Invalid pool index");
        }
        if (this.poolObj[poolIndex] != null) {
            return this.poolObj[poolIndex];
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (byteIndex == 0) {
            return null;
        }
        this.poolObj[poolIndex] = o = this.readPoolObjectImpl(byteIndex);
        return o;
    }

    private Object readPoolObjectImpl(int byteIndex) {
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                return NamePool.global.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            }
            case 7: {
                return this.readPoolExternal(this.getChar(byteIndex + 1));
            }
            case 2: {
                this.fileError("Can't read unicode");
                break;
            }
            case 8: {
                Name n = (Name)this.readPoolObject(this.getChar(byteIndex + 1));
                return n.toString();
            }
            case 3: {
                int i = this.getInt(byteIndex + 1);
                return new Integer(i);
            }
            case 4: {
                float f = Float.intBitsToFloat(this.getInt(byteIndex + 1));
                return new Float(f);
            }
            case 5: {
                long l = this.getLong(byteIndex + 1);
                return new Long(l);
            }
            case 6: {
                double d = Double.longBitsToDouble(this.getLong(byteIndex + 1));
                return new Double(d);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fileError("Shouldn't be handling these attributes: " + tag);
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
            }
        }
        return null;
    }

    private Object readPoolConstant(int poolIndex, char descriptor) {
        switch (descriptor) {
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 's': {
                return this.readPoolObject(poolIndex);
            }
            case 'c': {
                Name name = this.readPoolName(poolIndex);
                return NameType.getTypeFor(name);
            }
            case '@': 
            case '[': 
            case 'e': {
                return null;
            }
        }
        Integer i = (Integer)this.readPoolObject(poolIndex);
        if (i == null) {
            return null;
        }
        switch (descriptor) {
            case 'S': {
                return new Short((short)i.intValue());
            }
            case 'C': {
                return new Character((char)i.intValue());
            }
            case 'B': {
                return new Byte((byte)i.intValue());
            }
            case 'Z': {
                if (i == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        }
        this.fileError("Invalid type for a ConstantValue attribute");
        return null;
    }

    private Name readPoolName(int poolIndex) {
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolExternal(int poolIndex) {
        if (this.poolObj[poolIndex] == null) {
            int byteIndex = this.poolIdx[poolIndex];
            if (this.buffer[byteIndex] == 1) {
                this.poolObj[poolIndex] = NamePool.global.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            } else {
                this.fileError("Expected CONSTANT_Utf8 index");
            }
        }
        return (Name)this.poolObj[poolIndex];
    }

    private NameType readPoolClass(int poolIndex) {
        Name name;
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 7) {
            this.fileError("Expected CONSTANT_Class index");
        }
        if ((name = (Name)this.readPoolObject(poolIndex)) != null) {
            return NameType.getTypeFor(name);
        }
        return null;
    }

    private byte nextByte() {
        return this.buffer[this.bp++];
    }

    private char nextChar() {
        int b = this.bp;
        char ch = (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
        this.bp += 2;
        return ch;
    }

    private int nextInt() {
        int b = this.bp;
        int i = (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
        this.bp += 4;
        return i;
    }

    private char getChar(int b) {
        return (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
    }

    private int getInt(int b) {
        return (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
    }

    private long getLong(int b) {
        long hi = this.getInt(b);
        long lo = this.getInt(b + 4);
        return hi << 32 | lo;
    }

    public final synchronized void dump(PrintStream out) {
        String filename;
        int mods = this.getModifiers();
        ClassFile.dumpModifiers(out, mods, true, false);
        if ((mods & 0x2000) != 0) {
            out.print("@interface ");
        } else if ((mods & 0x200) != 0) {
            out.print("interface ");
        } else if ((mods & 0x4000) != 0) {
            out.print("enum ");
        } else {
            out.print("class ");
        }
        out.println(this.getFullClassName());
        out.println("  extends " + this.getBaseClass().toString());
        NameType[] interfaces = this.getBaseInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            out.println("  implements " + interfaces[i].toString());
        }
        String signature = this.getSignature();
        if (signature != null) {
            out.println("  signature: " + signature);
        }
        if ((filename = this.getSourceFilename()) != null) {
            out.println("SourceFile: " + filename);
        }
        ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
        out.println();
        this.dumpConstantPool(out);
        this.readClassAttributes();
        this.dumpAttributes(this.attrBp);
        out.println("Fields:");
        ClassField[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].dump(out);
        }
        out.println();
        out.println("Constructors:");
        ClassMethod[] constructors = this.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            constructors[i].dump(out);
        }
        out.println();
        out.println("Methods:");
        ClassMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            methods[i].dump(out);
        }
        out.println();
    }

    private void dumpConstantPool(PrintStream out) {
        out.println("Constant pool:");
        for (int i = 1; i < this.poolIdx.length; ++i) {
            out.print(i + "\t");
            this.dumpPoolObject(out, i);
            out.println();
            int byteIndex = this.poolIdx[i];
            byte tag = this.buffer[byteIndex];
            if (tag != 5 && tag != 6) continue;
            ++i;
        }
        out.println();
    }

    private void dumpPoolObject(PrintStream out, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                out.print("(Utf8) ");
                break;
            }
            case 7: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(Class) #" + ref + ": ");
                break;
            }
            case 2: {
                out.print("(Unicode) ??");
                return;
            }
            case 8: {
                char ref = this.getChar(byteIndex + 1);
                out.print("(String) #" + ref + ": ");
                break;
            }
            case 3: {
                out.print("(Integer) ");
                break;
            }
            case 4: {
                out.print("(Float) ");
                break;
            }
            case 5: {
                out.print("(Long) ");
                break;
            }
            case 6: {
                out.print("(Double) ");
                break;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                out.print("(NameandTypeRef) ");
                out.print("#" + nameref + " #" + typeref + ": ");
                break;
            }
            case 9: {
                out.print("(Fieldref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 10: {
                out.print("(Methodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 11: {
                out.print("(InterfaceMethodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                out.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            default: {
                this.fileError("Bad constant pool tag: " + tag);
            }
        }
        this.dumpPoolObjectImpl(out, poolIndex);
    }

    private void dumpPoolObjectImpl(PrintStream out, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 7: {
                char ref = this.getChar(byteIndex + 1);
                this.dumpPoolObjectImpl(out, ref);
                return;
            }
            case 8: {
                char ref = this.getChar(byteIndex + 1);
                this.dumpPoolObjectImpl(out, ref);
                return;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(out, nameref);
                out.print(", ");
                this.dumpPoolObjectImpl(out, typeref);
                return;
            }
            case 9: 
            case 10: 
            case 11: {
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(out, classref);
                out.print(".");
                this.dumpPoolObjectImpl(out, nametyperef);
                return;
            }
        }
        Object o = this.readPoolObject(poolIndex);
        if (o != null) {
            out.print(o);
        }
    }

    private static void dumpModifiers(PrintStream out, int modifiers, boolean isClass, boolean isField) {
        if ((modifiers & 1) != 0) {
            out.print("public ");
        }
        if ((modifiers & 2) != 0) {
            out.print("private ");
        }
        if ((modifiers & 4) != 0) {
            out.print("protected ");
        }
        if ((modifiers & 8) != 0) {
            out.print("static ");
        }
        if ((modifiers & 0x10) != 0) {
            out.print("final ");
        }
        if (!isClass && (modifiers & 0x20) != 0) {
            out.print("synchronized ");
        }
        if (isField) {
            if ((modifiers & 0x40) != 0) {
                out.print("volatile ");
            }
            if ((modifiers & 0x80) != 0) {
                out.print("transient ");
            }
        }
        if ((modifiers & 0x100) != 0) {
            out.print("native ");
        }
        if ((modifiers & 0x400) != 0) {
            out.print("abstract ");
        }
        if ((modifiers & 0x800) != 0) {
            out.print("strictfp ");
        }
        if ((modifiers & 0x1000) != 0) {
            out.print("(synthetic) ");
        }
        if ((modifiers & 0x2000) != 0) {
            out.print("(annotation) ");
        }
        if ((modifiers & 0x4000) != 0) {
            out.print("(enum) ");
        }
        if ((modifiers & 0x10000) != 0) {
            out.print("@deprecated ");
        }
        if ((modifiers & 0x20000000) != 0) {
            out.print("@hidden ");
        }
    }

    private static void dumpAnnotations(PrintStream out, ClassAnnotation[] a) {
        if (a.length == 0) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            a[i].dump(out);
        }
    }

    private static ClassField[] createFieldArray(int size) {
        if (size == 0) {
            return EMPTY_FIELD_ARRAY;
        }
        return new ClassField[size];
    }

    private static ClassMethod[] createMethodArray(int size) {
        if (size == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        return new ClassMethod[size];
    }

    private void skipFieldOrMethod() {
        this.bp += 6;
        int attrCount = this.nextChar();
        for (int i = 0; i < attrCount; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    private void skipAnnotation() {
        this.bp += 2;
        int count = this.nextChar();
        for (int i = 0; i < count; ++i) {
            this.skipComponent();
        }
    }

    private void skipComponent() {
        this.bp += 2;
        this.skipComponentValue();
    }

    private void skipComponentValue() {
        byte tag = this.nextByte();
        this.skipValue(tag);
    }

    private void skipValue(byte componentTag) {
        switch (componentTag) {
            case 64: {
                this.skipAnnotation();
                break;
            }
            case 91: {
                int count = this.nextChar();
                for (int i = 0; i < count; ++i) {
                    this.skipComponentValue();
                }
                break;
            }
            case 101: {
                this.bp += 4;
                break;
            }
            default: {
                this.bp += 2;
            }
        }
    }

    private ClassAnnotation[] readAnnotations(ClassAnnotation[] oldArray) {
        int oldCount;
        int count;
        if (oldArray == null) {
            oldArray = EMPTY_ANNOTATION_ARRAY;
        }
        ClassAnnotation[] newArray = (count = (oldCount = oldArray.length) + this.nextChar()) > 0 ? new ClassAnnotation[count] : EMPTY_ANNOTATION_ARRAY;
        if (oldCount > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        }
        for (int i = oldCount; i < count; ++i) {
            newArray[i] = new ClassAnnotation();
        }
        return newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAttributes(int targetBp) {
        ClassFile classFile = this;
        synchronized (classFile) {
            int savedBp = this.bp;
            try {
                this.bp = targetBp;
                int attrCount = this.nextChar();
                for (int i = 0; i < attrCount; ++i) {
                    char attrIndex = this.nextChar();
                    int attrLen = this.nextInt();
                    int attrSavedBp = this.bp;
                    Name attrName = this.readPoolName(attrIndex);
                    System.out.println("  '" + attrName + "' (" + attrLen + ')');
                    if (attrLen > 0) {
                        System.out.print("    ");
                        for (int j = 0; j < attrLen; ++j) {
                            if (j > 0 && j % 24 == 0) {
                                System.out.println();
                                System.out.print("    ");
                            }
                            int ii = this.nextByte();
                            System.out.print(ClassFile.x(ii &= 0xFF, 2) + ' ');
                        }
                        System.out.println();
                        this.dumpAttribute(attrName, attrSavedBp);
                    }
                    this.bp = attrSavedBp + attrLen;
                }
            }
            finally {
                this.bp = savedBp;
            }
        }
    }

    private void dumpAttribute(Name attrName, int targetBp) {
        this.bp = targetBp;
        byte attribute = ClassFile.name2attribute(attrName);
        switch (attribute) {
            case 15: 
            case 16: {
                this.dumpAttribute_Name();
                break;
            }
            case 7: {
                this.dumpInnerClasses();
            }
        }
    }

    private void dumpInnerClasses() {
        int count = this.nextChar();
        NameType[] preliminary = new NameType[count];
        boolean actual = false;
        while (count-- > 0) {
            NameType inner = this.readPoolClass(this.nextChar());
            NameType outer = this.readPoolClass(this.nextChar());
            System.out.println("      Inner name: " + inner);
            System.out.println("      Outer name: " + outer);
            char unknown = this.nextChar();
            System.out.println("      <unknown>: " + ClassFile.x(unknown, 4));
            char flags = this.nextChar();
            System.out.println("      Modifiers: " + ClassFile.x(flags, 4));
            System.out.println();
        }
    }

    private void dumpAttribute_Name() {
        Name name = this.readPoolName(this.nextChar());
        System.out.println("      \"" + name + "\"");
        System.out.println();
    }

    private static String x(int i, int width) {
        String s = Integer.toHexString(i);
        while (s.length() < width) {
            s = '0' + s;
        }
        return s;
    }

    private void fileError(String msg) {
        String filename = this.url != null ? this.url.getPath() : "";
        String finalMessage = filename.trim().length() > 0 ? msg + " in file " + filename : msg;
        throw new RuntimeException(finalMessage);
    }

    static {
        Name name;
        int i;
        EMPTY_FIELD_ARRAY = new ClassField[0];
        EMPTY_METHOD_ARRAY = new ClassMethod[0];
        EMPTY_ANNOTATION_ARRAY = new ClassAnnotation[0];
        EMPTY_VALUE_ARRAY = new ComponentValue[0];
        EMPTY_ANNOTATION_ARRAY_ARRAY = new ClassAnnotation[0][];
        int count = 18;
        ATTRIBUTE_names = new Name[18];
        int max = 0;
        for (i = 0; i < 18; ++i) {
            name = NamePool.global.fromString(ATTRIBUTE_words[i]);
            if (max < name.index) {
                max = name.index;
            }
            ClassFile.ATTRIBUTE_names[i] = name;
        }
        ATTRIBUTE_indices = new byte[max + 1];
        for (i = 0; i < 18; ++i) {
            name = ATTRIBUTE_names[i];
            ClassFile.ATTRIBUTE_indices[name.index] = (byte)(i + 1);
        }
        kInitS = NamePool.global.fromString("<init>");
        kClinitS = NamePool.global.fromString("<clinit>");
        kJavaLangObjectS = NamePool.global.fromString("java/lang/Object");
        ___constant_pool = 0;
    }

    final class EnumReference {
        final NameType enumClassname;
        final Name enumName;

        EnumReference(int classIndex, int enumIndex) {
            this.enumClassname = (NameType)ClassFile.this.readPoolConstant(classIndex, 'c');
            this.enumName = ClassFile.this.readPoolName(enumIndex);
        }

        private void dump(PrintStream out) {
            out.print("(Enum) " + this.enumClassname.toString() + '.' + this.enumName);
        }
    }

    final class ComponentValue {
        private final byte tag;
        private final int valueBp;
        private Object value = null;

        private ComponentValue() {
            this.tag = ClassFile.this.nextByte();
            this.valueBp = ClassFile.this.bp;
            ClassFile.this.skipValue(this.tag);
        }

        public final char getComponentTag() {
            return (char)(this.tag & 0xFF);
        }

        public final Object getComponentValue() {
            if (this.value == null) {
                this.value = this.readValue();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object readValue() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.value != null) {
                    return this.value;
                }
                switch (this.tag) {
                    case 101: {
                        char classindex = ClassFile.this.getChar(this.valueBp);
                        char enumindex = ClassFile.this.getChar(this.valueBp + 2);
                        return new EnumReference(classindex, enumindex);
                    }
                    case 91: {
                        int count = ClassFile.this.getChar(this.valueBp);
                        if (count == 0) {
                            return EMPTY_VALUE_ARRAY;
                        }
                        ComponentValue[] values = new ComponentValue[count];
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp + 2;
                            for (int i = 0; i < count; ++i) {
                                values[i] = new ComponentValue();
                            }
                            ComponentValue[] componentValueArray = values;
                            return componentValueArray;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                    case 64: {
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp;
                            ClassAnnotation values = new ClassAnnotation();
                            return values;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                }
                char index = ClassFile.this.getChar(this.valueBp);
                return ClassFile.this.readPoolConstant(index, this.getComponentTag());
            }
        }

        private void dump(PrintStream out) {
            Object o = this.getComponentValue();
            switch (this.tag) {
                case 66: 
                case 67: 
                case 68: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    out.print(o);
                    break;
                }
                case 115: {
                    out.print('\"' + o.toString() + '\"');
                    break;
                }
                case 64: {
                    ClassAnnotation a = (ClassAnnotation)o;
                    a.dump(out);
                    break;
                }
                case 99: {
                    out.print("(Class) " + o.toString());
                    break;
                }
                case 101: {
                    EnumReference e = (EnumReference)o;
                    e.dump(out);
                    break;
                }
                case 91: {
                    CommonUtilities.notImplementedYet();
                }
                default: {
                    CommonUtilities.panic("Unknown component tag: " + this.tag);
                }
            }
        }
    }

    final class ClassAnnotation {
        private final NameType annotationType;
        private final int compBp;
        private String[] componentNames = null;
        private ComponentValue[] componentValues = null;

        private ClassAnnotation() {
            this.annotationType = (NameType)ClassFile.this.readPoolConstant(ClassFile.this.nextChar(), 'c');
            this.compBp = ClassFile.this.bp;
            int count = ClassFile.this.nextChar();
            for (int i = 0; i < count; ++i) {
                ClassFile.this.skipComponent();
            }
        }

        public final NameType getAnnotationType() {
            return this.annotationType;
        }

        public final String[] getComponentNames() {
            if (this.componentNames == null) {
                this.readComponents();
            }
            return this.componentNames;
        }

        public final ComponentValue[] getComponentValues() {
            if (this.componentValues == null) {
                this.readComponents();
            }
            return this.componentValues;
        }

        private final void dump(PrintStream out) {
            String type = this.annotationType.toString();
            String print = type.substring(1, type.length() - 1);
            out.print('@' + print);
            out.print('(');
            this.readComponents();
            int count = this.componentNames.length;
            boolean needComma = false;
            for (int i = 0; i < count; ++i) {
                if (needComma) {
                    out.print(", ");
                }
                out.print(this.componentNames[i] + " = ");
                this.componentValues[i].dump(out);
                needComma = true;
            }
            out.println(')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComponents() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.componentNames != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.compBp;
                    int count = ClassFile.this.nextChar();
                    if (count == 0) {
                        this.componentValues = EMPTY_VALUE_ARRAY;
                        this.componentNames = JavaConstants.EMPTY_STRING_ARRAY;
                    } else {
                        String[] newComponentNames = new String[count];
                        ComponentValue[] newComponentValues = new ComponentValue[count];
                        for (int i = 0; i < count; ++i) {
                            newComponentNames[i] = ClassFile.this.readPoolName(ClassFile.this.nextChar()).toString();
                            newComponentValues[i] = new ComponentValue();
                        }
                        this.componentValues = newComponentValues;
                        this.componentNames = newComponentNames;
                    }
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }
    }

    final class ClassMethod {
        private int thisBp;
        private int modifiers;
        private Name name;
        private String methodDescriptor;
        private String methodSignature;
        private NameType[] exceptions = null;
        private ClassAnnotation[] methodAnnotations = null;
        private ClassAnnotation[][] parameterAnnotations = null;
        private ComponentValue defaultValue = null;

        private ClassMethod() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.readPoolName(ClassFile.this.nextChar());
            this.methodDescriptor = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.modifiers;
        }

        public final String getDescriptor() {
            return this.methodDescriptor;
        }

        public final String getSignature() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.methodSignature;
        }

        public final boolean isClinit() {
            return this.name.index == kClinitS.index;
        }

        public final boolean isConstructor() {
            return this.name.index == kInitS.index;
        }

        public final String getMethodName() {
            return this.name.toString();
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final NameType[] getThrownExceptionTypes() {
            if (this.exceptions == null) {
                this.readMethodAttributes();
            }
            return this.exceptions;
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.methodAnnotations == null) {
                this.readMethodAttributes();
            }
            return this.methodAnnotations;
        }

        public ClassAnnotation[][] getParameterAnnotations() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            if (this.parameterAnnotations != null) {
                return this.parameterAnnotations;
            }
            return null;
        }

        public ComponentValue getDefaultValue() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readMethodAttributes();
            }
            return this.defaultValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMethodAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if ((this.modifiers & Integer.MIN_VALUE) != 0) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.thisBp + 6;
                    int attrCount = ClassFile.this.nextChar();
                    block16: for (int i = 0; i < attrCount; ++i) {
                        Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                        int attrLen = ClassFile.this.nextInt();
                        int attrSavedBp = ClassFile.this.bp;
                        byte attribute = ClassFile.name2attribute(attrName);
                        switch (attribute) {
                            case 4: {
                                this.modifiers |= 0x10000;
                                continue block16;
                            }
                            case 18: {
                                this.modifiers |= 0x20000000;
                                continue block16;
                            }
                            case 15: {
                                this.methodSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                                continue block16;
                            }
                            case 17: {
                                this.modifiers |= 0x1000;
                                continue block16;
                            }
                            case 1: {
                                this.defaultValue = new ComponentValue();
                                continue block16;
                            }
                            case 6: {
                                int exceptionCount = ClassFile.this.nextChar();
                                this.exceptions = new NameType[exceptionCount];
                                for (int j = 0; j < exceptionCount; ++j) {
                                    this.exceptions[j] = ClassFile.this.readPoolClass(ClassFile.this.nextChar());
                                }
                                continue block16;
                            }
                            case 11: 
                            case 13: {
                                this.methodAnnotations = ClassFile.this.readAnnotations(this.methodAnnotations);
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid annotations length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block16;
                            }
                            case 12: 
                            case 14: {
                                int paramCount = ClassFile.this.nextByte();
                                Object array = paramCount > 0 ? new ClassAnnotation[paramCount][] : EMPTY_ANNOTATION_ARRAY_ARRAY;
                                for (int p = 0; p < paramCount; ++p) {
                                    array[p] = this.parameterAnnotations == null ? ClassFile.this.readAnnotations(null) : ClassFile.this.readAnnotations(this.parameterAnnotations[p]);
                                }
                                this.parameterAnnotations = array;
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp != endBp) {
                                    ClassFile.this.fileError("Invalid annotations length");
                                }
                                ClassFile.this.bp = endBp;
                                continue block16;
                            }
                            default: {
                                ClassFile.this.bp += attrLen;
                            }
                        }
                    }
                    if (this.exceptions == null) {
                        this.exceptions = NameType.EMPTY_ARRAY;
                    }
                    if (this.methodAnnotations == null) {
                        this.methodAnnotations = EMPTY_ANNOTATION_ARRAY;
                    }
                    if (ClassFile.this.isDeprecated()) {
                        this.modifiers |= 0x10000;
                    }
                    if (ClassFile.this.isHidden()) {
                        this.modifiers |= 0x20000000;
                    }
                    this.modifiers |= Integer.MIN_VALUE;
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }

        private final void dump(PrintStream out) {
            this.readMethodAttributes();
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.dumpModifiers(out, this.getModifiers(), false, true);
            out.println(this.getMethodName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            NameType[] exceptions = this.getThrownExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                out.println("  throws " + exceptions[i].toString());
            }
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            out.println();
            ClassFile.this.dumpAttributes(this.thisBp + 6);
        }
    }

    final class ClassField {
        private int thisBp;
        private int modifiers;
        private String name;
        private String fieldDescriptor;
        private String fieldSignature;
        private int constantValueIndex = -1;
        private ClassAnnotation[] fieldAnnotations = null;

        private ClassField() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.readPoolName(ClassFile.this.nextChar()).toString();
            this.fieldDescriptor = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        public final int getModifiers() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return this.modifiers;
        }

        public final String getFieldName() {
            return this.name;
        }

        public final String getDescriptor() {
            return this.fieldDescriptor;
        }

        public final String getSignature() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return this.fieldSignature;
        }

        public final boolean isDeprecated() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public final boolean isHidden() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public final Object getConstantValue() {
            if ((this.modifiers & Integer.MIN_VALUE) == 0) {
                this.readFieldAttributes();
            }
            if (this.constantValueIndex < 0) {
                return null;
            }
            int descriptor = this.fieldDescriptor.charAt(0);
            if (descriptor == 76 && this.fieldDescriptor.equals("Ljava/lang/String;")) {
                descriptor = 115;
            }
            return ClassFile.this.readPoolConstant(this.constantValueIndex, (char)descriptor);
        }

        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.fieldAnnotations == null) {
                this.readFieldAttributes();
            }
            return this.fieldAnnotations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFieldAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if ((this.modifiers & Integer.MIN_VALUE) != 0) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                ClassFile.this.bp = this.thisBp + 6;
                int attrCount = ClassFile.this.nextChar();
                block11: for (int i = 0; i < attrCount; ++i) {
                    Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                    int attrLen = ClassFile.this.nextInt();
                    int attrSavedBp = ClassFile.this.bp;
                    byte attribute = ClassFile.name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            continue block11;
                        }
                        case 18: {
                            this.modifiers |= 0x20000000;
                            continue block11;
                        }
                        case 15: {
                            this.fieldSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                            continue block11;
                        }
                        case 17: {
                            this.modifiers |= 0x1000;
                            continue block11;
                        }
                        case 11: 
                        case 13: {
                            this.fieldAnnotations = ClassFile.this.readAnnotations(this.fieldAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (ClassFile.this.bp != endBp) {
                                ClassFile.this.fileError("Invalid annotations length");
                            }
                            ClassFile.this.bp = endBp;
                            continue block11;
                        }
                        case 3: {
                            this.constantValueIndex = ClassFile.this.nextChar();
                            continue block11;
                        }
                        default: {
                            ClassFile.this.bp += attrLen;
                        }
                    }
                }
                if (this.fieldAnnotations == null) {
                    this.fieldAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                if (ClassFile.this.isDeprecated()) {
                    this.modifiers |= 0x10000;
                }
                if (ClassFile.this.isHidden()) {
                    this.modifiers |= 0x20000000;
                }
                this.modifiers |= Integer.MIN_VALUE;
                ClassFile.this.bp = savedBp;
            }
        }

        private final void dump(PrintStream out) {
            this.readFieldAttributes();
            ClassFile.dumpAnnotations(out, this.getDeclaredAnnotations());
            ClassFile.dumpModifiers(out, this.getModifiers(), false, true);
            out.println(this.getFieldName() + ' ' + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                out.println("  signature: " + signature);
            }
            if (this.constantValueIndex > 0) {
                out.print("  constant value: " + this.constantValueIndex + ", ");
                ClassFile.this.dumpPoolObject(out, this.constantValueIndex);
                out.println();
            }
            out.println();
            ClassFile.this.dumpAttributes(this.thisBp + 6);
        }
    }
}

