/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.classfile.ClFile;
import oracle.javatools.parser.java.v2.classfile.ClParser;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.javatools.parser.java.v2.classfile.NameType;
import oracle.javatools.parser.java.v2.common.AbstractAnnotation;
import oracle.javatools.parser.java.v2.common.AbstractClass;
import oracle.javatools.parser.java.v2.common.AbstractElement;
import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.common.AbstractMethod;
import oracle.javatools.parser.java.v2.common.AbstractType;
import oracle.javatools.parser.java.v2.common.AbstractVariable;
import oracle.javatools.parser.java.v2.common.AnnotationComponents;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.util.NullProvider;

public class ClClass
extends AbstractClass {
    private static final List kEmptyList = Collections.EMPTY_LIST;
    final JavaProvider provider;
    private final ClassFile classFile;
    private final JavaFile javaFile;
    protected Collection annotations;
    protected Map<String, ClTypeParameter> typeParameters = Collections.emptyMap();
    protected SignatureHasType superclass = null;
    protected Collection interfaceTypes = null;
    private Collection interfaces;
    private Collection<UnresolvedType> unresolvedInterfaces;
    private Map<String, List<ClMethod>> methods;
    private Collection constructors;
    private ClMethod clinitMethod;
    private Map<String, ClField> fields;
    private Map<String, JavaClass> classes;
    private JavaClass cachedOwningClass = this;
    private SourceClass sourceClass = null;
    private SourceElement sourceElement;

    public ClClass(ClassFile classFile, JavaProvider provider) {
        this.classFile = classFile;
        if (provider != null) {
            this.provider = provider;
        } else {
            this.provider = NullProvider.getInstance();
            new NullPointerException("Null provider").printStackTrace();
        }
        this.javaFile = new ClFile(this, classFile.getURL());
        String signature = classFile.getSignature();
        if (signature != null) {
            this.parseSignature(signature);
            if (this.interfaceTypes == null) {
                this.interfaces = kEmptyCollection;
            }
        } else {
            NameType nameType = classFile.getBaseClass();
            if (nameType != null) {
                this.superclass = new SignatureHasType('L', nameType.toString(), provider);
            }
        }
    }

    private void parseSignature(String signature) {
        ClParser parser = new ClParser(signature, this);
        parser.parseClassSignature0(this);
    }

    final ClassFile getClassFile() {
        return this.classFile;
    }

    @Override
    public JavaFile getFile() {
        return this.javaFile;
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        String qualifiedName = this.getQualifiedName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    @Override
    public String getSignature() {
        String signature = this.classFile.getSignature();
        if (signature != null) {
            return signature;
        }
        return super.getSignature();
    }

    @Override
    public boolean isInterface() {
        return (this.classFile.getModifiers() & 0x200) != 0;
    }

    @Override
    public String getQualifiedName() {
        JavaClass outerClass;
        String vmName = this.getVMName();
        int lastDollar = vmName.indexOf(36);
        if (lastDollar != -1 && (outerClass = this.getOwningClass()) != null) {
            String prefix = outerClass.getQualifiedName();
            int prefixLength = prefix.length();
            return prefix + '.' + vmName.substring(prefixLength + 1);
        }
        return vmName.replace('/', '.');
    }

    @Override
    public String getVMName() {
        return this.classFile.getFullClassName();
    }

    @Override
    public JavaPackage getPackage() {
        return this.provider.getPackage(this.getPackageName());
    }

    @Override
    public String getPackageName() {
        JavaClass owningClass = this.getOwningClass();
        if (owningClass != null) {
            return owningClass.getPackageName();
        }
        String qualifiedName = this.getQualifiedName();
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return "";
    }

    @Override
    public boolean hasTypeParameters() {
        return !this.typeParameters.isEmpty();
    }

    @Override
    public Collection getTypeParameters() {
        return this.copyCollection(this.typeParameters.values());
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.typeParameters.get(name);
    }

    @Override
    public JavaType getSuperclass() {
        if (this.superclass != null) {
            return this.superclass.getResolvedType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getInterfaces() {
        if (this.interfaces == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.interfaces == null) {
                    if (this.interfaceTypes != null) {
                        ArrayList<JavaType> list = new ArrayList<JavaType>();
                        ArrayList<UnresolvedType> unresolvedList = new ArrayList<UnresolvedType>();
                        for (SignatureHasType clType : this.interfaceTypes) {
                            JavaType type = clType.getResolvedType();
                            if (type != null) {
                                list.add(type);
                            }
                            unresolvedList.add(clType.getUnresolvedType());
                        }
                        this.interfaces = list;
                        this.unresolvedInterfaces = unresolvedList.isEmpty() ? kEmptyCollection : unresolvedList;
                        this.interfaceTypes = null;
                    } else {
                        NameType[] things = this.classFile.getBaseInterfaces();
                        int thingCount = things.length;
                        if (thingCount == 0) {
                            this.interfaces = kEmptyCollection;
                            this.unresolvedInterfaces = kEmptyCollection;
                        } else {
                            ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                            ArrayList<UnresolvedType> unresolvedList = new ArrayList<UnresolvedType>();
                            for (int i = 0; i < thingCount; ++i) {
                                NameType thing = things[i];
                                if (thing == null) continue;
                                JavaClass type = this.provider.getClassByVMName(things[i].toString());
                                if (type != null) {
                                    list.add(type);
                                }
                                unresolvedList.add(QuickUnresolvedType.createUnresolvedType(thing.toString()));
                            }
                            this.interfaces = list;
                            Collection<UnresolvedType> collection = this.unresolvedInterfaces = unresolvedList.isEmpty() ? kEmptyCollection : unresolvedList;
                        }
                    }
                    if (this.interfaces.isEmpty()) {
                        this.interfaces = kEmptyCollection;
                    }
                }
            }
        }
        return this.interfaces;
    }

    @Override
    public JavaField getDeclaredField(String name) {
        this.loadDeclaredFields();
        return this.fields.get(name);
    }

    @Override
    public Collection getDeclaredFields() {
        this.loadDeclaredFields();
        return this.copyCollection(this.fields.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredFields() {
        if (this.fields == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.fields == null) {
                    ClassFile.ClassField[] things = this.classFile.getDeclaredFields();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.fields = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, ClField> list = new LinkedHashMap<String, ClField>();
                        for (int i = 0; i < thingCount; ++i) {
                            ClassFile.ClassField thing = things[i];
                            if ((thing.getModifiers() & 0x1000) != 0) continue;
                            ClField field = new ClField(thing);
                            list.put(field.getName(), field);
                        }
                        this.fields = list;
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods() {
        this.loadDeclaredMethods();
        ArrayList<ClMethod> copy = new ArrayList<ClMethod>();
        for (List<ClMethod> list : this.methods.values()) {
            copy.addAll(list);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredMethods() {
        if (this.methods == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.methods == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredMethods();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.methods = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, List<ClMethod>> methodMap = new LinkedHashMap<String, List<ClMethod>>();
                        for (int i = 0; i < thingCount; ++i) {
                            ClassFile.ClassMethod thing = things[i];
                            if (thing.getMethodName().startsWith("access$") || (thing.getModifiers() & 0x1000) != 0) continue;
                            ClMethod clMethod = new ClMethod(thing);
                            ArrayList<ClMethod> clMethods = (ArrayList<ClMethod>)methodMap.get(clMethod.getName());
                            if (clMethods == null) {
                                clMethods = new ArrayList<ClMethod>();
                                methodMap.put(clMethod.getName(), clMethods);
                            }
                            clMethods.add(clMethod);
                        }
                        this.methods = methodMap;
                    }
                    ClassFile.ClassMethod clinit = this.classFile.getClinitMethod();
                    if (clinit != null) {
                        this.clinitMethod = new ClMethod(clinit);
                    }
                }
            }
        }
    }

    @Override
    public Collection getDeclaredMethods(String name) {
        this.loadDeclaredMethods();
        return this.copyCollection((Collection)this.methods.get(name));
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] targetTypes) {
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        Collection methods = this.getDeclaredMethods(name);
        for (JavaMethod thing : methods) {
            if (!CommonUtilities.matchMethod(thing, targetTypes)) continue;
            return thing;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredConstructors() {
        if (this.constructors == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.constructors == null) {
                    ClassFile.ClassMethod[] things = this.classFile.getDeclaredConstructors();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.constructors = kEmptyCollection;
                    } else {
                        ArrayList<ClMethod> list = new ArrayList<ClMethod>();
                        for (int i = 0; i < thingCount; ++i) {
                            list.add(new ClMethod(things[i]));
                        }
                        this.constructors = list;
                    }
                }
            }
        }
        return this.constructors;
    }

    @Override
    public JavaMethod getClinitMethod() {
        this.getDeclaredMethods();
        return this.clinitMethod;
    }

    @Override
    public Collection getDeclaredClasses() {
        this.loadDeclaredClasses();
        return this.copyCollection(this.classes.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeclaredClasses() {
        if (this.classes == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.classes == null) {
                    NameType[] things = this.classFile.getDeclaredInnerClasses();
                    int thingCount = things.length;
                    if (thingCount == 0) {
                        this.classes = Collections.emptyMap();
                    } else {
                        LinkedHashMap<String, JavaClass> list = new LinkedHashMap<String, JavaClass>();
                        for (int i = 0; i < thingCount; ++i) {
                            JavaClass member = this.getInnerClassByVMName(things[i].toString());
                            if (member == null) continue;
                            list.put(member.getName(), member);
                        }
                        this.classes = !list.isEmpty() ? list : Collections.emptyMap();
                    }
                }
            }
        }
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        this.loadDeclaredClasses();
        return this.classes.get(name);
    }

    @Override
    public JavaClass getOwningClass() {
        if (this.cachedOwningClass == this) {
            NameType nameType = this.classFile.getOuterClass();
            this.cachedOwningClass = nameType != null ? this.provider.getClassByVMName(nameType.toString()) : null;
        }
        return this.cachedOwningClass;
    }

    @Override
    public JavaElement getOwner() {
        JavaClass type = this.getOwningClass();
        if (type != null) {
            return type;
        }
        return this.getPackage();
    }

    @Override
    public boolean isDeprecated() {
        return this.classFile.isDeprecated();
    }

    @Override
    public boolean isHidden() {
        return this.classFile.isHidden();
    }

    @Override
    public int getModifiers() {
        return this.classFile.getModifiers();
    }

    public void setSourceElement(SourceElement input) {
        this.sourceClass = (SourceClass)input;
    }

    @Override
    public SourceElement getSourceElement() {
        if (this.sourceClass != null) {
            return this.sourceClass;
        }
        if (this.sourceElement == null) {
            this.sourceElement = this.getSourceClass(this.classFile.getSourceFilename());
        }
        return this.sourceElement;
    }

    @Override
    public URL getURL() {
        return this.classFile.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getDeclaredAnnotations() {
        if (this.annotations == null) {
            ClClass clClass = this;
            synchronized (clClass) {
                if (this.annotations == null) {
                    ClassFile.ClassAnnotation[] things = this.classFile.getDeclaredAnnotations();
                    this.annotations = this.createAnnotations(this, things);
                }
            }
        }
        return this.annotations;
    }

    @Override
    public void clearCompiledInfo() {
        super.clearCompiledInfo();
        this.interfaces = null;
        this.sourceClass = null;
        this.annotations = null;
        for (AbstractElement thing : this.getTypeParameters()) {
            ((ClTypeParameter)thing).clearCompiledInfo();
        }
        for (AbstractElement thing : this.getDeclaredMethods()) {
            ((ClMethod)thing).clearCompiledInfo();
        }
        Iterator iterator = this.getDeclaredFields().iterator();
        while (iterator.hasNext()) {
            ((ClField)iterator.next()).clearCompiledInfo();
        }
        iterator = this.getDeclaredClasses().iterator();
        while (iterator.hasNext()) {
            ((JavaClass)iterator.next()).clearCompiledInfo();
        }
    }

    protected SourceClass getSourceClass(String sourceFileNameHint) {
        return this.provider.getSourceClass(this.getQualifiedName());
    }

    protected JavaClass getInnerClassByVMName(String fqInnerVMName) {
        JavaClass inner = this.provider.getClassByVMName(fqInnerVMName);
        return inner;
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        if (this.interfaces == null) {
            this.getInterfaces();
        }
        return this.unresolvedInterfaces != null ? this.unresolvedInterfaces : kEmptyCollection;
    }

    private Object readComponentValue(ClassFile.ComponentValue value, JavaElement owner) {
        Object o = value.getComponentValue();
        char ch = value.getComponentTag();
        switch (ch) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return o;
            }
            case 's': {
                if (o != null) {
                    return o.toString();
                }
                return null;
            }
            case 'c': {
                NameType cNameType = (NameType)o;
                return this.nameType2signatureHasType(cNameType).getResolvedType();
            }
            case 'e': {
                ClassFile.EnumReference e = (ClassFile.EnumReference)o;
                JavaType type = this.nameType2signatureHasType(e.enumClassname).getResolvedType();
                if (type != null) {
                    return type.getDeclaredField(e.enumName.toString());
                }
                return null;
            }
            case '@': {
                ClassFile.ClassAnnotation a = (ClassFile.ClassAnnotation)o;
                return new ClAnnotation(owner, a);
            }
            case '[': {
                ClassFile.ComponentValue[] values = (ClassFile.ComponentValue[])o;
                int count = values.length;
                if (count == 0) {
                    return EMPTY_OBJECT_ARRAY;
                }
                Object[] things = new Object[count];
                for (int i = 0; i < count; ++i) {
                    things[i] = this.readComponentValue(values[i], owner);
                }
                return things;
            }
        }
        CommonUtilities.panic("Unknown component tag: " + ch);
        return null;
    }

    private Collection createAnnotations(JavaHasAnnotations owner, ClassFile.ClassAnnotation[] things) {
        int thingCount = things.length;
        if (thingCount == 0) {
            return kEmptyCollection;
        }
        JavaAnnotation[] array = new JavaAnnotation[thingCount];
        for (int i = 0; i < thingCount; ++i) {
            array[i] = new ClAnnotation(owner, things[i]);
        }
        return Arrays.asList(array);
    }

    private SignatureHasType nameType2signatureHasType(NameType nameType) {
        String lnameString = nameType.toString();
        int len = lnameString.length();
        if (len == 1) {
            return new SignatureHasType(lnameString.charAt(0), this.provider);
        }
        String name = lnameString.substring(1, len - 1);
        return new SignatureHasType('L', name, this.provider);
    }

    private static void errorMalformed(String message) {
        CommonUtilities.panic(message);
    }

    private <T> List<T> copyCollection(Collection<T> original) {
        if (original == null) {
            return Collections.emptyList();
        }
        ArrayList<T> copy = new ArrayList<T>(original.size());
        for (T member : original) {
            copy.add(member);
        }
        return copy;
    }

    protected class ClAnnotation
    extends AbstractAnnotation
    implements JavaAnnotation {
        private final JavaElement owner;
        private final ClassFile.ClassAnnotation thing;
        private final SignatureHasType annotationType;
        private AnnotationComponents components = null;
        private SourceElement sourceElement;

        protected ClAnnotation(JavaElement owner, ClassFile.ClassAnnotation thing) {
            this.owner = owner;
            this.thing = thing;
            this.annotationType = ClClass.this.nameType2signatureHasType(thing.getAnnotationType());
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        @Override
        public int getElementKind() {
            return 2;
        }

        @Override
        public JavaElement getOwner() {
            return this.owner;
        }

        @Override
        public SourceElement getSourceElement() {
            if (this.sourceElement == null) {
                SourceElement ownerSource = this.owner.getSourceElement();
                if (ownerSource == null) {
                    return null;
                }
                SourceHasModifiers ownerElement = (SourceHasModifiers)ownerSource;
                this.sourceElement = CommonUtilities.getSourceElement(this, ownerElement);
            }
            return this.sourceElement;
        }

        @Override
        public JavaType getResolvedType() {
            return this.annotationType.getResolvedType();
        }

        @Override
        public Map getArguments() {
            return InternalUtilities.getAnnotationArguments(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getComponents() {
            if (this.components == null) {
                ClAnnotation clAnnotation = this;
                synchronized (clAnnotation) {
                    if (this.components == null) {
                        try {
                            String[] names;
                            int count;
                            AnnotationComponents map = AnnotationComponents.createInstance(this.getResolvedType());
                            if (map != null && (count = (names = this.thing.getComponentNames()).length) > 0) {
                                ClassFile.ComponentValue[] values = this.thing.getComponentValues();
                                for (int i = 0; i < count; ++i) {
                                    Object value = ClClass.this.readComponentValue(values[i], this);
                                    if (value == null) continue;
                                    map.assignValue(names[i], value);
                                }
                            }
                            this.components = map;
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            }
            return this.components;
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.annotationType.getUnresolvedType();
        }
    }

    protected class ClTypeParameter
    extends AbstractType
    implements JavaTypeVariable {
        private final JavaIsGeneric owner;
        private final String name;
        protected SignatureHasType superclassBound = null;
        protected List interfaceBounds = ClClass.access$700();
        private JavaType[] resolvedInterfaces = null;
        private JavaType[] resolvedBounds = null;

        protected ClTypeParameter(JavaIsGeneric owner, String name) {
            this.owner = owner;
            this.name = name;
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        @Override
        public String getTypeSignature() {
            return CommonUtilities.getTypeSignature(this);
        }

        @Override
        public String getDescriptor() {
            return CommonUtilities.getDescriptor(this);
        }

        @Override
        public String getUniqueIdentifier() {
            return CommonUtilities.getUniqueIdentifier(this);
        }

        @Override
        public String getQualifiedName() {
            return this.getName();
        }

        @Override
        public String getVMName() {
            return this.getName();
        }

        @Override
        public int getElementKind() {
            return 10;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JavaElement getOwner() {
            return this.owner;
        }

        @Override
        public JavaMember getOwningMember() {
            return this.owner;
        }

        @Override
        public JavaClass getTypeErasure() {
            return CommonUtilities.getTypeErasure(this);
        }

        @Override
        public JavaType getSuperclass() {
            JavaType resolved;
            if (this.superclassBound != null && (resolved = this.superclassBound.getResolvedType()) != null) {
                return resolved;
            }
            return ClClass.this.provider.getClassByVMName("java/lang/Object");
        }

        @Override
        public Collection getInterfaces() {
            JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
            if (resolvedInterfaces.length > 0) {
                return Arrays.asList(resolvedInterfaces);
            }
            return kEmptyCollection;
        }

        @Override
        public Collection getBounds() {
            JavaType[] resolvedBounds = this.getResolvedBounds();
            if (resolvedBounds.length > 0) {
                return Arrays.asList(resolvedBounds);
            }
            return kEmptyCollection;
        }

        @Override
        public void clearCompiledInfo() {
            super.clearCompiledInfo();
            ClClass.this.interfaces = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaType[] getResolvedInterfaces() {
            if (this.resolvedInterfaces == null) {
                ClTypeParameter clTypeParameter = this;
                synchronized (clTypeParameter) {
                    if (this.resolvedInterfaces == null) {
                        ArrayList<JavaType> list = kEmptyList;
                        if (this.interfaceBounds != null && !this.interfaceBounds.isEmpty()) {
                            list = new ArrayList<JavaType>();
                            for (SignatureHasType clType : this.interfaceBounds) {
                                JavaType type = clType.getResolvedType();
                                if (type == null) continue;
                                list.add(type);
                            }
                        }
                        this.resolvedInterfaces = list.isEmpty() ? JavaType.EMPTY_ARRAY : list.toArray(new JavaType[list.size()]);
                    }
                }
            }
            return this.resolvedInterfaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaType[] getResolvedBounds() {
            if (this.resolvedBounds == null) {
                ClTypeParameter clTypeParameter = this;
                synchronized (clTypeParameter) {
                    if (this.resolvedBounds == null) {
                        JavaType type;
                        JavaType[] resolvedInterfaces = this.getResolvedInterfaces();
                        if (this.superclassBound != null && (type = this.superclassBound.getResolvedType()) != null) {
                            int count = resolvedInterfaces.length;
                            JavaType[] newArray = new JavaType[count + 1];
                            newArray[0] = type;
                            System.arraycopy(resolvedInterfaces, 0, newArray, 1, count);
                            this.resolvedBounds = newArray;
                        }
                        if (this.resolvedBounds == null) {
                            this.resolvedBounds = resolvedInterfaces;
                        }
                    }
                }
            }
            return this.resolvedBounds;
        }
    }

    protected class ClMethod
    extends AbstractMethod {
        private final ClassFile.ClassMethod thing;
        protected Collection annotations;
        protected Map<String, ClTypeParameter> typeParameters = Collections.emptyMap();
        protected SignatureHasType returnType;
        protected Collection formalParameters = kEmptyCollection;
        protected Collection exceptionTypes = null;
        private Collection exceptions;
        private Object value = null;
        private SourceElement sourceElement;

        private ClMethod(ClassFile.ClassMethod thing) {
            this.thing = thing;
            String signature = thing.getSignature();
            if (signature != null) {
                if (thing.isConstructor() && this.getOwningClass().isMemberClass() && !this.getOwningClass().isStatic()) {
                    this.parseSignature(thing.getDescriptor());
                    Collection paramsFromDescriptor = this.formalParameters;
                    this.parseSignature(signature);
                    ArrayList finalParams = new ArrayList();
                    Iterator descriptorParamIter = paramsFromDescriptor.iterator();
                    for (int diff = paramsFromDescriptor.size() - this.formalParameters.size(); diff > 0; --diff) {
                        finalParams.add(descriptorParamIter.next());
                    }
                    Iterator signatureParamIter = this.formalParameters.iterator();
                    while (signatureParamIter.hasNext()) {
                        finalParams.add(signatureParamIter.next());
                    }
                    this.formalParameters = finalParams;
                } else {
                    this.parseSignature(signature);
                }
            } else {
                String descriptor = thing.getDescriptor();
                this.parseSignature(descriptor);
            }
        }

        private void parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this, this);
            parser.parseMethodTypeSignature0(this);
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        final ClassFile.ClassMethod getClassMethod() {
            return this.thing;
        }

        @Override
        public boolean isConstructor() {
            return this.thing.isConstructor();
        }

        @Override
        public JavaType getResolvedType() {
            return this.returnType.getResolvedType();
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.returnType.getUnresolvedType();
        }

        @Override
        public String getName() {
            return this.thing.getMethodName();
        }

        @Override
        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        @Override
        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        @Override
        public boolean hasTypeParameters() {
            return !this.typeParameters.isEmpty();
        }

        @Override
        public Collection getTypeParameters() {
            return this.typeParameters.values();
        }

        @Override
        public JavaTypeVariable getTypeParameter(String name) {
            return this.typeParameters.get(name);
        }

        @Override
        public Collection getParameters() {
            return this.formalParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getExceptions() {
            if (this.exceptions == null) {
                ClMethod clMethod = this;
                synchronized (clMethod) {
                    if (this.exceptions == null) {
                        if (this.exceptionTypes != null) {
                            ArrayList<JavaType> list = new ArrayList<JavaType>();
                            for (SignatureHasType clType : this.exceptionTypes) {
                                JavaType type = clType.getResolvedType();
                                if (type == null) continue;
                                list.add(type);
                            }
                            this.exceptions = list;
                            this.exceptionTypes = null;
                        } else {
                            NameType[] things = this.thing.getThrownExceptionTypes();
                            int thingCount = things.length;
                            if (thingCount == 0) {
                                this.exceptions = kEmptyCollection;
                            } else {
                                ArrayList<JavaClass> list = new ArrayList<JavaClass>();
                                for (int i = 0; i < thingCount; ++i) {
                                    JavaClass type = ClClass.this.provider.getClassByVMName(things[i].toString());
                                    if (type == null) continue;
                                    list.add(type);
                                }
                                this.exceptions = list;
                            }
                        }
                        if (this.exceptions.isEmpty()) {
                            this.exceptions = kEmptyCollection;
                        }
                    }
                }
            }
            return this.exceptions;
        }

        @Override
        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        @Override
        public boolean isHidden() {
            return this.thing.isHidden();
        }

        @Override
        public int getModifiers() {
            return this.thing.getModifiers();
        }

        @Override
        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        @Override
        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        @Override
        public SourceElement getSourceElement() {
            if (this.sourceElement == null) {
                SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
                this.sourceElement = CommonUtilities.getSourceElement(this, sourceClass);
            }
            return this.sourceElement;
        }

        @Override
        public Object getDefaultValue() {
            ClassFile.ComponentValue cv;
            if (this.value == null && (cv = this.thing.getDefaultValue()) != null) {
                this.value = ClClass.this.readComponentValue(cv, this);
            }
            return this.value;
        }

        @Override
        public void clearCompiledInfo() {
            this.exceptions = null;
            this.annotations = null;
            this.value = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClMethod clMethod = this;
                synchronized (clMethod) {
                    if (this.annotations == null) {
                        ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                        this.annotations = ClClass.this.createAnnotations(this, things);
                    }
                }
            }
            return this.annotations;
        }

        protected class ClVariable
        extends AbstractVariable
        implements JavaLocalVariable {
            private final SignatureHasType type;
            private final int index;
            private Collection annotations;
            private SourceElement sourceElement;

            protected ClVariable(SignatureHasType type, int index) {
                this.type = type;
                this.index = index;
            }

            @Override
            public JavaFile getFile() {
                return ClClass.this.javaFile;
            }

            @Override
            public int getElementKind() {
                return 7;
            }

            @Override
            public JavaType getResolvedType() {
                return this.type.getResolvedType();
            }

            @Override
            public UnresolvedType getUnresolvedType() {
                return this.type.getUnresolvedType();
            }

            @Override
            public String getName() {
                SourceVariable var = (SourceVariable)this.getSourceElement();
                if (var != null) {
                    return var.getName();
                }
                return "";
            }

            @Override
            public JavaElement getOwner() {
                return ClMethod.this;
            }

            @Override
            public int getModifiers() {
                if (ClMethod.this.isVarargs() && this.index == ClMethod.this.formalParameters.size() - 1) {
                    return 128;
                }
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection getDeclaredAnnotations() {
                if (this.annotations == null) {
                    ClVariable clVariable = this;
                    synchronized (clVariable) {
                        if (this.annotations == null) {
                            ClassFile.ClassAnnotation[][] allThings = ClMethod.this.thing.getParameterAnnotations();
                            if (allThings != null && allThings.length > 0) {
                                try {
                                    ClassFile.ClassAnnotation[] things = allThings[this.index];
                                    this.annotations = ClClass.this.createAnnotations(this, things);
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    URL url = ClClass.this.classFile.getURL();
                                    if (url != null) {
                                        new RuntimeException(url.toString(), e).printStackTrace();
                                    }
                                    e.printStackTrace();
                                }
                            }
                            if (this.annotations == null) {
                                this.annotations = kEmptyList;
                            }
                        }
                    }
                }
                return this.annotations;
            }

            @Override
            public SourceElement getSourceElement() {
                if (this.sourceElement == null) {
                    SourceMethod sourceMethod = (SourceMethod)ClMethod.this.getSourceElement();
                    if (sourceMethod == null) {
                        return null;
                    }
                    List parameters = sourceMethod.getSourceParameters();
                    if (parameters.size() <= this.index) {
                        return null;
                    }
                    this.sourceElement = (SourceElement)parameters.get(this.index);
                }
                return this.sourceElement;
            }
        }
    }

    private class ClField
    extends AbstractField {
        private ClassFile.ClassField thing;
        protected Collection annotations;
        private SignatureHasType type;
        private SourceElement sourceElement;

        private ClField(ClassFile.ClassField thing) {
            this.thing = thing;
            String signature = thing.getSignature();
            this.type = signature != null ? this.parseSignature(signature) : this.parseSignature(thing.getDescriptor());
        }

        private SignatureHasType parseSignature(String signature) {
            ClParser parser = new ClParser(signature, ClClass.this);
            return (SignatureHasType)parser.parseTypeSignature0();
        }

        @Override
        public JavaFile getFile() {
            return ClClass.this.javaFile;
        }

        final ClassFile.ClassField getClassField() {
            return this.thing;
        }

        @Override
        public JavaType getResolvedType() {
            return this.type.getResolvedType();
        }

        @Override
        public UnresolvedType getUnresolvedType() {
            return this.type.getUnresolvedType();
        }

        @Override
        public String getName() {
            return this.thing.getFieldName();
        }

        @Override
        public JavaClass getOwningClass() {
            return ClClass.this;
        }

        @Override
        public JavaElement getOwner() {
            return this.getOwningClass();
        }

        @Override
        public String getDescriptor() {
            return this.thing.getDescriptor();
        }

        @Override
        public String getSignature() {
            String signature = this.thing.getSignature();
            if (signature != null) {
                return signature;
            }
            return this.getDescriptor();
        }

        @Override
        public boolean isDeprecated() {
            return this.thing.isDeprecated();
        }

        @Override
        public boolean isHidden() {
            return this.thing.isHidden();
        }

        @Override
        public int getModifiers() {
            return this.thing.getModifiers();
        }

        @Override
        public SourceElement getSourceElement() {
            if (this.sourceElement == null) {
                SourceClass sourceClass = (SourceClass)ClClass.this.getSourceElement();
                this.sourceElement = CommonUtilities.getSourceElement(this, sourceClass);
            }
            return this.sourceElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection getDeclaredAnnotations() {
            if (this.annotations == null) {
                ClField clField = this;
                synchronized (clField) {
                    if (this.annotations == null) {
                        ClassFile.ClassAnnotation[] things = this.thing.getDeclaredAnnotations();
                        this.annotations = ClClass.this.createAnnotations(this, things);
                    }
                }
            }
            return this.annotations;
        }

        @Override
        public Object getConstantValue() {
            if (this.isEnumConstant()) {
                return this;
            }
            if (this.isFinal() && this.isStatic()) {
                return this.thing.getConstantValue();
            }
            return null;
        }

        @Override
        public void clearCompiledInfo() {
            this.annotations = null;
        }
    }
}

