/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v1.symbol;

import java.util.ArrayList;
import oracle.javatools.parser.java.v1.symbol.CatchClause;
import oracle.javatools.parser.java.v1.symbol.ClassBodySymbol;
import oracle.javatools.parser.java.v1.symbol.ClassListSymbol;
import oracle.javatools.parser.java.v1.symbol.CodeElement;
import oracle.javatools.parser.java.v1.symbol.CommentSymbol;
import oracle.javatools.parser.java.v1.symbol.Commentable;
import oracle.javatools.parser.java.v1.symbol.CreatorExpressionSymbol;
import oracle.javatools.parser.java.v1.symbol.FieldSymbol;
import oracle.javatools.parser.java.v1.symbol.HasModifiers;
import oracle.javatools.parser.java.v1.symbol.InnerClassSymbol;
import oracle.javatools.parser.java.v1.symbol.MemberSymbol;
import oracle.javatools.parser.java.v1.symbol.MethodSymbol;
import oracle.javatools.parser.java.v1.symbol.NameSymbol;
import oracle.javatools.parser.java.v1.symbol.Nameable;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v1.symbol.Scope;
import oracle.javatools.parser.java.v1.symbol.TypeSymbol;
import oracle.javatools.parser.java.v1.symbol.VariableSymbol;

@Deprecated
public class ClassSymbol
extends HasModifiers
implements Commentable,
Nameable,
Scope {
    private CommentSymbol comment = null;
    private NameSymbol name = null;
    private int modifiers = 0;
    private int classIndex;
    private TypeSymbol baseClass;
    private ClassListSymbol baseInterfaces;
    private ClassBodySymbol body;
    private Scope scope;
    static final ClassSymbol[] EMPTY_ARRAY = new ClassSymbol[0];

    public boolean isClass() {
        return this.code == 200 || this.code == 760;
    }

    public NameSymbol getBaseClass() {
        if (this.baseClass == null) {
            return null;
        }
        return this.baseClass.getName();
    }

    public TypeSymbol getBaseClassType() {
        return this.baseClass;
    }

    public ClassBodySymbol getBody() {
        return this.body;
    }

    public NameSymbol[] getBaseInterfaces() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClasses() : NameSymbol.EMPTY_ARRAY;
    }

    public TypeSymbol[] getBaseInterfaceTypes() {
        return this.baseInterfaces != null ? this.baseInterfaces.listClassTypes() : TypeSymbol.EMPTY_ARRAY;
    }

    public MemberSymbol[] getMembers() {
        return this.body.listMembers();
    }

    public MethodSymbol[] getMethods() {
        return this.body.listMethods();
    }

    public FieldSymbol[] getFields() {
        return this.body.listFields();
    }

    public MethodSymbol[] getConstructors() {
        return this.body.listConstructors();
    }

    public InnerClassSymbol[] getInnerClasses() {
        return this.body.listInnerClasses();
    }

    public MemberSymbol[] getInitializers() {
        return this.body.listInitializers();
    }

    public boolean isDeprecated() {
        if (this.comment != null) {
            return this.comment.isDeprecated();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.comment != null) {
            return this.comment.isHidden();
        }
        return false;
    }

    @Override
    public int getScopeType() {
        return 1;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.scope;
    }

    @Override
    public void setEnclosingScope(Scope scope) {
        this.scope = scope;
    }

    @Override
    public boolean findLabel(String name) {
        return false;
    }

    @Override
    public VariableSymbol findVariable(String name) {
        for (FieldSymbol fieldSym : this.getFields()) {
            if (fieldSym == null) continue;
            for (VariableSymbol varSym : fieldSym.getVariables()) {
                if (!ClassSymbol.matches(varSym, name)) continue;
                return varSym;
            }
        }
        return null;
    }

    @Override
    public ClassSymbol findType(String name) {
        InnerClassSymbol[] classSyms = this.getInnerClasses();
        int classCount = classSyms.length;
        for (int i = 0; i < classCount; ++i) {
            ClassSymbol classSym = classSyms[i].getClassDefinition();
            if (!ClassSymbol.matches(classSym, name)) continue;
            return classSym;
        }
        return null;
    }

    @Override
    public NameSymbol[] getLabels() {
        return NameSymbol.EMPTY_ARRAY;
    }

    @Override
    public VariableSymbol[] getVariables() {
        FieldSymbol[] fields = this.getFields();
        ArrayList list = ClassSymbol.allocArrayList();
        for (FieldSymbol field : fields) {
            VariableSymbol[] varSyms;
            if (field == null || (varSyms = field.getVariables()) == null) continue;
            int varCount = varSyms.length;
            for (int v = 0; v < varCount; ++v) {
                VariableSymbol varSym = varSyms[v];
                if (varSym == null) continue;
                list.add(varSym);
            }
        }
        int count = list.size();
        VariableSymbol[] out = count > 0 ? list.toArray(new VariableSymbol[count]) : VariableSymbol.EMPTY_ARRAY;
        ClassSymbol.freeArrayList(list);
        return out;
    }

    @Override
    public ClassSymbol[] getClasses() {
        InnerClassSymbol[] syms = this.getInnerClasses();
        int count = syms.length;
        ClassSymbol[] out = new ClassSymbol[count];
        for (int i = 0; i < count; ++i) {
            InnerClassSymbol sym = syms[i];
            if (sym == null) continue;
            out[i] = sym.getClassDefinition();
        }
        return out;
    }

    @Override
    public CatchClause[] getCatchClauses() {
        return CatchClause.EMPTY_ARRAY;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    ClassSymbol(int code, int index) {
        super(code);
        this.classIndex = index;
    }

    void setBody(ClassBodySymbol body) {
        this.body = body;
    }

    void setBaseClass(TypeSymbol type) {
        this.baseClass = type;
    }

    void setBaseInterfaces(ClassListSymbol interfaces) {
        this.baseInterfaces = interfaces;
    }

    @Override
    void doneParsing() {
        if (this.code == 200 || this.code == 400) {
            this.setModifiers(((HasModifiers)this.parent).getModifiers());
            if (this.parent.code == 280) {
                MemberSymbol memberSym = (MemberSymbol)this.parent;
                this.setComment(memberSym.getComment());
                new InnerClassSymbol(this);
            } else if (this.parent.parent.code == 510) {
                ((CodeElement)this.parent.parent).setClass(this);
                this.body.doneParsingLocalClass(true, this);
            } else {
                this.setComment(((Commentable)((Object)this.parent)).getComment());
                RootSymbol root = (RootSymbol)this.parent.parent;
                root.addClass(this);
            }
        } else if (this.code == 760) {
            ((CreatorExpressionSymbol)this.parent).setClass(this);
        }
    }

    @Override
    public CommentSymbol getComment() {
        return this.comment;
    }

    @Override
    public void setComment(CommentSymbol comment) {
        this.comment = comment;
    }

    @Override
    public NameSymbol getName() {
        return this.name;
    }

    @Override
    public void setName(NameSymbol name) {
        this.name = name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }
}

