/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.GrammarProduction;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.SyntaxListener;
import oracle.javatools.parser.SyntaxStack;
import oracle.javatools.resource.BundleHelper;

public abstract class AbstractSyntaxRecognizer {
    private static final boolean DEBUG_PRINT_STACK_ON_INTERNAL = true;
    private static final int SYNTAX_ERROR_THRESHOLD = 1000;
    private static final int kEofThreshold = 25;
    public static final int SYNTAX_EOF = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int SYNTAX_ROOT = 10;
    public static final int TK_EOF = 0;
    protected int debugLevel = 0;
    public static final boolean DEBUG_OUTPUT = false;
    protected Lexer lexer;
    protected LexerToken curLexerToken;
    protected LexerToken peekingToken;
    protected int curToken;
    private int lastTokenOffset;
    private int lastErrorCheckpoint;
    private int lastErrorOffset;
    protected SyntaxListener listener = null;
    private SyntaxStack stack;
    private GrammarProduction top;
    private int inheritStartOffset = -1;
    private int lastEndOffset = -1;
    private int syntaxErrorCount;
    private int eofCount;
    public static final int DEBUGLEVEL_MINIMAL = 0;
    public static final int DEBUGLEVEL_HIGH = 1;
    protected static final String INTERNALERR_BACKUP_NOT_IMPLEMENTED_YET = "backup() not implemented yet";
    protected static final String INTERNALERR_BACKEDUP_TWICE = "Called prevToken twice";
    protected static final String INTERNALERR_CANT_ACCESS_LEXER_TOKEN_ON_BACKUP = "Can't access the lexer token if we've backed up";
    public static final String SYNTAXERR_SKIPPING;
    private static final String SYNTAXERR_EOF;
    private static final String SYNTAXERR_EXITING;
    private static final String SYNTAXERR_UNEXPECTED;
    private static final String SYNTAXERR_UNIMPLEMENTED;
    protected static final BundleHelper resources;

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void initialize(Lexer lexer) {
        this.stack = new SyntaxStack();
        this.top = this.stack.pushNewGP();
        this.lexer = lexer;
        this.curLexerToken = lexer.createLexerToken();
        this.peekingToken = lexer.createLexerToken();
        this.curToken = lexer.lex(this.curLexerToken);
        this.syntaxErrorCount = 0;
        this.eofCount = 0;
        this.lastTokenOffset = 0;
        this.lastErrorCheckpoint = -1;
        this.lastErrorOffset = -1;
    }

    public void initialize(ReadTextBuffer buffer) {
        Lexer l = this.instantiatePreferredLexer();
        l.setTextBuffer(buffer);
        this.initialize(l);
    }

    public void initialize(ReadTextBuffer buffer, int startOffset) {
        Lexer l = this.instantiatePreferredLexer();
        l.setTextBuffer(buffer);
        l.setPosition(startOffset);
        this.initialize(l);
    }

    public void setListener(SyntaxListener listener) {
        this.listener = listener;
    }

    public abstract void parse();

    public abstract Lexer instantiatePreferredLexer();

    protected int getCode() {
        return this.top.syntaxCode;
    }

    protected int getDataValue() {
        return this.top.data;
    }

    protected void setDataValue(int data) {
        this.top.data = data;
    }

    protected String getContextString() {
        return this.top.contextString;
    }

    protected void setContextString(String contextString) {
        this.top.contextString = contextString;
    }

    protected void copyStartOffset() {
        this.inheritStartOffset = this.top.startOffset;
    }

    protected String curTokenToString() {
        int start = this.curLexerToken.getStartOffset();
        int end = this.curLexerToken.getEndOffset();
        return this.lexer.getTextBuffer().getString(start, end - start);
    }

    private void generateToken() {
        if (this.listener != null) {
            this.listener.receive(this.top, this.top.syntaxCode);
        }
    }

    private void newGrammarProduction(int code, boolean generate) {
        String contextString = this.top.contextString;
        this.top = this.stack.pushNewGP();
        this.top.syntaxCode = code;
        this.top.contextString = contextString;
        if (this.inheritStartOffset >= 0) {
            this.top.startOffset = this.inheritStartOffset;
            this.inheritStartOffset = -1;
        } else {
            this.top.startOffset = this.curLexerToken.getStartOffset();
        }
        if (generate) {
            this.generateToken();
        }
    }

    private void endGrammarProduction(boolean inheritEndOffset) {
        this.top.endOffset = inheritEndOffset ? this.lastEndOffset : this.curLexerToken.getEndOffset();
        this.lastEndOffset = this.top.endOffset;
        this.generateToken();
        this.stack.pop();
        this.top = this.stack.peek();
    }

    private void errorGrammarProduction(String message, int dataValue, boolean useLastTokenOffset) {
        this.startQuiet(1);
        this.setContextString(message);
        this.setDataValue(dataValue);
        if (useLastTokenOffset) {
            this.top.startOffset = this.lastTokenOffset;
            this.top.endOffset = this.lastTokenOffset + 1;
        }
        int current = this.top.startOffset;
        boolean ignoreError = false;
        if (dataValue != 0) {
            ignoreError = current == this.lastErrorOffset;
        } else {
            boolean bl = ignoreError = current <= this.lastErrorOffset;
        }
        if (ignoreError) {
            this.stack.pop();
            this.top = this.stack.peek();
            return;
        }
        this.lastErrorOffset = current;
        if (useLastTokenOffset) {
            this.generateToken();
            this.stack.pop();
            this.top = this.stack.peek();
        } else {
            this.finish();
        }
    }

    protected final int peekToken() {
        int token = this.lexer.lex(this.peekingToken);
        this.lexer.backup();
        return token;
    }

    protected final boolean nextToken(int token) {
        if (this.curToken == token) {
            this.skipToken();
            return true;
        }
        this.errorExpecting(token);
        return false;
    }

    protected final boolean nextToken(int primary, int secondary) {
        if (this.curToken == secondary) {
            this.skipToken();
            return true;
        }
        this.nextToken(primary);
        return false;
    }

    protected final boolean optionalToken(int token) {
        if (this.curToken == token) {
            this.skipToken();
            return true;
        }
        return false;
    }

    protected final void skipToken() {
        if (this.curToken == 0) {
            this.errorEof();
        }
        this.lastTokenOffset = this.curLexerToken.getEndOffset();
        this.curToken = this.lexer.lex(this.curLexerToken);
    }

    protected final void start(int code) {
        this.newGrammarProduction(code, true);
    }

    protected final void startQuiet(int code) {
        this.newGrammarProduction(code, false);
    }

    protected final void finishInherit() {
        this.endGrammarProduction(true);
    }

    protected final void finish() {
        this.endGrammarProduction(false);
    }

    protected final void finishToken() {
        this.endGrammarProduction(false);
        this.skipToken();
    }

    protected final void finishToken(int token) {
        if (this.curToken == token) {
            this.finishToken();
        } else {
            this.errorExpecting(token);
            this.endGrammarProduction(false);
        }
    }

    protected final void finishToken(int primary, int secondary) {
        if (this.curToken == secondary) {
            this.finishToken();
        } else {
            this.finishToken(primary);
        }
    }

    public String _codeToString(int syntaxCode) {
        return "Unknown syntax code ( " + syntaxCode + " )";
    }

    protected final boolean errorCheckpoint() {
        boolean okay;
        int currentCheckpoint = this.top.startOffset;
        boolean bl = okay = this.lastErrorCheckpoint != currentCheckpoint;
        if (!okay) {
            this.errorUnexpected();
        }
        this.lastErrorCheckpoint = currentCheckpoint;
        return okay;
    }

    protected void notImplementedYet(String msg) {
        int argPos = SYNTAXERR_UNIMPLEMENTED.indexOf("{0}");
        if (argPos == -1) {
            this.reportSyntaxError(SYNTAXERR_UNIMPLEMENTED);
        } else {
            StringBuffer buffer = new StringBuffer(SYNTAXERR_UNIMPLEMENTED);
            buffer.replace(argPos, argPos + 3, msg);
            this.reportSyntaxError(buffer.toString());
        }
    }

    protected void errorExpecting(int token) {
        this.reportSyntaxError("Expecting token " + token);
    }

    protected void errorUnexpected() {
        this.errorUnexpected(true);
    }

    protected void errorUnexpected(boolean consumeToken) {
        this.reportSyntaxError(SYNTAXERR_UNEXPECTED);
        if (consumeToken) {
            this.skipToken();
        }
    }

    protected final void errorEof() {
        if (this.eofCount++ > 25) {
            throw new EOFException("SyntaxRecognizer hit EOF");
        }
        this.reportSyntaxError(SYNTAXERR_EOF);
    }

    protected void reportSyntaxError(String errorMsg) {
        this.reportSyntaxError(errorMsg, 0, false);
    }

    protected void reportSyntaxError(String errorMsg, boolean useLastTokenOffset) {
        this.reportSyntaxError(errorMsg, 0, useLastTokenOffset);
    }

    protected void reportSyntaxError(String errorMsg, int dataValue, boolean useLastTokenOffset) {
        String contextString = this.top.contextString;
        String simpleErrorMsg = contextString + ": " + errorMsg;
        String codeString = this._codeToString(this.top.syntaxCode);
        if (this.debugLevel == 0) {
            String fullErrorMsg = "Resolving " + codeString + ":\n\t- " + simpleErrorMsg + "\n\t- Current token is (" + this.curToken + ")";
            throw new RuntimeException(fullErrorMsg);
        }
        this.errorGrammarProduction(simpleErrorMsg, dataValue, useLastTokenOffset);
        ++this.syntaxErrorCount;
        if (1000 < this.syntaxErrorCount) {
            this.startQuiet(1);
            this.setContextString(SYNTAXERR_EXITING);
            this.finish();
            throw new RuntimeException("Hit the max errors. Exiting.");
        }
    }

    protected void internalError(String errorMsg) {
        String codeString = this._codeToString(this.top.syntaxCode);
        String msg = "JavaSyntaxRecognizer internal error, in " + codeString + ": " + errorMsg;
        this.reportSyntaxError(msg);
        RuntimeException e = new RuntimeException(msg);
        e.printStackTrace();
        throw new RuntimeException(msg);
    }

    protected void _assert(boolean condition) {
        if (!condition) {
            this.internalError("assertion fail");
        }
    }

    static {
        resources = new BundleHelper("oracle.javatools.parser.resource.ParserBundle");
        SYNTAXERR_SKIPPING = resources.getString("PARSER_ERROR_SKIPPING");
        SYNTAXERR_EOF = resources.getString("PARSER_ERROR_EOF");
        SYNTAXERR_EXITING = resources.getString("PARSER_ERROR_EXITING");
        SYNTAXERR_UNEXPECTED = resources.getString("PARSER_ERROR_UNEXPECTED");
        SYNTAXERR_UNIMPLEMENTED = resources.getString("PARSER_ERROR_UNIMPLEMENTED");
    }

    private class EOFException
    extends RuntimeException {
        private EOFException(String string) {
            super(string);
        }
    }
}

