/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.logging;

import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class RegexLogFilter
implements Filter {
    private static final String _LOG_ALL = new String();
    private static final String _LOG_NONE = new String();

    @Override
    public boolean isLoggable(LogRecord record) {
        String exp = this._getRegex(record);
        if (exp == _LOG_NONE) {
            return false;
        }
        if (exp == _LOG_ALL) {
            return true;
        }
        String msg = record.getMessage();
        if (msg == null) {
            return false;
        }
        Pattern pat = Pattern.compile(exp, 34);
        boolean match = pat.matcher(msg).matches();
        return match;
    }

    private String _getRegex(LogRecord record) {
        Level level = record.getLevel();
        String name = record.getLoggerName();
        String val = LogManager.getLogManager().getProperty(name + ".regex." + level);
        if (val == null) {
            return _LOG_ALL;
        }
        if (val.length() == 0) {
            return _LOG_NONE;
        }
        return val;
    }
}

