/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.logging;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import oracle.ide.Version;

public final class Diagnostics {
    private static final int BANNER_WIDTH = 79;
    private static final char BANNER_CHAR = '-';
    private static File diagnosticDirectory = new File(System.getProperty("user.home"), "oracleide-diagnostics");
    private static Boolean isOn = null;
    private static Collection<File> lockedFiles = new ArrayList<File>();
    private static boolean installedShutdownHook;
    private static final Object SHUTDOWN_LOCK;

    private Diagnostics() {
    }

    public static File getDiagnosticDirectory() {
        return diagnosticDirectory;
    }

    public static void setDiagnosticDirectory(File diagnosticDirectory) {
        if (!Diagnostics.isOn()) {
            return;
        }
        if (!diagnosticDirectory.isDirectory() && !diagnosticDirectory.mkdirs()) {
            throw new IllegalArgumentException("Cannot create " + diagnosticDirectory);
        }
        Diagnostics.unlockFiles(Arrays.asList(diagnosticDirectory.listFiles()));
        Diagnostics.diagnosticDirectory = diagnosticDirectory;
    }

    public static boolean isLockedFile(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".locked") || fileName.endsWith(".lck");
    }

    public static boolean isOn() {
        if (isOn == null) {
            isOn = Boolean.getBoolean("ide.savediagnostics");
        }
        return isOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File newLockedFile(String prefix) {
        if (!Diagnostics.isOn()) {
            return null;
        }
        File file = Diagnostics.newFile(prefix);
        if (file == null) {
            return null;
        }
        file = new File(file.getPath() + ".locked");
        Object object = SHUTDOWN_LOCK;
        synchronized (object) {
            lockedFiles.add(file);
            if (!installedShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Collection files;
                        Object object = SHUTDOWN_LOCK;
                        synchronized (object) {
                            files = lockedFiles;
                            lockedFiles = new ArrayList();
                        }
                        Diagnostics.unlockFiles(files);
                    }
                });
                installedShutdownHook = true;
            }
            return file;
        }
    }

    private static void unlockFiles(Collection<File> files) {
        for (File file : files) {
            if (!file.getName().endsWith(".locked")) continue;
            file.renameTo(new File(file.getPath().substring(0, file.getPath().length() - ".locked".length())));
        }
    }

    public static File newFile(String prefix, String suffix) {
        File file;
        if (!Diagnostics.isOn()) {
            return null;
        }
        diagnosticDirectory.mkdirs();
        if (!diagnosticDirectory.canWrite()) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        name.append(Version.NAME_SHORT.toUpperCase());
        if (prefix != null && !prefix.isEmpty()) {
            name.append("-" + prefix + "-");
        }
        Calendar calendar = Calendar.getInstance();
        name.append(calendar.get(1));
        Diagnostics.append(name, calendar.get(2) + 1, 2);
        Diagnostics.append(name, calendar.get(5), 2);
        name.append('-');
        Diagnostics.append(name, calendar.get(11), 2);
        Diagnostics.append(name, calendar.get(12), 2);
        Diagnostics.append(name, calendar.get(13), 2);
        if (suffix != null && !suffix.isEmpty()) {
            name.append("-" + suffix);
        }
        if ((file = new File(diagnosticDirectory, name + ".txt")).exists() && !file.canWrite()) {
            return null;
        }
        return file;
    }

    public static File newFile(String prefix) {
        return Diagnostics.newFile(prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBanner(Writer w, String bannerText) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(w);
            writer.println(Diagnostics.repeat('-', 79));
            writer.print(Diagnostics.repeat('-', 2));
            writer.print(" ");
            writer.println(bannerText);
            writer.println(Diagnostics.repeat('-', 79));
        }
        finally {
            if (writer != null) {
                writer.flush();
            }
        }
    }

    public static void writeSystemConfiguration(Writer w) throws IOException {
        w.append(Diagnostics.systemProperties());
    }

    private static String repeat(char c, int num) {
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private static void append(StringBuilder buffer, int value, int width) {
        String string = String.valueOf(value);
        for (int i = string.length(); i < width; ++i) {
            buffer.append('0');
        }
        buffer.append(string);
    }

    public static String basicConfigurationData() {
        StringBuilder sb = new StringBuilder();
        sb.append("Label=").append(Version.BUILD_LABEL).append("\n");
        sb.append("Platform=").append(System.getProperty("os.name")).append("\n");
        sb.append("JavaVersion=").append(System.getProperty("java.version")).append("\n");
        sb.append("Editions=").append(System.getProperty("ide.editions")).append("\n");
        sb.append("Role=").append(System.getProperty("ide.role")).append("\n");
        sb.append("FirstRun=").append(System.getProperty("ide.firstrun")).append("\n");
        sb.append("DevBuild=").append(System.getProperty("ide.devbuild")).append("\n");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String systemProperties() {
        Properties properties;
        StringBuilder sb = new StringBuilder();
        sb.append("System properties:\n");
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                sb.append("  ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    static {
        SHUTDOWN_LOCK = new Object();
    }
}

